<?php

// Set some CONSTANTS
define('DIFFEN_API_URL','http://se.diffen.com/search.php?');
define('DIFFEN_API_QUERY','?embed');

// Set our comparison variables from the submitted form
$comps = array($_REQUEST['diffen_comp1'],$_REQUEST['diffen_comp2']);

// sort compare values alphabetically
usort($comps,'strnatcmp');

list($comp1,$comp2) = $comps;

// strip slashes, make lowercase, capitalize the first letter, URL encode
$comp1 = DiffenComparisonToolPlugin::sanitize($comp1);
$comp2 = DiffenComparisonToolPlugin::sanitize($comp2);

// generate the API URL string
$url = DIFFEN_API_URL . "e1={$comp1}&e2={$comp2}";

$response = wp_remote_get($url);
$r = print_r($response,true);

if ( is_wp_error($response) ) {
    throw new exception($response->get_error_message(),
                        $response->get_error_code());
}

if ( 404 == $response['response']['code'] ||
     404 == $response['body'] ) {
    header('HTTP/1.0 404 Not Found');
    exit();
}

if ( $redirect = $response['headers']['location'] ) {
    $url = $redirect;
}

// print the body (iframe code)
echo $response['body'];
