// URL to check for or connect to
var DIFFEN_URL = 'http://www.diffen.com/difference/';

// action to perform when search form is submitted
jQuery(document).on('submit','#diffen_comparison_tool_form',function() {
    // make sure values have been entered
    if ( '' == jQuery('#diffen_comp1').val() ||
         '' == jQuery('#diffen_comp2').val() ) {
        alert('Please enter valid search values');
        return false;
    }
    // make sure values aren't the same
    if ( jQuery('#diffen_comp1').val() == jQuery('#diffen_comp2').val() ) {
        alert('Please compare two different values');
        return false;
    }
    jQuery('#diffen_loading').fadeIn();
    // submit the form content
    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        dataType: 'html',
        data: jQuery('#diffen_comparison_tool_form').serializeArray(),
        success: function(data) {
            jQuery('#diffen iframe').replaceWith(data);
            var src = jQuery('#diffen iframe').attr('src');
            var w = jQuery('#diffen iframe').attr('width');
            var h = jQuery('#diffen iframe').attr('height');
            // generate the iFrame content
            jQuery('#diffen_resizable').animate({
                width: w,
                height: h,
            },1000,function() {
                jQuery('#diffen_loading').fadeOut();
                jQuery('#diffen input[type="button"]').attr('disabled',false);
                jQuery('#diffen input[type="button"]').addClass('button-primary');
                jQuery('#diffen_handle').show();
                jQuery('#diffen_resizable').resizable({
                    handles: {'s': '#diffen_handle'},
                    minWidth: 600,
                    maxWidth: 600,
                    minHeight: 130
                });
            });
            var themeHtml = '<hr/><p>Background options: <a id="dfnthemelight" class="diffen_theme dfnthemesel">Transparent/Light</a> | <a class="diffen_theme" id="dfnthemedark" href="#">Dark</a></p><hr/>';
            jQuery('#diffen_loading').after(themeHtml);
            jQuery("a.diffen_theme").click(function(e){
            	e.preventDefault();
            	var iframeSrc = jQuery('#diffen iframe')[0].src;
            	if(this.id=='dfnthemedark'){
            		if(iframeSrc.indexOf("theme=dark")<0){
            			iframeSrc += "&theme=dark";
            			jQuery('#diffen iframe')[0].src = iframeSrc;
            		}
            	}
            	else {
            		if(iframeSrc.indexOf("theme=dark")>0){
            			iframeSrc = iframeSrc.replace("&theme=dark","");
            			jQuery('#diffen iframe')[0].src = iframeSrc;
            		}
            	}
            	jQuery('.dfnthemesel').removeClass('dfnthemesel').attr('href','#');
            	jQuery(this).addClass('dfnthemesel');
            	this.href = '';
            });
        },
        error: function(xhr, ajaxOptions, thrownError) {
            jQuery('#diffen_loading').fadeOut();
            if ( 404 == xhr.status ) {
                alert('Sorry, we don\'t have info on the comparison you were looking for. Please try comparing something else.');
            }
        }
    });
    return false;
});
function diffen_gen_iframe(src,width,height) {
    return '<iframe src="' + src + '" id="diffen_comparison_tool_embed" width="' + width + '" height="' + height + '" style="border:0"></iframe>';
}
jQuery(document).ready(function() {
    /* embed the iFrame into a post */
    jQuery('#diffen input[type="button"]').click(function() {
        /* generate the iFrame code */ 
        var iframe = jQuery('#diffen iframe');
        var src = iframe.attr('src');
        var width = jQuery('#diffen_resizable').width();
        var height = jQuery('#diffen_resizable').height();
        var markup = diffen_gen_iframe(src,width,height);

        /* we need to figure out if we are in visual or HTML/text mode in the editor */
        var isVisual = jQuery('#edButtonPreview', window.parent.document).hasClass('active');
        /* WP 3.3+ */
        if ( !isVisual ) {
            isVisual = jQuery( '#wp-content-wrap', window.parent.document ).hasClass( 'tmce-active' );
        }

        var win = window.dialogArguments || opener || parent || top;
        if (isVisual) {
            var currentCode = win.tinyMCE.activeEditor.getContent();
        } else {
            var currentCode = jQuery('#editorcontainer textarea', window.parent.document).val();
            /* WP 3.3+ */
            if ( typeof currentCode != 'string' ) {
                currentCode = jQuery( '.wp-editor-area', window.parent.document ).val();
            }
        }

        /* if the iframe src exists, let's try to set it */
        if ( 'undefined' != typeof src ) {
            if ( -1 != src.indexOf(DIFFEN_URL) ) {
                if ( !isVisual ) {
                    // jquery
                    jQuery('#content',window.parent.document).val(currentCode + markup);
                } else {
                    win.tinyMCE.activeEditor.execCommand('mceInsertContent',false,markup); 
                }
                hidePopup();
            } else {
                alert('Please do a comparison first');
            }
        } else {
            alert('Please do a comparison first');
        }
    });
    function hidePopup () {
        try {
            // copied from wp-includes/js/thickbox/thickbox.js
            jQuery("#TB_imageOff", window.parent.document).unbind("click");
            jQuery("#TB_closeWindowButton", window.parent.document).unbind("click");
            jQuery("#TB_window", window.parent.document).fadeOut("fast");
            jQuery('#TB_window,#TB_overlay,#TB_HideSelect', window.parent.document).trigger("unload").unbind().remove();
            jQuery("#TB_load", window.parent.document).remove();
            if (typeof window.parent.document.body.style.maxHeight == "undefined") {//if IE 6
                jQuery("body","html", window.parent.document).css({height: "auto", width: "auto"});
                jQuery("html", window.parent.document).css("overflow","");
            }
            window.parent.document.onkeydown = "";
            window.parent.document.onkeyup = "";
            return false;
        } catch(e) {
            if (debug) {
                console.log("hidePopup(): " + e);
            }
        }
    }
});
