<?php
/*
Plugin Name: Diffen Comparison Tool
Plugin URI: http://www.diffen.com/difference/Diffen:Wordpress_Plugin
Description: The Diffen comparison plugin allows Wordpress bloggers to easily search for and embed a comparison on their blog. You can compare anything on Diffen.
Author: Tim Garrison <tim@impliedsolutions.com>, Nikhilesh Jasuja <jasuja@diffen.com>
Version: 2.1
Author URI: http://impliedsolutions.com/
*/

/* plugin version number */
define('DIFFEN_COMPARISON_TOOL_VERSION','1.0');

/* actions */
add_action('init',array('DiffenComparisonToolPlugin','init'));
add_action('media_buttons',array('DiffenComparisonToolPlugin',
   'viewButton'),999);
add_action('wp_ajax_diffenComparisonToolViewForm',
    array('DiffenComparisonToolPlugin','viewForm'));
add_action('wp_ajax_diffenComparisonActionAPI',
    array('DiffenComparisonToolPlugin','actionAPI'));

/* this runs when deactivating the plugin in WP */
register_deactivation_hook(__FILE__,
    array('DiffenComparisonToolPlugin','uninstall'));

Class DiffenComparisonToolPlugin {

    /* 
    * runs after WP is ready but before headers are sent
    * http://codex.wordpress.org/Plugin_API/Action_Reference/init 
    */
    static public function init() {
        add_action('admin_menu',
            array('DiffenComparisonToolPlugin','checkInstalled'));
        add_action('admin_menu',
            array('DiffenComparisonToolPlugin','initScripts'));
    }

    public static function checkInstalled() {
        if ( get_site_option('DIFFEN_COMPARISON_TOOL_VERSION') <
             DIFFEN_COMPARISON_TOOL_VERSION ) {
            self::install();
        }
    }

    public static function install() {
        /***
        * THIS IS WHERE YOU CAN INSTALL THE DB TABLE FOR FUTURE VERSIONS
        * IF NEEDED.
        ***/

        update_site_option('DIFFEN_COMPARISON_TOOL_VERSION',
            DIFFEN_COMPARISON_TOOL_VERSION);
    }

    public static function uninstall() {
        delete_option('DIFFEN_COMPARISON_TOOL_VERSION');
    }

    public static function initScripts() {
        $src = self::getBaseURL() . '/js/admin.js';
        wp_register_script('diffen-comparison-tool-script-admin',$src);
        wp_enqueue_script('diffen-comparison-tool-script-admin');
    }

    /*
    * gives us a starting point in the file system, used like DOC_ROOT
    */
    public static function getBasePath() {
        $folder = basename(dirname(__FILE__));
        return WP_PLUGIN_DIR . '/' . $folder;
    }

    /*
    * root URL for this plugin
    */
    public static function getBaseURL() {
        $folder = basename(dirname(__FILE__));
        return plugins_url($folder);
    }

    /*
    * embeds the button in the media row in the WP post editor
    */
    public static function viewButton() {
        $title = 'Add a Comparison';
        $site_url = esc_url(admin_url("/admin-ajax.php?post_id={$iframe_post_id}&action=diffenComparisonToolViewForm&TB_iframe=true&width=960&height=686"));
        echo "<a href=\"{$site_url}&id=add_comparison\" class=\"thickbox button\" id=\"diffen_tb\" title=\"{$title} (powered by Diffen.com)\"> {$title}</a>";
    }
    
    /*
    * displays the form inside thickbox when the viewButton is clicked
    */
    public static function viewForm() {
        require_once(self::getBasePath().'/view.form.php');
        exit();
    }

    /*
    * processes the form submission
    */
    public static function actionAPI() {
        require_once(self::getBasePath().'/action.api.php');
        exit();
    }

    /* 
    * sanitize for passing to diffen api
    */
    public static  function sanitize($str) {
        $str = ucwords(strtolower(stripslashes($str)));
        $str = str_replace(' ','_',$str);
        return urlencode($str);
    }

}

/*******
*
* This is adapted from a comment on: http://php.net/manual/en/function.http-parse-headers.php
* Since we need to get the final redirect Location to reduce future server load,
* we parse the return header and it gives us the Location
*
*******/
function diffen_get_headers($header) {
    $retVal = array();
    $fields = explode("\r\n", preg_replace('/\x0D\x0A[\x09\x20]+/', ' ', $header));
    foreach( $fields as $field ) {
        if( preg_match('/([^:]+): (.+)/m', $field, $match) ) {
            $match[1] = preg_replace('/(?<=^|[\x09\x20\x2D])./e', 'strtoupper("\0")', strtolower(trim($match[1])));
            if( isset($retVal[$match[1]]) ) {
                if (!is_array($retVal[$match[1]])) {
                    $retVal[$match[1]] = array($retVal[$match[1]]);
                }
                $retVal[$match[1]][] = $match[2];
            } else {
                $retVal[$match[1]] = trim($match[2]);
            }
        }
    }
    return $retVal;
}
