<?php
/**
Plugin Name: Sitesassure WP Malware Scanner
Plugin URI: http://sitesassure.com/
Description: The Sitesassure WP Malware Scanner Plug-in provides manual malware scan reports: clean, malware, upgrade and blacklisted status.
Version: 1.0.1
Author: sitesassure
Author URI: http://www.sitesassure.com/
License: GPLv2 or later
**/
?>
<?php
// Make sure we don't expose any info if called directly
if ( !function_exists( 'add_action' ) ) {
	echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
	exit;
}
global $wpdb;
define('SWMS_VERSION', '1.0');
define('SWMS_PLUGIN_URL', plugin_dir_url( __FILE__ ));
define('SWMS_PLUGIN_ABSPATH',plugin_dir_path( __FILE__ ) );
define('SWMS_PLUGIN_ASSETSPATH',plugin_dir_url( __FILE__ ).'assets/' );
define('SWMS_ACTIVE_STATUS', 1);
define('SWMS_INACTIVE_STATUS', 2);
define('SWMS_UNINSTALL_STATUS', 3);
define('SWMS_INSERT_REQUEST', 1);
define('SWMS_UPDATE_REQUEST', 2);
define('SWMS_DELETE_REQUEST',3);
define('SWMS_REQUEST_URL', "http://sitesassure.com/wp_scanner/scan.php");
define('SWMS_SCAN_TABLE',  $wpdb->prefix."swms_scanner_manage");
define('SWMS_QUTTERA_URL', "http://scannerapi.quttera.com/api/v3/59c7deaa94d710728275b1c10040bbb5/url/");
define('SWMS_QUTTERA_API', "api/v3/59c7deaa94d710728275b1c10040bbb5/url/scan/");
$swms_qurl = get_option('swms_quttera_api_url');
$swms_qapi = get_option('swms_quttera_api');
require_once SWMS_PLUGIN_ABSPATH . 'sql.php';
register_activation_hook( __FILE__, array( 'SitesassureInstallScript', 'swms_install' ) );
register_deactivation_hook( __FILE__, 'swms_sitesassureDeactivate' );
add_action( 'plugins_loaded', 'swms_verify_sitesassure_status' );
register_uninstall_hook( __FILE__,'swms_uninstall_plugin');
function _getWPDB(){ global $wpdb; return $wpdb; }
@ini_set( 'max_execution_time', 900 );

?>
<?php
add_action('admin_menu', 'swms_scanner_menu',10);
add_action( 'admin_enqueue_scripts', 'swms_scanner_enqueued_assets',10);
add_action("swms_afterSubmit","swms_updateScanRequest",10,2);
add_action('admin_menu', 'swms_report_view');

function swms_report_view() {
	add_submenu_page( 'NULL', 'Report', 'Report', 'administrator', 'swms_scanner_report_page','swms_scanner_report_page');
}

function swms_updateScanRequest($scanurl,$email)
{
	$exist = swms_checkAlreadyExist($scanurl);
	foreach($exist as $ex)
	{
		$added_by = $ex->email;
	}	
	if(empty($exist))
	{
		swms_updateScanUrl($scanurl,$email);
		swms_sendScanRequest($scanurl,$email);
	}else
	{
		$error_msg = $scanurl." is already added by ". $added_by;
		_e('<h3 class="error">'.$error_msg.'</h3>','swms');
		
	}
}

function swms_checkAlreadyExist($scanurl){
	
	return _getWPDB()->get_results("SELECT * FROM ".SWMS_SCAN_TABLE." WHERE scanned_url LIKE '%$scanurl%'");

}

function swms_updateScanUrl($scanurl,$email)
{

	_getWPDB()->insert(SWMS_SCAN_TABLE,array("created_at" => date("Y-m-d H:i:s"),"scanned_url" => $scanurl,"email" => $email,"status" => 1,"user_id" => get_current_user_id()));

}

function swms_getAllSites()
{

	return _getWPDB()->get_results("SELECT * FROM ".SWMS_SCAN_TABLE." ORDER BY id DESC");

}

function swms_getSitereport($url){
	
	return _getWPDB()->get_results("SELECT `scan_status` FROM `wp_swms_scanner_manage` WHERE `scanned_url` = '$url'");

}
	
function swms_scanner_enqueued_assets() {
    wp_enqueue_style( 'swms-scanner-style', SWMS_PLUGIN_ASSETSPATH . 'css/sa-style.css' );
	wp_enqueue_style( 'swms-scanner-font-style', SWMS_PLUGIN_ASSETSPATH . 'css/font-awesome.min.css' );
	wp_register_script('swms-custom-script', SWMS_PLUGIN_ASSETSPATH . 'js/swms_ajax.js',array( 'jquery', 'json2'));
	wp_localize_script('swms-custom-script','wp_ajax',array('ajaxurl' => admin_url( 'admin-ajax.php' ),'ajaxnonce' => wp_create_nonce( 'ajax_post_validation' )));
	wp_enqueue_script( 'swms-custom-script' );
}
?>
<?php
function swms_scanner_menu() {
	add_menu_page('SitesAssure Scanner', 'SA Scanner', 'administrator', 'swms_scanner', 'swms_scanner_dashboard_page', SWMS_PLUGIN_ASSETSPATH.'images/icon.png');
	add_submenu_page( 'swms_scanner', 'Dashboard', 'Dashboard', 'administrator', 'swms_scanner');
	add_submenu_page( 'swms_scanner', 'Submit Urls', 'Submit Urls', 'administrator', 'swms_scanner_submit_url','swms_scanner_settings_page');
	add_submenu_page( 'swms_scanner', 'Generate Report', 'Generate Report', 'administrator', 'swms_scanner_generate_report','swms_scanner_settings_sub_page');
	add_submenu_page( 'swms_scanner', 'Purchase Firewall', 'Purchase Firewall', 'administrator', 'swms_scanner_purchase_page','swms_scanner_purchase_page');
	add_submenu_page( 'swms_scanner', 'FAQ', 'FAQ / SUPPORT', 'administrator', 'swms_scanner_faq_page','swms_scanner_faq_page');
	
}


function swms_scanner_settings_sub_page()
{
	$allsites = swms_getAllSites();
?>
	<div class="form-container">
		<div class="form-center">
			<div class="image-wrap sa-logo">
				<img src="<?php echo SWMS_PLUGIN_ASSETSPATH.'images/logo.png'?>" />
				<div id="swms-submit-message-status"></div>
				<div id="swms_submit_message"></div>
			</div>
			<?php if(!empty($allsites)){?>
			<table width="100%" border="0" cellpadding="10" class="table table-hover" id="swms_table" cellspacing="0">
				<thead>
					<tr>
						<th><?php _e('URL','swms');?></th>
						<th><?php _e('EMAIL','swms');?></th>
						<th><?php _e('ACTION','swms');?></th>
						<th><?php _e('LAST SCAN','swms');?></th>
						<th style="border-right:none;"><?php _e('RESULT','swms');?></th>
					</tr>
				</thead>
				<tbody>
					<?php 
						foreach($allsites as $key=>$all)
						{
							$swms_scanned_url = $all->scanned_url;
							echo '<tr>';
							echo '<td>'.$all->scanned_url.'</td>';
							echo '<td>'.$all->email.'</td>';
							echo '<td><a href="javascript:void();" onclick="swms_scan_now('."'".$all->scanned_url."'".','.$key.');" class="button sa-red-btn scan-btn">Scan</a>
							<a href="javascript:void();" onclick="swms_delete_now('."'".$all->scanned_url."'".','.$key.');" class="button sa-grey-btn delete-btn">Delete</a><br>';
							echo '<img src="'.SWMS_PLUGIN_ASSETSPATH.'/images/scanner.gif" id="scanner_'.$key.'" style="display:none;">';
							echo '<img src="'.SWMS_PLUGIN_ASSETSPATH.'/images/deleter.gif" id="deleter_'.$key.'" style="display:none;">';
							echo '</td>';
							echo '<td>'.$all->last_scan.'</td>';
							if($all->scan_status){
							echo '<td id="swms_report_'.$key.'"><a href="'.admin_url("admin.php?page=swms_scanner_report_page&swms_url=$swms_scanned_url").'" class="button sa-red-btn sa-report-btn">Report</a></td>';
							}
							echo '<td id="swms_result_'.$key.'"><span></span><br>';
							echo '<img src="'.SWMS_PLUGIN_ASSETSPATH.'/images/status.GIF" id="scannerc_'.$key.'" style="display:none;">';
							echo '</td>';
							echo '</tr>';
						} 
					 ?>
				</tbody>
			</table>
			<?php }else{ ?>
				<h2><?php _e("Still you didn't submitted any URL to scan","swms");?></h2>
			<?php } ?>
		</div>
		<div id="scanner_result_full">
			<h1 class="center">Scanner Report</h1>
			<div id="scanner_result">
			</div>
		</div>
	</div>
<?php }
?>
<?php
function swms_scanner_dashboard_page() {
  ?>
<div class="form-container">
	<div class="form-center">
		<div class="image-wrap sa-logo">
			<img src="<?php echo SWMS_PLUGIN_ASSETSPATH.'images/logo.png'?>" />
		</div>
		<div class="full-five text-center">
		<div class="one-five">
			<a href="<?php echo admin_url( 'admin.php?page=swms_scanner_submit_url');?>" title="" target="_top">
				<i class="fa fa-exchange"></i><br />
				<?php _e('Submit <br> Urls','swms');?>
			</a>
		</div>
		<div class="one-five">
			<a href="<?php echo admin_url( 'admin.php?page=swms_scanner_generate_report');?>" title="" target="_top">
				<i class="fa fa-file-text"></i><br />
				<?php _e('Generate <br> Report','swms');?>
			</a>
		</div>
		<div class="one-five">
			<a href="<?php echo admin_url( 'admin.php?page=swms_scanner_purchase_page');?>" title="" target="_top">
				<i class="fa fa-shopping-cart"></i><br />
				<?php _e('Purchase <br> Firewall','swms');?>
			</a>
		</div>
		<div class="one-five last">
			<a href="<?php echo admin_url( 'admin.php?page=swms_scanner_faq_page');?>" title="" target="_top">
				<i class="fa fa-question"></i><br />
				<?php _e("FAQ's <br> Support","swms");?>
			</a>
		</div>
		<br />
	</div>
	<h4 class="sa-intro"><?php _e('Sitesassure provides free website scanning and monitoring. Our scanner is a Meta-Scanner which uses multiple resources to produce accurate malware scanning results. <BR><BR>
1) To get started, click on Submit URL and fill in the form. <BR>
2) Next step, click on Generate Reports and click the scan button, You will get a message your URL was submitted successfully once you hit the scan button. And then Check Status Button will generate in the RESULT column. Click Check status button, The scan can take up to 15 minutes. When the scan is complete the Check Status button will change to REPORT.<BR>
3) The report will show if your site is<BR>
__A) Clean <BR>
__B) Malicious<BR>
__C) Suspicious<BR>
__D) Blacklisted<BR><BR>

If your site is infected you will see a CLEAN NOW button at the bottom of the report. Click the button to purchase fast malware removal.<BR><BR>
This plug-in provides scanning and reports only and does not protect your site. If your website has been hacked, you need to purchase a security firewall. Please click on Purchase Firewall for more information.','swms');

?>
	</h4>
	</div>
</div>
  <?php
}

function swms_scanner_settings_page() {
  ?>
<div class="form-container">
	<div class="form-center">
		<div class="image-wrap sa-logo">
			<img src="<?php echo SWMS_PLUGIN_ASSETSPATH.'images/logo.png'?>" />
		</div>
		<div class="scan-response">
			<?php
			$url_error = '';
			$mail_error = '';
			if(isset($_REQUEST['scan_action']) && $_REQUEST['scan_action'] == 'scanit')
			{
				$scan_url = $_REQUEST['site_url'];
				$email 	  = $_REQUEST['notify_email'];	
				if($scan_url == '' || filter_var($scan_url, FILTER_VALIDATE_URL) === FALSE )
				{
					$url_error = "Invalid URL. Check URL format starts with http:// or https://";
				}else if($email == '' && !filter_var($email, FILTER_VALIDATE_EMAIL))
				{
					$mail_error = "Invalid EMail";
				}else
				{
					do_action("swms_afterSubmit",$scan_url,$email);
				}
			}
			?>
		</div>
		<h2><?php _e( 'Scan Domain','swms');?></h2>	
		<form method="post" action="" class="form form-horizontal">
			<input type="hidden" name="scan_action" value="scanit" />
			<div class="form-group">
				<label><?php _e( 'Site Url','swms');?></label>
				<input type="text" name="site_url" value="" size="40"/>
				<br />
				<p class="error"><?php _e($url_error,'swms');?></p>
			</div>
			<div class="form-group">
				<label><?php _e('Email to Notify','swms');?></label>
				<input type="text" name="notify_email" value="" size="40" />
				<br />
				<p class="error"><?php _e($mail_error,"swms");?></p>
			</div>		
			<div class="form-group">
				<input type="submit" name="submit" value="<?php _e( 'Submit','swms');?>" class="button button-primary" />
			</div>
			
		</form>
	</div>
</div>
  <?php
}

function swms_scanner_purchase_page()
{
	include("inc/swms_firewall.php");
}
function swms_scanner_faq_page()
{
	include("inc/swms_faq.php");
}
function swms_scanner_report_page()
{
	include("inc/swms_report.php");
}

function swms_sendScanRequest($scanurl,$email)
{
	global $current_user;
    get_currentuserinfo();
	$site_domain = get_bloginfo('url');
	$req_url = SWMS_REQUEST_URL;
	$response = wp_remote_post( $req_url, array(
	'method' => 'POST',
	'timeout' => 45,
	'redirection' => 5,
	'httpversion' => '1.0',
	'blocking' => true,
	'headers' => array(),
	'body' => array("action" => SWMS_INSERT_REQUEST, 'domain' => $site_domain, 'scanurl' => $scanurl, "email" => $email, "status" => SWMS_ACTIVE_STATUS),
	'cookies' => array()
    )
	);
	if ( is_wp_error( $response ) ) {
	   $error_message = $response->get_error_message();
	   _e("Something went wrong: $error_message","swms");
	} else {
	   if($response['response']['code'] == 200 && $response['response']['message'] == "OK")
	   {
	   		$admin_message = 'Hi SA Admin,<br>'.$site_domain.' is installed WPSASCANNER plugin and submitted this URL '.$scanurl.' For Scan Report';
			$user_message = 'Hi '.$current_user->user_login.',<br>'.$scanurl.' has been submitted successfully.';
	   		swms_sendEmail(array('to' => 'support@sitesassure.com','subject' => $site_domain.' Subscription Message','message' => $admin_message));
			swms_sendEmail(array('to' => $current_user->user_email,'subject' => $site_domain.' Subscription Message','message' => $user_message));
			$swms_greport = admin_url('admin.php?page=swms_scanner_generate_report');
	   		_e('<h3>'.$response['body'].' Please check page <a href="'.$swms_greport.'"><b>Generate Report</b></a> to intiate the scan. <h3>' ,'swms');
	   }else
	   {
	   		_e('<h3>Something went wrong in file write</h3>' ,'swms').'<br>';
	   		_e('<h4>'.$response['response']['code'].'</h4>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['message'].'</h4>' ,'swms').'<br>';
	   }
	}
}
function swms_sitesassureDeactivate()
{
	$site_domain = get_bloginfo('url');
	$req_url = SWMS_REQUEST_URL;
	$response = wp_remote_post( $req_url, array(
	'method' => 'POST',
	'timeout' => 45,
	'redirection' => 5,
	'httpversion' => '1.0',
	'blocking' => true,
	'headers' => array(),
	'body' => array("action" => SWMS_UPDATE_REQUEST, 'domain' => $site_domain, "status" => SWMS_INACTIVE_STATUS),
	'cookies' => array()
    )
	);
	if ( is_wp_error( $response ) ) {
	   $error_message = $response->get_error_message();
	   _e("Something went wrong: $error_message","swms");
	} else {
	   if($response['response']['code'] == 200 && $response['response']['message'] == "OK")
	   {
	   		$message = 'Hi SA Admin,<br>'.$site_domain.' is deactivated the WPSASCANNER plugin';
	   		swms_sendEmail(array('to' => 'support@sitesassure.com','subject' => $site_domain.' Deactivated Message','message' => $message));
		}else
	   {
	   		_e('<h3>Something went wrong in sitesassure update</h3>' ,'swms').'<br>';
	   		_e('<h4>'.$response['response']['code'].'</h4>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['message'].'</h4>' ,'swms').'<br>';
	   }
	}
}
function swms_verify_sitesassure_status()
{
	$site_domain = get_bloginfo('url');
	$req_url = SWMS_REQUEST_URL;
	$response = wp_remote_post( $req_url, array(
	'method' => 'POST',
	'timeout' => 45,
	'redirection' => 5,
	'httpversion' => '1.0',
	'blocking' => true,
	'headers' => array(),
	'body' => array("action" => SWMS_UPDATE_REQUEST, 'domain' => $site_domain, "status" => SWMS_ACTIVE_STATUS),
	'cookies' => array()
	)
	);
	if ( is_wp_error( $response ) ) {
	   $error_message = $response->get_error_message();
	   _e("Something went wrong: $error_message","swms");
	} else {
	   if($response['response']['code'] == 200 && $response['response']['message'] == "OK")
	   {
			//$message = 'Hi SA Admin<br>'.$site_domain.' is Activated the WPSASCANNER plugin';
	   }else
	   {
			_e('<h3>Something went wrong in file write</h3>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['code'].'</h4>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['message'].'</h4>' ,'swms').'<br>';
	   }
	}		
}
function swms_uninstall_plugin()
{
	$site_domain = get_bloginfo('url');
	$req_url = SWMS_REQUEST_URL;
	$response = wp_remote_post( $req_url, array(
	'method' => 'POST',
	'timeout' => 45,
	'redirection' => 5,
	'httpversion' => '1.0',
	'blocking' => true,
	'headers' => array(),
	'body' => array("action" => SWMS_UPDATE_REQUEST, 'domain' => $site_domain, "status" => SWMS_UNINSTALL_STATUS),
	'cookies' => array()
	)
	);
	if ( is_wp_error( $response ) ) {
	   $error_message = $response->get_error_message();
	   _e("Something went wrong: $error_message","swms");
	} else {
	   if($response['response']['code'] == 200 && $response['response']['message'] == "OK")
	   {
			$message = 'Hi SA Admin,<br>'.$site_domain.' is Uninstalled the WPSASCANNER plugin';
			swms_sendEmail(array('to' => 'support@sitesassure.com','subject' => $site_domain.' Unsubscription Message','message' => $message));
	   }else
	   {
			_e('<h3>Something went wrong in file write</h3>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['code'].'</h4>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['message'].'</h4>' ,'swms').'<br>';
	   }
	}	
	SitesassureInstallScript::swms_uninstall();
}
function swms_sendEmail($data) {
	$admin_mail = get_option( 'admin_email' );	
	$blog_name =  get_option( 'blogname' );
	add_filter( 'wp_mail_content_type', 'swms_set_html_content_type' );
	$headers = 'From:'.$blog_name.'<'.$admin_mail.'>' . "\r\n";
	$result = wp_mail( $data['to'], $data['subject'], $data['message'], $headers); 
	$result = true;
	remove_filter( 'wp_mail_content_type', 'swms_set_html_content_type' );
	return $result;
}
function swms_set_html_content_type() {
	return 'text/html';
}	

function swms_updateScanResult($url,$res)
{
	_getWPDB()->update(SWMS_SCAN_TABLE,array("last_scan" => date("Y-m-d H:i:s"),"scan_status" => $res), array('scanned_url' => $url));
	
}
function swms_deletScanURL($url)
{
	_getWPDB()->delete(SWMS_SCAN_TABLE, array( 'scanned_url' => $url ));
}
add_action('swms_delete_scan_url', 'swms_deletScanURL',10,1);
add_action('swms_update_after_scan', 'swms_updateScanResult',10,2);
add_action('wp_ajax_swms_get_scan_results', 'swms_get_scan_results');
add_action('wp_ajax_swms_get_scan_results_from_quttera', 'swms_get_scan_results_from_quttera');
add_action('wp_ajax_swms_get_status_results_from_quttera', 'swms_get_status_results_from_quttera');
add_action('wp_ajax_swms_get_status_report_from_quttera', 'swms_get_status_report_from_quttera');
add_action('wp_ajax_swms_get_admin_url', 'swms_get_admin_url');
add_action('wp_ajax_nopriv_swms_get_scan_results', 'swms_get_scan_results');
add_action('wp_ajax_swms_delete_scan_url', 'swms_delete_scan_url');
add_action('wp_ajax_nopriv_swms_delete_scan_url', 'swms_delete_scan_url');

function swms_get_scan_results_from_quttera(){
	$url = swms_get_domain($_POST['data']);
	global $swms_qurl, $swms_qapi;
	function is_iterable($var){
    return $var !== null 
        && (is_array($var) 
            || $var instanceof Traversable 
            || $var instanceof Iterator 
            || $var instanceof IteratorAggregate
            );
	}

	
	$ch = curl_init();
	$swms_curlv = $swms_qurl."scan/".$url.".json"; 
	$swms_curla = $swms_qapi.$url.".json";
	
	curl_setopt($ch, CURLOPT_URL, $swms_curlv);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $swms_curla);
	
	
	// receive server response ...
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	
	
	$quttera_scan = curl_exec ($ch);
	
	echo $quttera_scan; 
	exit();
	
}

function swms_get_status_results_from_quttera(){
	$url = swms_get_domain($_POST['data']);
	global $swms_qurl, $swms_qapi;
	function httpGet($url)
	{
		$ch = curl_init();  
	 
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
	    //  curl_setopt($ch,CURLOPT_HEADER, false); 
	 
		$output=curl_exec($ch);
	 
		curl_close($ch);
		return $output;
	}

	$swms_gvalue = $swms_qurl."status/".$url.".json";
	$quttera_status = httpGet($swms_gvalue);

    echo $quttera_status;
	exit();


}

function swms_get_status_report_from_quttera(){
	$url = swms_get_domain($_POST['data']);
	global $swms_qurl, $swms_qapi;
	function httpGet($url)
	{
		$ch = curl_init();  
	 
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
	//  curl_setopt($ch,CURLOPT_HEADER, false); 
	 
		$output=curl_exec($ch);
	 
		curl_close($ch);
		return $output;
	}
 $swms_reportv = $swms_qurl."report/".$url.".json";
$quttera_report =  httpGet($swms_reportv);

	echo $quttera_report;
	$url = $_POST['data'];
	do_action('swms_update_after_scan',$url,$quttera_report);
	exit();
}
 
function swms_get_admin_url(){
	$swms_scanned_url = $_POST['data'];
	$swms_admin_url = admin_url("admin.php?page=swms_scanner_report_page&swms_url=$swms_scanned_url");
	echo $swms_admin_url;
	exit;
}

function swms_delete_scan_url()
{
	$deleteurl = $_POST['data'];
	$site_domain = get_bloginfo('url');
	$req_url = SWMS_REQUEST_URL;
	$response = wp_remote_post( $req_url, array(
	'method' => 'POST',
	'timeout' => 45,
	'redirection' => 5,
	'httpversion' => '1.0',
	'blocking' => true,
	'headers' => array(),
	'body' => array("action" => SWMS_DELETE_REQUEST, 'domain' => $site_domain, 'scanurl' => $deleteurl),
	'cookies' => array()
    )
	);
	if ( is_wp_error( $response ) ) {
	   $error_message = $response->get_error_message();
	   echo "Something went wrong: $error_message";
	} else {
	   if($response['response']['code'] == 200 && $response['response']['message'] == "OK")
	   {
	   		do_action('swms_delete_scan_url',$deleteurl);
	   		_e($response['body'] ,'swms');
			exit();
			
	   }else
	   {
	   		_e('<h3>Something went wrong</h3>' ,'swms').'<br>';
	   		_e('<h4>'.$response['response']['code'].'</h4>' ,'swms').'<br>';
			_e('<h4>'.$response['response']['message'].'</h4>' ,'swms').'<br>';
	   }
	}
	
}
function swms_get_domain($url)
{
  $pieces = parse_url($url);
  $domain = isset($pieces['host']) ? $pieces['host'] : '';
  if (preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)) {
    return $regs['domain'];
  }
  return false;
}
?>