<?php
    // Default Value for Row Toggles
    $this->TS_VCSC_Row_Toggle_Defaults = array(
        'Large Devices'                 => 1200,
        'Medium Devices'                => 992,
        'Small Devices'                 => 768,
    );

    // Default Text Strings for TS Isotope Posts
    $this->TS_VCSC_Isotope_Posts_Language_Defaults = array(
        'ButtonFilter'		            => 'Filter Posts',        
        'ButtonLayout'		            => 'Change Layout',
        'ButtonSort'		            => 'Sort Criteria',
        // Standard Post Strings
        'Date' 				            => 'Post Date',        
        'Modified' 			            => 'Post Modified',        
        'Title' 			            => 'Post Title',        
        'Author' 			            => 'Post Author',        
        'PostID' 			            => 'Post ID',        
        'Comments' 			            => 'Number of Comments',
        // Layout Strings
        'SeeAll'			            => 'See All',
        'Timeline' 			            => 'Timeline',
        'Masonry' 			            => 'Centered Masonry',
        'FitRows'			            => 'Fit Rows',
        'StraightDown' 		            => 'Straigt Down',
        // WooCommerce Strings
        'WooFilterProducts'             => 'Filter Products',
        'WooTitle'                      => 'Product Title',
        'WooPrice'                      => 'Product Price',
        'WooRating'                     => 'Product Rating',
        'WooDate'                       => 'Product Date',
        'WooModified'                   => 'Product Modified',
        // General Strings
        'Categories'                    => 'Categories',
        'Tags'                          => 'Tags',
    );
    
    // Default Text Strings for TS Countdown
    $this->TS_VCSC_Countdown_Language_Defaults = array(
        'DayPlural'                     => 'Days',
        'DaySingular'                   => 'Day',
        'HourPlural'                    => 'Hours',
        'HourSingular'                  => 'Hour',
        'MinutePlural'                  => 'Minutes',
        'MinuteSingular'                => 'Minute',
        'SecondPlural'                  => 'Seconds',
        'SecondSingular'                => 'Second',
    );
    
    // Default Text Strings for TS Image Magnify
    $this->TS_VCSC_Magnify_Language_Defaults = array(
        'ZoomIn'                        => 'Zoom In',
        'ZoomOut'                       => 'Zoom Out',
        'ZoomLevel'                     => 'Zoom Level',
        'ChangeLevel'                   => 'Change Zoom Level',
        'Next'                          => 'Next',
        'Previous'                      => 'Previous',
        'Reset'                         => 'Reset Zoom',
        'Rotate'                        => 'Rotate Image',
        'Lightbox'                      => 'Show Image in Lightbox',
    );
    
    // Default Text Strings for TS Google Map
    $this->TS_VCSC_Google_Map_Language_Defaults = array(
        'TextCalcShow'                  => 'Show Address Input',
        'TextCalcHide'                  => 'Hide Address Input',
        'TextDirectionShow'             => 'Show Directions',
        'TextDirectionHide'             => 'Hide Directions',
        'TextResetMap'                  => 'Reset Map',
        'PrintRouteText' 			    => 'Print Route',
        'TextViewOnGoogle'              => 'View on Google',
        'TextButtonCalc'                => 'Show Route',
        'TextSetTarget'                 => 'Please enter your Start Address:',
        'TextGeoLocation'               => 'Get My Location',
        'TextTravelMode'                => 'Travel Mode',
        'TextDriving'                   => 'Driving',
        'TextWalking'                   => 'Walking',
        'TextBicy'                      => 'Bicycling',
        'TextWP'                        => 'Optimize Waypoints',
        'TextButtonAdd'                 => 'Add Stop on the Way',
        'TextDistance'                  => 'Total Distance:',
        'TextMapHome'                   => 'Home',
        'TextMapBikes'                  => 'Bicycle Trails',
        'TextMapTraffic'                => 'Traffic',
        'TextMapSpeedMiles'             => 'Miles Per Hour',
        'TextMapSpeedKM'                => 'Kilometers Per Hour',
        'TextMapNoData'                 => 'No Data Available!',
        'TextMapMiles'                  => 'Miles',
        'TextMapKilometes'              => 'Kilometers',
        'TextMapActivate'               => 'Show Google Map',
        'TextMapDeactivate'             => 'Hide Google Map',
    );
    
    // Default Lightbox Settings
    $this->TS_VCSC_Lightbox_Setting_Defaults = array(
        'thumbs'                        => 'bottom',
        'thumbsize'                     => 50,
        'animation'                     => 'random',
        'captions'                      => 'data-title',
        'closer'                        => 1, // true/false
        'duration'                      => 5000,
        'share'                         => 0, // true/false
        'loadapis'                      => 1, // true/false
        'social' 	                    => 'fb,tw,gp,pin',
        'notouch'                       => 1, // true/false
        'bgclose'			            => 1, // true/false
        'nohashes'			            => 1, // true/false
        'keyboard'			            => 1, // 0/1
        'fullscreen'		            => 1, // 0/1
        'zoom'				            => 1, // 0/1
        'fxspeed'			            => 300,
        'scheme'			            => 'dark',
        'removelight'                   => 0,
        'customlight'                   => 0,
        'customcolor'		            => '#ffffff',
        'backlight' 		            => '#ffffff',
        'usecolor' 		                => 0, // true/false
        'background'                    => '',
        'repeat'                        => 'no-repeat',
        'overlay'                       => '#000000',
        'noise'                         => '',
        'cors'                          => 0, // true/false
        'tapping'                       => 1, // true/false
        'scrollblock'                   => 'css',
    );
    
    // Define Global Array of Social Networks
    $this->TS_VCSC_Social_Networks_Array = array(
        "Email"                         => array("order" => 0,      "string" => "email",        "link" => "",       "class" => "ts-social-email",           "icon" => "ts-teamicon-email3"),
        "Phone"                         => array("order" => 1,      "string" => "phone",        "link" => "",       "class" => "ts-social-phone",           "icon" => "ts-teamicon-phone2"),
        "Cell"                          => array("order" => 2,      "string" => "cell",         "link" => "",       "class" => "ts-social-cell",            "icon" => "ts-teamicon-mobile"),
        "Portfolio"                     => array("order" => 3,      "string" => "portfolio",    "link" => "",       "class" => "ts-social-portfolio",       "icon" => "ts-teamicon-portfolio"),
        "Link"                          => array("order" => 4,      "string" => "link",         "link" => "",       "class" => "ts-social-link",            "icon" => "ts-teamicon-link"),
        "Behance"                       => array("order" => 5,      "string" => "behance",      "link" => "",       "class" => "ts-social-behance",         "icon" => "ts-teamicon-behance"),
        "Digg"                          => array("order" => 6,      "string" => "digg",         "link" => "",       "class" => "ts-social-digg",            "icon" => "ts-teamicon-digg1"),
        "Dribbble"                      => array("order" => 7,      "string" => "dribbble",     "link" => "",       "class" => "ts-social-dribbble",        "icon" => "ts-teamicon-dribbble1"),
        "Dropbox"                       => array("order" => 8,      "string" => "dropbox",      "link" => "",       "class" => "ts-social-dropbox",         "icon" => "ts-teamicon-dropbox1"),
        "Envato"                        => array("order" => 9,      "string" => "envato",       "link" => "",       "class" => "ts-social-envato",          "icon" => "ts-teamicon-envato"),
        "EverNote"                      => array("order" => 10,     "string" => "evernote",     "link" => "",       "class" => "ts-social-evernote",        "icon" => "ts-teamicon-evernote1"),
        "Facebook"                      => array("order" => 11,     "string" => "facebook",     "link" => "",       "class" => "ts-social-facebook",        "icon" => "ts-teamicon-facebook3"),
        "Flickr"                        => array("order" => 12,     "string" => "flickr",       "link" => "",       "class" => "ts-social-flickr",          "icon" => "ts-teamicon-flickr4"),
        "Github"                        => array("order" => 13,     "string" => "github",       "link" => "",       "class" => "ts-social-github",          "icon" => "ts-teamicon-github3"),
        "Google"                        => array("order" => 14,     "string" => "gplus",        "link" => "",       "class" => "ts-social-gplus",           "icon" => "ts-teamicon-googleplus1"),
        "Instagram"                     => array("order" => 15,     "string" => "instagram",    "link" => "",       "class" => "ts-social-instagram",       "icon" => "ts-teamicon-instagram"),
        "LastFM"                        => array("order" => 16,     "string" => "lastfm",       "link" => "",       "class" => "ts-social-lastfm",          "icon" => "ts-teamicon-lastfm2"),
        "LinkedIn"                      => array("order" => 17,     "string" => "linkedin",     "link" => "",       "class" => "ts-social-linkedin",        "icon" => "ts-teamicon-linkedin1"),
        "Paypal"                        => array("order" => 18,     "string" => "paypal",       "link" => "",       "class" => "ts-social-paypal",          "icon" => "ts-teamicon-paypal1"),
        "Picasa"                        => array("order" => 19,     "string" => "picasa",       "link" => "",       "class" => "ts-social-picasa",          "icon" => "ts-teamicon-picasa1"),
        "Pinterest"                     => array("order" => 20,     "string" => "pinterest",    "link" => "",       "class" => "ts-social-pinterest",       "icon" => "ts-teamicon-pinterest1"),
        "RSS"                           => array("order" => 21,     "string" => "rss",          "link" => "",       "class" => "ts-social-rss",             "icon" => "ts-teamicon-rss1"),
        "Skype"                         => array("order" => 22,     "string" => "skype",        "link" => "",       "class" => "ts-social-skype",           "icon" => "ts-teamicon-skype"),
        "Soundcloud"                    => array("order" => 23,     "string" => "soundcloud",   "link" => "",       "class" => "ts-social-soundcloud",      "icon" => "ts-teamicon-soundcloud"),
        "Spotify"                       => array("order" => 24,     "string" => "spotify",      "link" => "",       "class" => "ts-social-spotify",         "icon" => "ts-teamicon-spotify2"),
        "StumbleUpon"                   => array("order" => 25,     "string" => "stumbleupon",  "link" => "",       "class" => "ts-social-stumbleupon",     "icon" => "ts-teamicon-stumbleupon2"),
        "Twitter"                       => array("order" => 26,     "string" => "twitter",      "link" => "",       "class" => "ts-social-twitter",         "icon" => "ts-teamicon-twitter4"),
        "Tumblr"                        => array("order" => 27,     "string" => "tumblr",       "link" => "",       "class" => "ts-social-tumblr",          "icon" => "ts-teamicon-tumblr4"),
        "Vimeo"                         => array("order" => 28,     "string" => "vimeo",        "link" => "",       "class" => "ts-social-vimeo",           "icon" => "ts-teamicon-vimeo1"),
        "Xing"                          => array("order" => 29,     "string" => "xing",         "link" => "",       "class" => "ts-social-xing",            "icon" => "ts-teamicon-xing3"),
        "YouTube"                       => array("order" => 30,     "string" => "youtube",      "link" => "",       "class" => "ts-social-youtube",         "icon" => "ts-teamicon-youtube4"),
    );
    
    // Array with Rating Icons
    $this->TS_VCSC_RatingScaleIconsCompliant = array(
        array('ts-ecommerce-starfull1'			=> 'star'),
        array('ts-ecommerce-starfull2'			=> 'star'),
        array('ts-ecommerce-starfull3'			=> 'star'),
        array('ts-ecommerce-starfull4'			=> 'star'),
        array('ts-ecommerce-heartfull'			=> 'heart'),
        array('ts-ecommerce-heart'				=> 'heart'),
        array('ts-ecommerce-thumbsup'			=> 'thumbs'),
        array('ts-ecommerce-ribbon4'			=> 'ribbon'),
    );
    
    // Array with Navigator Icons
    $this->TS_VCSC_NavigatorIconsCompliant = array(
        array('dashicons-arrow-up-alt'          => 'arrow up alt'),
        array('dashicons-arrow-up'              => 'arrow up'),
        array('dashicons-arrow-up-alt2'         => 'arrow up alt 2'),
        array('dashicons-menu'                  => 'menu'),
        array('dashicons-admin-home'			=> 'home'),
        array('dashicons-admin-site'            => 'globe'),
        array('dashicons-heart'                 => 'heart'),
        array('dashicons-star-filled'			=> 'star filled'),
        array('dashicons-star-empty'			=> 'star empty'),
        array('dashicons-smiley'			    => 'miley'),
    );
    
    // Array with Hover Effects Icons
    $this->TS_VCSC_HoverEffectsIconsSelectionCompliant = array(
        array("transparent" 			        => ""),
        array("ts-teamicon-email10" 			=> "email"),
        array("ts-teamicon-link6"				=> "link"),
        array("ts-teamicon-portfolio"			=> "portfolio"),
        array("ts-teamicon-download7" 			=> "download"),				
        array("ts-teamicon-star"				=> "star"),
        array("ts-teamicon-star2"				=> "star"),
        array("ts-teamicon-star2"				=> "star"),				
        array("ts-teamicon-heart"				=> "heart"),
        array("ts-teamicon-heart2"				=> "heart"),
        array("ts-teamicon-heart-broken"		=> "heart"),				
        array("ts-teamicon-thumbs-up2"			=> "thumbs"),
        array("ts-teamicon-thumbs-up"			=> "thumbs"),				
        array("ts-teamicon-tag"					=> "tag"),
        array("ts-teamicon-tags"				=> "tags"),				
        array("ts-teamicon-cog"					=> "cog"),
        array("ts-teamicon-cogs"				=> "cogs"),
        array("ts-teamicon-cog2"				=> "cog"),				
        array("ts-teamicon-home"				=> "home"),
        array("ts-teamicon-home2"				=> "home"),
        array("ts-teamicon-home3"				=> "home"),				
        array("ts-teamicon-user"				=> "user"),
        array("ts-teamicon-user2"				=> "user"),
        array("ts-teamicon-user3"				=> "user"),
        array("ts-teamicon-user4"				=> "user"),				
        array("ts-teamicon-users"				=> "users"),
        array("ts-teamicon-users2"				=> "users"),				
        array("ts-teamicon-eye5"				=> "eye"),
        array("ts-teamicon-info3"				=> "info"),
        array("ts-teamicon-calendar1"			=> "calendar"),
        array("ts-teamicon-clock1"				=> "clock"),
        array("ts-teamicon-location1"			=> "location"),
        array("ts-teamicon-file11"				=> "word"),
        array("ts-teamicon-file10"				=> "excel"),
        array("ts-teamicon-file13"				=> "pdf"),
        array("ts-teamicon-file15"				=> "nlank"),
        array("ts-teamicon-wikipedia"			=> "wikipedia"),
        array("ts-teamicon-facebook1"			=> "facebook"),
        array("ts-teamicon-twitter4"			=> "twitter"),
        array("ts-teamicon-googleplus1"			=> "google"),
    );
    
    // Timezone Options
    $this->TS_VCSC_Timezones = array(
        'Local / Server Time'           => "false",
        'Pacific/Midway'                => "(GMT-11:00) Midway Island",
        'US/Samoa'                      => "(GMT-11:00) Samoa",
        'US/Hawaii'                     => "(GMT-10:00) Hawaii",
        'US/Alaska'                     => "(GMT-09:00) Alaska",
        'US/Pacific'                    => "(GMT-08:00) Pacific Time (US &amp; Canada)",
        'America/Tijuana'               => "(GMT-08:00) Tijuana",
        'US/Arizona'                    => "(GMT-07:00) Arizona",
        'US/Mountain'                   => "(GMT-07:00) Mountain Time (US &amp; Canada)",
        'America/Chihuahua'             => "(GMT-07:00) Chihuahua",
        'America/Mazatlan'              => "(GMT-07:00) Mazatlan",
        'America/Mexico_City'           => "(GMT-06:00) Mexico City",
        'America/Monterrey'             => "(GMT-06:00) Monterrey",
        'Canada/Saskatchewan'           => "(GMT-06:00) Saskatchewan",
        'US/Central'                    => "(GMT-06:00) Central Time (US &amp; Canada)",
        'US/Eastern'                    => "(GMT-05:00) Eastern Time (US &amp; Canada)",
        'US/East-Indiana'               => "(GMT-05:00) Indiana (East)",
        'America/Bogota'                => "(GMT-05:00) Bogota",
        'America/Lima'                  => "(GMT-05:00) Lima",
        'America/Caracas'               => "(GMT-04:30) Caracas",
        'Canada/Atlantic'               => "(GMT-04:00) Atlantic Time (Canada)",
        'America/La_Paz'                => "(GMT-04:00) La Paz",
        'America/Santiago'              => "(GMT-04:00) Santiago",
        'Canada/Newfoundland'           => "(GMT-03:30) Newfoundland",
        'America/Buenos_Aires'          => "(GMT-03:00) Buenos Aires",
        'Greenland'                     => "(GMT-03:00) Greenland",
        'Atlantic/Stanley'              => "(GMT-02:00) Stanley",
        'Atlantic/Azores'               => "(GMT-01:00) Azores",
        'Atlantic/Cape_Verde'           => "(GMT-01:00) Cape Verde Is.",
        'Africa/Casablanca'             => "(GMT) Casablanca",
        'Europe/Dublin'                 => "(GMT) Dublin",
        'Europe/Lisbon'                 => "(GMT) Lisbon",
        'Europe/London'                 => "(GMT) London",
        'Africa/Monrovia'               => "(GMT) Monrovia",
        'Europe/Amsterdam'              => "(GMT+01:00) Amsterdam",
        'Europe/Belgrade'               => "(GMT+01:00) Belgrade",
        'Europe/Berlin'                 => "(GMT+01:00) Berlin",
        'Europe/Bratislava'             => "(GMT+01:00) Bratislava",
        'Europe/Brussels'               => "(GMT+01:00) Brussels",
        'Europe/Budapest'               => "(GMT+01:00) Budapest",
        'Europe/Copenhagen'             => "(GMT+01:00) Copenhagen",
        'Europe/Ljubljana'              => "(GMT+01:00) Ljubljana",
        'Europe/Madrid'                 => "(GMT+01:00) Madrid",
        'Europe/Paris'                  => "(GMT+01:00) Paris",
        'Europe/Prague'                 => "(GMT+01:00) Prague",
        'Europe/Rome'                   => "(GMT+01:00) Rome",
        'Europe/Sarajevo'               => "(GMT+01:00) Sarajevo",
        'Europe/Skopje'                 => "(GMT+01:00) Skopje",
        'Europe/Stockholm'              => "(GMT+01:00) Stockholm",
        'Europe/Vienna'                 => "(GMT+01:00) Vienna",
        'Europe/Warsaw'                 => "(GMT+01:00) Warsaw",
        'Europe/Zagreb'                 => "(GMT+01:00) Zagreb",
        'Europe/Athens'                 => "(GMT+02:00) Athens",
        'Europe/Bucharest'              => "(GMT+02:00) Bucharest",
        'Africa/Cairo'                  => "(GMT+02:00) Cairo",
        'Africa/Harare'                 => "(GMT+02:00) Harare",
        'Europe/Helsinki'               => "(GMT+02:00) Helsinki",
        'Europe/Istanbul'               => "(GMT+02:00) Istanbul",
        'Asia/Jerusalem'                => "(GMT+02:00) Jerusalem",
        'Europe/Kiev'                   => "(GMT+02:00) Kyiv",
        'Europe/Minsk'                  => "(GMT+02:00) Minsk",
        'Europe/Riga'                   => "(GMT+02:00) Riga",
        'Europe/Sofia'                  => "(GMT+02:00) Sofia",
        'Europe/Tallinn'                => "(GMT+02:00) Tallinn",
        'Europe/Vilnius'                => "(GMT+02:00) Vilnius",
        'Asia/Baghdad'                  => "(GMT+03:00) Baghdad",
        'Asia/Kuwait'                   => "(GMT+03:00) Kuwait",
        'Africa/Nairobi'                => "(GMT+03:00) Nairobi",
        'Asia/Riyadh'                   => "(GMT+03:00) Riyadh",
        'Asia/Tehran'                   => "(GMT+03:30) Tehran",
        'Europe/Moscow'                 => "(GMT+04:00) Moscow",
        'Asia/Baku'                     => "(GMT+04:00) Baku",
        'Europe/Volgograd'              => "(GMT+04:00) Volgograd",
        'Asia/Muscat'                   => "(GMT+04:00) Muscat",
        'Asia/Tbilisi'                  => "(GMT+04:00) Tbilisi",
        'Asia/Yerevan'                  => "(GMT+04:00) Yerevan",
        'Asia/Kabul'                    => "(GMT+04:30) Kabul",
        'Asia/Karachi'                  => "(GMT+05:00) Karachi",
        'Asia/Tashkent'                 => "(GMT+05:00) Tashkent",
        'Asia/Kolkata'                  => "(GMT+05:30) Kolkata",
        'Asia/Kathmandu'                => "(GMT+05:45) Kathmandu",
        'Asia/Yekaterinburg'            => "(GMT+06:00) Ekaterinburg",
        'Asia/Almaty'                   => "(GMT+06:00) Almaty",
        'Asia/Dhaka'                    => "(GMT+06:00) Dhaka",
        'Asia/Novosibirsk'              => "(GMT+07:00) Novosibirsk",
        'Asia/Bangkok'                  => "(GMT+07:00) Bangkok",
        'Asia/Jakarta'                  => "(GMT+07:00) Jakarta",
        'Asia/Krasnoyarsk'              => "(GMT+08:00) Krasnoyarsk",
        'Asia/Chongqing'                => "(GMT+08:00) Chongqing",
        'Asia/Hong_Kong'                => "(GMT+08:00) Hong Kong",
        'Asia/Kuala_Lumpur'             => "(GMT+08:00) Kuala Lumpur",
        'Australia/Perth'               => "(GMT+08:00) Perth",
        'Asia/Singapore'                => "(GMT+08:00) Singapore",
        'Asia/Taipei'                   => "(GMT+08:00) Taipei",
        'Asia/Ulaanbaatar'              => "(GMT+08:00) Ulaan Bataar",
        'Asia/Urumqi'                   => "(GMT+08:00) Urumqi",
        'Asia/Irkutsk'                  => "(GMT+09:00) Irkutsk",
        'Asia/Seoul'                    => "(GMT+09:00) Seoul",
        'Asia/Tokyo'                    => "(GMT+09:00) Tokyo",
        'Australia/Adelaide'            => "(GMT+09:30) Adelaide",
        'Australia/Darwin'              => "(GMT+09:30) Darwin",
        'Asia/Yakutsk'                  => "(GMT+10:00) Yakutsk",
        'Australia/Brisbane'            => "(GMT+10:00) Brisbane",
        'Australia/Canberra'            => "(GMT+10:00) Canberra",
        'Pacific/Guam'                  => "(GMT+10:00) Guam",
        'Australia/Hobart'              => "(GMT+10:00) Hobart",
        'Australia/Melbourne'           => "(GMT+10:00) Melbourne",
        'Pacific/Port_Moresby'          => "(GMT+10:00) Port Moresby",
        'Australia/Sydney'              => "(GMT+10:00) Sydney",
        'Asia/Vladivostok'              => "(GMT+11:00) Vladivostok",
        'Asia/Magadan'                  => "(GMT+12:00) Magadan",
        'Pacific/Auckland'              => "(GMT+12:00) Auckland",
        'Pacific/Fiji'                  => "(GMT+12:00) Fiji",
    );
    
    // Google GeoMap Chart Options
    $this->TS_VCSC_GeoMap_Regions = array(
        "World"                                                 => "world",
        "Continent: Africa"                                     => "002",
        "Continent: Europe"                                     => "150",
        "Continent: Americas"                                   => "019",
        "Continent: Asia"                                       => "142",
        "Continent: Oceania"                                    => "009",
        "Sub-Continent: Africa - Northern"                      => "015",
        "Sub-Continent: Africa - Western"                       => "011",
        "Sub-Continent: Africa - Middle"                        => "017",
        "Sub-Continent: Africa - Eastern"                       => "014",
        "Sub-Continent: Africa - Southern"                      => "018",
        "Sub-Continent: Europe - Northern"                      => "154",
        "Sub-Continent: Europe - Western"                       => "155",
        "Sub-Continent: Europe - Eastern"                       => "151",
        "Sub-Continent: Europe - Southern"                      => "039",
        "Sub-Continent: Americas - Northern"                    => "021",
        "Sub-Continent: Americas - Caribbean"                   => "029",
        "Sub-Continent: Americas - Central"                     => "013",
        "Sub-Continent: Americas - South"                       => "005",
        "Sub-Continent: Asia - Central"                         => "143",
        "Sub-Continent: Asia - Eastern"                         => "030",
        "Sub-Continent: Asia - Southern"                        => "034",
        "Sub-Continent: Asia - Southern-Eastern"                => "035",
        "Sub-Continent: Asia - Western"                         => "145",
        "Sub-Continent: Oceania - Australia and New Zealand"    => "053",
        "Sub-Continent: Oceania - Melanesia"                    => "054",
        "Sub-Continent: Oceania - Micronesia"                   => "057",
        "Sub-Continent: Oceania - Polynesia"                    => "061",
        "Country: Afghanistan"                                  => "AF",
        "Country: Aland Islands"                                => "AX",
        "Country: Albania"                                      => "AL",
        "Country: Algeria"                                      => "DZ",
        "Country: American Samoa"                               => "AS",
        "Country: Andorra"                                      => "AD",
        "Country: Angola"                                       => "AO",
        "Country: Anguilla"                                     => "AI",
        "Country: Antarctica"                                   => "AQ",
        "Country: Antigua and Barbuda"                          => "AG",
        "Country: Argentina"                                    => "AR",
        "Country: Armenia"                                      => "AM",
        "Country: Aruba"                                        => "AW",
        "Country: Australia"                                    => "AU",
        "Country: Austria"                                      => "AT",
        "Country: Azerbaijan"                                   => "AZ",
        "Country: Bahamas"                                      => "BS",
        "Country: Bahrain"                                      => "BH",
        "Country: Bangladesh"                                   => "BD",
        "Country: Barbados"                                     => "BB",
        "Country: Belarus"                                      => "BY",
        "Country: Belgium"                                      => "BE",
        "Country: Belize"                                       => "BZ",
        "Country: Benin"                                        => "BJ",
        "Country: Bermuda"                                      => "BM",
        "Country: Bhutan"                                       => "BT",
        "Country: Bolivia, Plurinational State of"              => "BO",
        "Country: Bonaire, Sint Eustatius and Saba"             => "BQ",
        "Country: Bosnia and Herzegovina"                       => "BA",
        "Country: Botswana"                                     => "BW",
        "Country: Bouvet Island"                                => "BV",
        "Country: Brazil"                                       => "BR",
        "Country: British Indian Ocean Territory"               => "IO",
        "Country: Brunei Darussalam"                            => "BN",
        "Country: Bulgaria"                                     => "BG",
        "Country: Burkina Faso"                                 => "BF",
        "Country: Burundi"                                      => "BI",
        "Country: Cambodia"                                     => "KH",
        "Country: Cameroon"                                     => "CM",
        "Country: Canada"                                       => "CA",
        "Country: Cape Verde"                                   => "CV",
        "Country: Cayman Islands"                               => "KY",
        "Country: Central African Republic"                     => "CF",
        "Country: Chad"                                         => "TD",
        "Country: Chile"                                        => "CL",
        "Country: China"                                        => "CN",
        "Country: Christmas Island"                             => "CX",
        "Country: Cocos (Keeling) Islands"                      => "CC",
        "Country: Colombia"                                     => "CO",
        "Country: Comoros"                                      => "KM",
        "Country: Congo"                                        => "CG",
        "Country: Congo, the Democratic Republic of the"        => "CD",
        "Country: Cook Islands"                                 => "CK",
        "Country: Costa Rica"                                   => "CR",
        "Country: Cote d'Ivoire"                                => "CI",
        "Country: Croatia"                                      => "HR",
        "Country: Cuba"                                         => "CU",
        "Country: Curacao"                                      => "CW",
        "Country: Cyprus"                                       => "CY",
        "Country: Czech Republic"                               => "CZ",
        "Country: Denmark"                                      => "DK",
        "Country: Djibouti"                                     => "DJ",
        "Country: Dominica"                                     => "DM",
        "Country: Dominican Republic"                           => "DO",
        "Country: Ecuador"                                      => "EC",
        "Country: Egypt"                                        => "EG",
        "Country: El Salvador"                                  => "SV",
        "Country: Equatorial Guinea"                            => "GQ",
        "Country: Eritrea"                                      => "ER",
        "Country: Estonia"                                      => "EE",
        "Country: Ethiopia"                                     => "ET",
        "Country: Falkland Islands (Malvinas)"                  => "FK",
        "Country: Faroe Islands"                                => "FO",
        "Country: Fiji"                                         => "FJ",
        "Country: Finland"                                      => "FI",
        "Country: France"                                       => "FR",
        "Country: French Guiana"                                => "GF",
        "Country: French Polynesia"                             => "PF",
        "Country: French Southern Territories"                  => "TF",
        "Country: Gabon"                                        => "GA",
        "Country: Gambia"                                       => "GM",
        "Country: Georgia"                                      => "GE",
        "Country: Germany"                                      => "DE",
        "Country: Ghana"                                        => "GH",
        "Country: Gibraltar"                                    => "GI",
        "Country: Greece"                                       => "GR",
        "Country: Greenland"                                    => "GL",
        "Country: Grenada"                                      => "GD",
        "Country: Guadeloupe"                                   => "GP",
        "Country: Guam"                                         => "GU",
        "Country: Guatemala"                                    => "GT",
        "Country: Guernsey"                                     => "GG",
        "Country: Guinea"                                       => "GN",
        "Country: Guinea-Bissau"                                => "GW",
        "Country: Guyana"                                       => "GY",
        "Country: Haiti"                                        => "HT",
        "Country: Heard Island and McDonald Islands"            => "HM",
        "Country: Holy See (Vatican City State)"                => "VA",
        "Country: Honduras"                                     => "HN",
        "Country: Hong Kong"                                    => "HK",
        "Country: Hungary"                                      => "HU",
        "Country: Iceland"                                      => "IS",
        "Country: India"                                        => "IN",
        "Country: Indonesia"                                    => "ID",
        "Country: Iran, Islamic Republic of"                    => "IR",
        "Country: Iraq"                                         => "IQ",
        "Country: Ireland"                                      => "IE",
        "Country: Isle of Man"                                  => "IM",
        "Country: Israel"                                       => "IL",
        "Country: Italy"                                        => "IT",
        "Country: Jamaica"                                      => "JM",
        "Country: Japan"                                        => "JP",
        "Country: Jersey"                                       => "JE",
        "Country: Jordan"                                       => "JO",
        "Country: Kazakhstan"                                   => "KZ",
        "Country: Kenya"                                        => "KE",
        "Country: Kiribati"                                     => "KI",
        "Country: Korea, Democratic People's Republic of"       => "KP",
        "Country: Korea, Republic of"                           => "KR",
        "Country: Kuwait"                                       => "KW",
        "Country: Kyrgyzstan"                                   => "KG",
        "Country: Lao People's Democratic Republic"             => "LA",
        "Country: Latvia"                                       => "LV",
        "Country: Lebanon"                                      => "LB",
        "Country: Lesotho"                                      => "LS",
        "Country: Liberia"                                      => "LR",
        "Country: Libya"                                        => "LY",
        "Country: Liechtenstein"                                => "LI",
        "Country: Lithuania"                                    => "LT",
        "Country: Luxembourg"                                   => "LU",
        "Country: Macao"                                        => "MO",
        "Country: Macedonia, the former Yugoslav Republic of"   => "MK",
        "Country: Madagascar"                                   => "MG",
        "Country: Malawi"                                       => "MW",
        "Country: Malaysia"                                     => "MY",
        "Country: Maldives"                                     => "MV",
        "Country: Mali"                                         => "ML",
        "Country: Malta"                                        => "MT",
        "Country: Marshall Islands"                             => "MH",
        "Country: Martinique"                                   => "MQ",
        "Country: Mauritania"                                   => "MR",
        "Country: Mauritius"                                    => "MU",
        "Country: Mayotte"                                      => "YT",
        "Country: Mexico"                                       => "MX",
        "Country: Micronesia, Federated States of"              => "FM",
        "Country: Moldova, Republic of"                         => "MD",
        "Country: Monaco"                                       => "MC",
        "Country: Mongolia"                                     => "MN",
        "Country: Montenegro"                                   => "ME",
        "Country: Montserrat"                                   => "MS",
        "Country: Morocco"                                      => "MA",
        "Country: Mozambique"                                   => "MZ",
        "Country: Myanmar"                                      => "MM",
        "Country: Namibia"                                      => "NA",
        "Country: Nauru"                                        => "NR",
        "Country: Nepal"                                        => "NP",
        "Country: Netherlands"                                  => "NL",
        "Country: New Caledonia"                                => "NC",
        "Country: New Zealand"                                  => "NZ",
        "Country: Nicaragua"                                    => "NI",
        "Country: Niger"                                        => "NE",
        "Country: Nigeria"                                      => "NG",
        "Country: Niue"                                         => "NU",
        "Country: Norfolk Island"                               => "NF",
        "Country: Northern Mariana Islands"                     => "MP",
        "Country: Norway"                                       => "NO",
        "Country: Oman"                                         => "OM",
        "Country: Pakistan"                                     => "PK",
        "Country: Palau"                                        => "PW",
        "Country: Palestine, State of"                          => "PS",
        "Country: Panama"                                       => "PA",
        "Country: Papua New Guinea"                             => "PG",
        "Country: Paraguay"                                     => "PY",
        "Country: Peru"                                         => "PE",
        "Country: Philippines"                                  => "PH",
        "Country: Pitcairn"                                     => "PN",
        "Country: Poland"                                       => "PL",
        "Country: Portugal"                                     => "PT",
        "Country: Puerto Rico"                                  => "PR",
        "Country: Qatar"                                        => "QA",
        "Country: Reunion"                                      => "RE",
        "Country: Romania"                                      => "RO",
        "Country: Russian Federation"                           => "RU",
        "Country: Rwanda"                                       => "RW",
        "Country: Saint Barthelemy"                             => "BL",
        "Country: Saint Helena, Ascension and Tristan da Cunha" => "SH",
        "Country: Saint Kitts and Nevis"                        => "KN",
        "Country: Saint Lucia"                                  => "LC",
        "Country: Saint Martin (French Part)"                   => "MF",
        "Country: Saint Pierre and Miquelon"                    => "PM",
        "Country: Saint Vincent and the Grenadines"             => "VC",
        "Country: Samoa"                                        => "WS",
        "Country: San Marino"                                   => "SM",
        "Country: Sao Tome and Principe"                        => "ST",
        "Country: Saudi Arabia"                                 => "SA",
        "Country: Senegal"                                      => "SN",
        "Country: Serbia"                                       => "RS",
        "Country: Seychelles"                                   => "SC",
        "Country: Sierra Leone"                                 => "SL",
        "Country: Singapore"                                    => "SG",
        "Country: Sint Maarten (Dutch part)"                    => "SX",
        "Country: Slovakia"                                     => "SK",
        "Country: Slovenia"                                     => "SI",
        "Country: Solomon Islands"                              => "SB",
        "Country: Somalia"                                      => "SO",
        "Country: South Africa"                                 => "ZA",
        "Country: South Georgia and the South Sandwich Islands" => "GS",
        "Country: South Sudan"                                  => "SS",
        "Country: Spain"                                        => "ES",
        "Country: Sri Lanka"                                    => "LK",
        "Country: Sudan"                                        => "SD",
        "Country: Suriname"                                     => "SR",
        "Country: Svalbard and Jan Mayen"                       => "SJ",
        "Country: Swaziland"                                    => "SZ",
        "Country: Sweden"                                       => "SE",
        "Country: Switzerland"                                  => "CH",
        "Country: Syrian Arab Republic"                         => "SY",
        "Country: Taiwan, Province of China"                    => "TW",
        "Country: Tajikistan"                                   => "TJ",
        "Country: Tanzania, United Republic of"                 => "TZ",
        "Country: Thailand"                                     => "TH",
        "Country: Timor-Leste"                                  => "TL",
        "Country: Togo"                                         => "TG",
        "Country: Tokelau"                                      => "TK",
        "Country: Tonga"                                        => "TO",
        "Country: Trinidad and Tobago"                          => "TT",
        "Country: Tunisia"                                      => "TN",
        "Country: Turkey"                                       => "TR",
        "Country: Turkmenistan"                                 => "TM",
        "Country: Turks and Caicos Islands"                     => "TC",
        "Country: Tuvalu"                                       => "TV",
        "Country: Uganda"                                       => "UG",
        "Country: Ukraine"                                      => "UA",
        "Country: United Arab Emirates"                         => "AE",
        "Country: United Kingdom"                               => "GB",
        "Country: United States"                                => "US",
        "Country: United States Minor Outlying Islands"         => "UM",
        "Country: Uruguay"                                      => "UY",
        "Country: Uzbekistan"                                   => "UZ",
        "Country: Vanuatu"                                      => "VU",
        "Country: Venezuela, Bolivarian Republic of"            => "VE",
        "Country: Viet Nam"                                     => "VN",
        "Country: Virgin Islands, British"                      => "VG",
        "Country: Virgin Islands, U.S."                         => "VI",
        "Country: Wallis and Futuna"                            => "WF",
        "Country: Western Sahara"                               => "EH",
        "Country: Yemen"                                        => "YE",
        "Country: Zambia"                                       => "ZM",
        "Country: Zimbabwe"                                     => "ZW",
    );
    
    // Button Styles
    $this->TS_VCSC_Button_Square = array (
        "Gray / 3D - Square"                                    => "ts-button-3d",
        "Gray / Default - Square"                               => "ts-button-default",
        "Gray / Default - Square (Glow)"                        => "ts-button-default glow",
        "Gray / Flat - Square"                                  => "ts-button-flat",
        "Gray / Flat - Square (Glow)"                           => "ts-button-flat glow",
        "Blue / 3D - Square"                                    => "ts-button-3d-primary",
        "Blue / Default - Square"                               => "ts-button-default ts-button-primary",
        "Blue / Default - Square (Glow)"                        => "ts-button-default glow ts-button-primary",
        "Blue / Flat - Square"                                  => "ts-button-flat-primary",
        "Blue / Flat - Square (Glow)"                           => "ts-button-flat-primary glow",
        "Green / 3D - Square"                                   => "ts-button-3d-action",
        "Green / Default - Square"                              => "ts-button-default ts-button-action",
        "Green / Default - Square (Glow)"                       => "ts-button-default glow ts-button-action",
        "Green / Flat - Square"                                 => "ts-button-flat-action",
        "Green / Flat - Square (Glow)"                          => "ts-button-flat-action glow",
        "Orange / 3D - Square"                                  => "ts-button-3d-highlight",
        "Orange / Default - Square"                             => "ts-button-default ts-button-highlight",
        "Orange / Default - Square (Glow)"                      => "ts-button-default glow ts-button-highlight",
        "Orange / Flat - Square"                                => "ts-button-flat-highlight",
        "Orange / Flat - Square (Glow)"                         => "ts-button-flat-highlight glow",
        "Red / 3D - Square"                                     => "ts-button-3d-caution",
        "Red / Default - Square"                                => "ts-button-default ts-button-caution",
        "Red / Default - Square (Glow)"                         => "ts-button-default glow ts-button-caution",
        "Red / Flat - Square"                                   => "ts-button-flat-caution",
        "Red / Flat - Square (Glow)"                            => "ts-button-flat-caution glow",
        "Purple / 3D - Square"                                  => "ts-button-3d-royal",
        "Purple / Default - Square"                             => "ts-button-default ts-button-royal",
        "Purple / Default - Square (Glow)"                      => "ts-button-default glow ts-button-royal",
        "Purple / Flat - Square"                                => "ts-button-flat-royal",
        "Purple / Flat - Square (Glow)"                         => "ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Rounded = array (
        "Gray / 3D - Rounded"                                   => "ts-button-3d ts-button-rounded",
        "Gray / Default - Rounded"                              => "ts-button-rounded ts-button-default",
        "Gray / Default - Rounded (Glow)"                       => "ts-button-rounded ts-button-default glow",
        "Gray / Flat - Rounded"                                 => "ts-button-rounded ts-button-flat",
        "Gray / Flat - Rounded (Glow)"                          => "ts-button-rounded ts-button-flat glow",
        "Blue / 3D - Rounded"                                   => "ts-button-3d-primary ts-button-rounded",
        "Blue / Default - Rounded"                              => "ts-button-rounded-primary ts-button-default",
        "Blue / Default - Rounded (Glow)"                       => "ts-button-rounded-primary ts-button-default",
        "Blue / Flat - Rounded"                                 => "ts-button-rounded ts-button-flat-primary",
        "Blue / Flat - Rounded (Glow)"                          => "ts-button-rounded ts-button-flat-primary glow",
        "Green / 3D - Rounded"                                  => "ts-button-3d-action ts-button-rounded",
        "Green / Default - Rounded"                             => "ts-button-rounded ts-button-default ts-button-action",
        "Green / Default - Rounded (Glow)"                      => "ts-button-rounded ts-button-default glow ts-button-action",
        "Green / Flat - Rounded"                                => "ts-button-rounded ts-button-flat-action",
        "Green / Flat - Rounded (Glow)"                         => "ts-button-rounded ts-button-flat-action glow",
        "Orange / 3D - Rounded"                                 => "ts-button-3d-highlight ts-button-rounded",
        "Orange / Default - Rounded"                            => "ts-button-rounded ts-button-default ts-button-highlight",
        "Orange / Default - Rounded (Glow)"                     => "ts-button-rounded ts-button-default glow ts-button-highlight",
        "Orange / Flat - Rounded"                               => "ts-button-rounded ts-button-flat-highlight",
        "Orange / Flat - Rounded (Glow)"                        => "ts-button-rounded ts-button-flat-highlight glow",
        "Red / 3D - Rounded"                                    => "ts-button-3d-caution ts-button-rounded",
        "Red / Default - Rounded"                               => "ts-button-rounded ts-button-default ts-button-caution",
        "Red / Default - Rounded (Glow)"                        => "ts-button-rounded ts-button-default glow ts-button-caution",
        "Red / Flat - Rounded"                                  => "ts-button-rounded ts-button-flat-caution",
        "Red / Flat - Rounded (Glow)"                           => "ts-button-rounded ts-button-flat-caution glow",
        "Purple / 3D - Rounded"                                 => "ts-button-3d-royal ts-button-rounded",
        "Purple / Default - Rounded"                            => "ts-button-rounded ts-button-default ts-button-royal",
        "Purple / Default - Rounded (Glow)"                     => "ts-button-rounded ts-button-default glow ts-button-royal",
        "Purple / Flat - Rounded"                               => "ts-button-rounded ts-button-flat-royal",
        "Purple / Flat - Rounded (Glow)"                        => "ts-button-rounded ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Pill = array (
        "Gray / 3D - Pill"                                      => "ts-button-3d ts-button-pill",
        "Gray / Default - Pill"                                 => "ts-button-pill ts-button-default",
        "Gray / Default - Pill (Glow)"                          => "ts-button-pill ts-button-default glow",
        "Gray / Flat - Pill"                                    => "ts-button-pill ts-button-flat",
        "Gray / Flat - Pill (Glow)"                             => "ts-button-pill ts-button-flat glow",
        "Blue / 3D - Pill"                                      => "ts-button-3d-primary ts-button-pill",
        "Blue / Default - Pill"                                 => "ts-button-pill ts-button-primary",
        "Blue / Default - Pill (Glow)"                          => "ts-button-pill ts-button-primary glow",
        "Blue / Flat - Pill"                                    => "ts-button-pill ts-button-flat-primary",
        "Blue / Flat - Pill (Glow)"                             => "ts-button-pill ts-button-flat-primary glow",
        "Green / 3D - Pill"                                     => "ts-button-3d-action ts-button-pill",
        "Green / Default - Pill"                                => "ts-button-pill ts-button-default ts-button-action",
        "Green / Default - Pill (Glow)"                         => "ts-button-pill ts-button-default glow ts-button-action",
        "Green / Flat - Pill"                                   => "ts-button-pill ts-button-flat-action",
        "Green / Flat - Pill (Glow)"                            => "ts-button-pill ts-button-flat-action glow",
        "Orange / 3D - Pill"                                    => "ts-button-3d-highlight ts-button-pill",
        "Orange / Default - Pill"                               => "ts-button-pill ts-button-default ts-button-highlight",
        "Orange / Default - Pill (Glow)"                        => "ts-button-pill ts-button-default glow ts-button-highlight",
        "Orange / Flat - Pill"                                  => "ts-button-pill ts-button-flat-highlight",
        "Orange / Flat - Pill (Glow)"                           => "ts-button-pill ts-button-flat-highlight glow",
        "Red / 3D - Pill"                                       => "ts-button-3d-caution ts-button-pill",
        "Red / Default - Pill"                                  => "ts-button-pill ts-button-default ts-button-caution",
        "Red / Default - Pill (Glow)"                           => "ts-button-pill ts-button-default glow ts-button-caution",
        "Red / Flat - Pill"                                     => "ts-button-pill ts-button-flat-caution",
        "Red / Flat - Pill (Glow)"                              => "ts-button-pill ts-button-flat-caution glow",
        "Purple / 3D - Pill"                                    => "ts-button-3d-royal ts-button-pill",
        "Purple / Default - Pill"                               => "ts-button-pill ts-button-default ts-button-royal",
        "Purple / Default - Pill (Glow)"                        => "ts-button-pill ts-button-default glow ts-button-royal",
        "Purple / Flat - Pill"                                  => "ts-button-pill ts-button-flat-royal",
        "Purple / Flat - Pill (Glow)"                           => "ts-button-pill ts-button-flat-royal glow",
    );
    $this->TS_VCSC_Button_Circle = array (
        "Gray / 3D - Circle"                                    => "ts-button-3d ts-button-circle",
        "Gray / Default - Circle"                               => "ts-button-circle ts-button-default",
        "Gray / Default - Circle (Glow)"                        => "ts-button-circle ts-button-default glow",
        "Gray / Flat - Circle"                                  => "ts-button-circle ts-button-flat",
        "Gray / Flat - Circle (Glow)"                           => "ts-button-circle ts-button-flat glow",
        "Blue / 3D - Circle"                                    => "ts-button-3d-primary ts-button-circle",
        "Blue / Default - Circle"                               => "ts-button-circle ts-button-primary",
        "Blue / Default - Circle (Glow)"                        => "ts-button-circle ts-button-primary glow",
        "Blue / Flat - Circle"                                  => "ts-button-circle ts-button-flat-primary",
        "Blue / Flat - Circle (Glow)"                           => "ts-button-circle ts-button-flat-primary glow",
        "Green / 3D - Circle"                                   => "ts-button-3d-action ts-button-circle",
        "Green / Default - Circle"                              => "ts-button-circle ts-button-default ts-button-action",
        "Green / Default - Circle (Glow)"                       => "ts-button-circle ts-button-default glow ts-button-action",
        "Green / Flat - Circle"                                 => "ts-button-circle ts-button-flat-action",
        "Green / Flat - Circle (Glow)"                          => "ts-button-circle ts-button-flat-action glow",
        "Orange / 3D - Circle"                                  => "ts-button-3d-highlight ts-button-circle",
        "Orange / Default - Circle"                             => "ts-button-circle ts-button-default ts-button-highlight",
        "Orange / Default - Circle (Glow)"                      => "ts-button-circle ts-button-default glow ts-button-highlight",
        "Orange / Flat - Circle"                                => "ts-button-circle ts-button-flat-highlight",
        "Orange / Flat - Circle (Glow)"                         => "ts-button-circle ts-button-flat-highlight glow",
        "Red / 3D - Circle"                                     => "ts-button-3d-caution ts-button-circle",
        "Red / Default - Circle"                                => "ts-button-circle ts-button-default ts-button-caution",
        "Red / Default - Circle (Glow)"                         => "ts-button-circle ts-button-default glow ts-button-caution",
        "Red / Flat - Circle"                                   => "ts-button-circle ts-button-flat-caution",
        "Red / Flat - Circle (Glow)"                            => "ts-button-circle ts-button-flat-caution glow",
        "Purple / 3D - Circle"                                  => "ts-button-3d-royal ts-button-circle",
        "Purple / Default - Circle"                             => "ts-button-circle ts-button-default ts-button-royal",
        "Purple / Default - Circle (Glow)"                      => "ts-button-circle ts-button-default glow ts-button-royal",
        "Purple / Flat - Circle"                                => "ts-button-circle ts-button-flat-royal",
        "Purple / Flat - Circle (Glow)"                         => "ts-button-circle ts-button-flat-royal glow",
    );    
    $this->TS_VCSC_Flat_Button_Default_Colors = array(
        "Default Flat"			                                => "ts-dual-buttons-color-default",
        "Sun Flower Flat"		                                => "ts-dual-buttons-color-sun-flower",
        "Orange Flat"			                                => "ts-dual-buttons-color-orange-flat",
        "Carot Flat"     		                                => "ts-dual-buttons-color-carrot-flat",
        "Pumpkin Flat"			                                => "ts-dual-buttons-color-pumpkin-flat",
        "Alizarin Flat"			                                => "ts-dual-buttons-color-alizarin-flat",
        "Pomegranate Flat"		                                => "ts-dual-buttons-color-pomegranate-flat",
        "Turquoise Flat"			                            => "ts-dual-buttons-color-turquoise-flat",
        "Green Sea Flat"			                            => "ts-dual-buttons-color-green-sea-flat",
        "Emerald Flat"			                                => "ts-dual-buttons-color-emerald-flat",
        "Nephritis Flat"			                            => "ts-dual-buttons-color-nephritis-flat",
        "Peter River Flat"		                                => "ts-dual-buttons-color-peter-river-flat",
        "Belize Hole Flat"		                                => "ts-dual-buttons-color-belize-hole-flat",
        "Amethyst Flat"			                                => "ts-dual-buttons-color-amethyst-flat",
        "Wisteria Flat"			                                => "ts-dual-buttons-color-wisteria-flat",
        "Wet Asphalt Flat"		                                => "ts-dual-buttons-color-wet-asphalt-flat",
        "Midnight Blue Flat"		                            => "ts-dual-buttons-color-midnight-blue-flat",
        "Clouds Flat"			                                => "ts-dual-buttons-color-clouds-flat",
        "Silver Flat"			                                => "ts-dual-buttons-color-silver-flat",
        "Concrete Flat"			                                => "ts-dual-buttons-color-concrete-flat",
        "Asbestos Flat"			                                => "ts-dual-buttons-color-asbestos-flat",
        "Graphite Flat"			                                => "ts-dual-buttons-color-graphite-flat",
    );
    $this->TS_VCSC_Flat_Button_Hover_Colors = array(
        "Default Flat"			                                => "ts-dual-buttons-preview-default ts-dual-buttons-hover-default",
        "Sun Flower Flat"		                                => "ts-dual-buttons-preview-sun-flower ts-dual-buttons-hover-sun-flower",
        "Orange Flat"			                                => "ts-dual-buttons-preview-orange-flat ts-dual-buttons-hover-orange-flat",
        "Carot Flat"     		                                => "ts-dual-buttons-preview-carrot-flat ts-dual-buttons-hover-carrot-flat",
        "Pumpkin Flat"			                                => "ts-dual-buttons-preview-pumpkin-flat ts-dual-buttons-hover-pumpkin-flat",
        "Alizarin Flat"			                                => "ts-dual-buttons-preview-alizarin-flat ts-dual-buttons-hover-alizarin-flat",
        "Pomegranate Flat"		                                => "ts-dual-buttons-preview-pomegranate-flat ts-dual-buttons-hover-pomegranate-flat",
        "Turquoise Flat"			                            => "ts-dual-buttons-preview-turquoise-flat ts-dual-buttons-hover-turquoise-flat",
        "Green Sea Flat"			                            => "ts-dual-buttons-preview-green-sea-flat ts-dual-buttons-hover-green-sea-flat",
        "Emerald Flat"			                                => "ts-dual-buttons-preview-emerald-flat ts-dual-buttons-hover-emerald-flat",
        "Nephritis Flat"			                            => "ts-dual-buttons-preview-nephritis-flat ts-dual-buttons-hover-nephritis-flat",
        "Peter River Flat"		                                => "ts-dual-buttons-preview-peter-river-flat ts-dual-buttons-hover-peter-river-flat",
        "Belize Hole Flat"		                                => "ts-dual-buttons-preview-belize-hole-flat ts-dual-buttons-hover-belize-hole-flat",
        "Amethyst Flat"			                                => "ts-dual-buttons-preview-amethyst-flat ts-dual-buttons-hover-amethyst-flat",
        "Wisteria Flat"			                                => "ts-dual-buttons-preview-wisteria-flat ts-dual-buttons-hover-wisteria-flat",
        "Wet Asphalt Flat"		                                => "ts-dual-buttons-preview-wet-asphalt-flat ts-dual-buttons-hover-wet-asphalt-flat",
        "Midnight Blue Flat"		                            => "ts-dual-buttons-preview-midnight-blue-flat ts-dual-buttons-hover-midnight-blue-flat",
        "Clouds Flat"			                                => "ts-dual-buttons-preview-clouds-flat ts-dual-buttons-hover-clouds-flat",
        "Silver Flat"			                                => "ts-dual-buttons-preview-silver-flat ts-dual-buttons-hover-silver-flat",
        "Concrete Flat"			                                => "ts-dual-buttons-preview-concrete-flat ts-dual-buttons-hover-concrete-flat",
        "Asbestos Flat"			                                => "ts-dual-buttons-preview-asbestos-flat ts-dual-buttons-hover-asbestos-flat",
        "Graphite Flat"			                                => "ts-dual-buttons-preview-graphite-flat ts-dual-buttons-hover-graphite-flat",
    );
    
    // Lightbox Animation Styles
    $this->TS_VCSC_Lightbox_Animations = array(
        __( 'Random', "ts_visual_composer_extend" )       	    => "random",
        __( 'Simple Fade', "ts_visual_composer_extend" )	    => "simpleFade",
        __( 'Fade & Swipe', "ts_visual_composer_extend" )	    => "fade",
        __( 'Swipe', "ts_visual_composer_extend" )        	    => "swipe",
        __( 'Scale', "ts_visual_composer_extend" )        	    => "scale",
        __( 'Slide Up', "ts_visual_composer_extend" )     	    => "slideUp",
        __( 'Slide Down', "ts_visual_composer_extend" )   	    => "slideDown",
        __( 'Flip', "ts_visual_composer_extend" )         	    => "flip",
        __( 'Skew', "ts_visual_composer_extend" )         	    => "skew",
        __( 'Bounce Up', "ts_visual_composer_extend" )    	    => "bounceUp",
        __( 'Bounce Down', "ts_visual_composer_extend" )  	    => "bounceDown",
        __( 'Break In', "ts_visual_composer_extend" )     	    => "breakIn",
        __( 'Rotate In', "ts_visual_composer_extend" )    	    => "rotateIn",
        __( 'Rotate Out', "ts_visual_composer_extend" )   	    => "rotateOut",
        __( 'Hang Left', "ts_visual_composer_extend" )    	    => "hangLeft",
        __( 'Hang Right', "ts_visual_composer_extend" )   	    => "hangRight",
        __( 'Cycle Up', "ts_visual_composer_extend" )     	    => "cicleUp",
        __( 'Cycle Down', "ts_visual_composer_extend" )   	    => "cicleDown",
        __( 'Zoom In', "ts_visual_composer_extend" )      	    => "zoomIn",
        __( 'Throw In', "ts_visual_composer_extend" )     	    => "throwIn",
        __( 'Fall', "ts_visual_composer_extend" )         	    => "fall",
        __( 'Jump', "ts_visual_composer_extend" )         	    => "jump",
    );

    $this->TS_VCSC_External_URL         = "http://www.tekanewascripts.info/Updates/ts-envato-api-check-vc-extensions.php?license=";
    
    $this->TS_VCSC_Avoid_Duplications = array (
        'OGE0NTkyN2YtNjg4NC00OTZiLTkxMjMtMGMzNmI0NWI3YmMw',
        'Y2Q1MmU4ZmEtZTI3Ny00ZmIwLThiY2YtM2FlY2ZjZGUxOGYy',
        'ZWQzMjAyOGItNzEzYy00YTJmLWI4YTItOWJlYzljMGY1ZWJl',
    );
    
    // Define Array for Border Types
    $this->TS_VCSC_Border_Type_Values = array(
        'solid', 'dotted', 'dashed', 'double', 'groove', 'ridge', 'inset', 'outset'
    );
    
    // Define Array for Icon Border Radius
    $this->TS_VCSC_Icon_Border_Radius_Values = array(
        'ts-radius-small', 'ts-radius-medium', 'ts-radius-large', 'ts-radius-full'
    );
    
    // Define Array for Box Border Radius
    $this->TS_VCSC_Box_Border_Radius_Values = array(
        'ts-radius-small', 'ts-radius-medium', 'ts-radius-large'
    );
    
    // Define Array for Visual Composer CSS Animations
    $this->TS_VCSC_CSS_Animations_Values = array(
        'appear', 'fade-in', 'scale-up', 'right-to-left', 'left-to-right', 'bottom-to-top', 'top-to-bottom'
    );
    
    // Define Arrays for jQuery Easings
    $this->TS_VCSC_CSS_Easings_Array = array(
		"Linear"					    => "linear",
		"Ease In Sine"			        => "easeInSine",
		"Ease Out Sine"			        => "easeOutSine",
        "Ease In Out Sine"              => "easeInOutSine",
		"Ease In Quad"			        => "easeInQuad",
        "Ease Out Quad"			        => "easeOutQuad",
        "Ease In Out Quad"              => "easeInOutQuad",
        "Ease In Cubic"			        => "easeInCubic",
        "Ease Out Cubic"                => "easeOutCubic",
        "Ease In Out Cubic"             => "easeInOutCubic",
        "Ease In Quart"			        => "easeInQuart",
        "Ease Out Quart"                => "easeOutQuart",
        "Ease In Out Quart"             => "easeInOutQuart",        
        "Ease In Quint"			        => "easeInQuint",
        "Ease Out Quint"                => "easeOutQuint",
        "Ease In Out Quint"             => "easeInOutQuint",        
        "Ease In Expo"			        => "easeInExpo",
        "Ease Out Expo"                 => "easeOutExpo",
        "Ease In Out Expo"              => "easeInOutExpo",        
        "Ease In Circ"			        => "easeInCirc",
        "Ease Out Circ"                 => "easeOutCirc",
        "Ease In Out Circ"              => "easeInOutCirc",
        "Ease In Back"			        => "easeInBack",
        "Ease Out Back"                 => "easeOutBack",
        "Ease In Out Back"              => "easeInOutBack",        
        "Ease In Elastic"               => "easeInElastic",
        "Ease Out Elastic"              => "easeOutElastic",
        "Ease In Out Elastic"           => "easeInOutElastic",
        "Ease In Bounce"                => "easeInBounce",
        "Ease Out Bounce"               => "easeOutBounce",
        "Ease In Out Bounce"            => "easeInOutBounce",
    );
    
    // Define Arrays for CSS Animations
    $this->TS_VCSC_CSS_Animations_Array = array(
        "Bounce"                        => array("class" => "bounce",               "group" => "Attention Seekers"),
        "Flash"                         => array("class" => "flash",                "group" => "Attention Seekers"),
        "Hinge"                         => array("class" => "hinge",                "group" => "Attention Seekers"),
        "Roll In"                       => array("class" => "rollIn",               "group" => "Attention Seekers"),
        "Roll Out"                      => array("class" => "rollOut",              "group" => "Attention Seekers"),
        "Rotate Full"                   => array("class" => "rotateFull",           "group" => "Attention Seekers"),
        "Rubberband"                    => array("class" => "rubberBand",           "group" => "Attention Seekers"),
        "Shake"                         => array("class" => "shake",                "group" => "Attention Seekers"),
        "Spin"                          => array("class" => "spin",                 "group" => "Attention Seekers"),
        "Swing"                         => array("class" => "swing",                "group" => "Attention Seekers"),
        "Tada"                          => array("class" => "tada",                 "group" => "Attention Seekers"),
        "Jello"                         => array("class" => "jello",                "group" => "Attention Seekers"),
        
        "Bounce In"                     => array("class" => "bounceIn",             "group" => "Bounce Entries"),
        "Bounce In Down"                => array("class" => "bounceInDown",         "group" => "Bounce Entries"),
        "Bounce In Left"                => array("class" => "bounceInLeft",         "group" => "Bounce Entries"),
        "Bounce In Right"               => array("class" => "bounceInRight",        "group" => "Bounce Entries"),
        "Bounce In Up"                  => array("class" => "bounceInUp",           "group" => "Bounce Entries"),
        
        "Bounce Out"                    => array("class" => "bounceOut",            "group" => "Bounce Exits"),
        "Bounce Out Down"               => array("class" => "bounceOutDown",        "group" => "Bounce Exits"),
        "Bounce Out Left"               => array("class" => "bounceOutLeft",        "group" => "Bounce Exits"),
        "Bounce Out Right"              => array("class" => "bounceOutRight",       "group" => "Bounce Exits"),
        "Bounce Out Up"                 => array("class" => "bounceOutUp",          "group" => "Bounce Exits"),
        
        "Fade In"                       => array("class" => "fadeIn",               "group" => "Fade Entries"),
        "Fade In Down"                  => array("class" => "fadeInDown",           "group" => "Fade Entries"),
        "Fade In Down Big"              => array("class" => "fadeInDownBig",        "group" => "Fade Entries"),
        "Fade In Left"                  => array("class" => "fadeInLeft",           "group" => "Fade Entries"),
        "Fade In Left Big"              => array("class" => "fadeInLeftBig",        "group" => "Fade Entries"),
        "Fade In Right"                 => array("class" => "fadeInRight",          "group" => "Fade Entries"),
        "Fade In Right Big"             => array("class" => "fadeInRightBig",       "group" => "Fade Entries"),
        "Fade In Up"                    => array("class" => "fadeInUp",             "group" => "Fade Entries"),
        "Fade In Up Big"                => array("class" => "fadeInUpBig",          "group" => "Fade Entries"),
        
        "Fade Out"                      => array("class" => "fadeOut",              "group" => "Fade Exits"),
        "Fade Out Down"                 => array("class" => "fadeOutDown",          "group" => "Fade Exits"),
        "Fade Out Down Big"             => array("class" => "fadeOutDownBig",       "group" => "Fade Exits"),
        "Fade Out Left"                 => array("class" => "fadeOutLeft",          "group" => "Fade Exits"),
        "Fade Out Left Big"             => array("class" => "fadeOutLeftBig",       "group" => "Fade Exits"),
        "Fade Out Right"                => array("class" => "fadeOutRight",         "group" => "Fade Exits"),
        "Fade Out Right Big"            => array("class" => "fadeOutRightBig",      "group" => "Fade Exits"),
        "Fade Out Up"                   => array("class" => "fadeOutUp",            "group" => "Fade Exits"),
        "Fade Out Up Big"               => array("class" => "fadeOutUpBig",         "group" => "Fade Exits"),
        
        "Flip In X"                     => array("class" => "flipInX",              "group" => "Flippers"),
        "Flip In Y"                     => array("class" => "flipInY",              "group" => "Flippers"),
        "Flip Out X"                    => array("class" => "flipOutX",             "group" => "Flippers"),
        "Flip Out Y"                    => array("class" => "flipOutY",             "group" => "Flippers"),
        
        "Light Speed In"                => array("class" => "lightSpeedIn",         "group" => "Lightspeed"),
        "Light Speed Out"               => array("class" => "lightSpeedOut",        "group" => "Lightspeed"),
        
        "Pulse Normal"                  => array("class" => "pulse",                "group" => "Pulsars"),
        "Pulse Grow"                    => array("class" => "pulseGrow",            "group" => "Pulsars"),
        "Pulse Shrink"                  => array("class" => "pulseShrink",          "group" => "Pulsars"),

        "Rotate In"                     => array("class" => "rotateIn",             "group" => "Rotate Entries"),
        "Rotate In Down Left"           => array("class" => "rotateInDownLeft",     "group" => "Rotate Entries"),
        "Rotate In Down Right"          => array("class" => "rotateInDownRight",    "group" => "Rotate Entries"),
        "Rotate In Up Left"             => array("class" => "rotateInUpLeft",       "group" => "Rotate Entries"),
        "Rotate In Up Right"            => array("class" => "rotateInUpRight",      "group" => "Rotate Entries"),
        
        "Rotate Out"                    => array("class" => "rotateOut",            "group" => "Rotate Exits"),
        "Rotate Out Down Left"          => array("class" => "rotateOutDownLeft",    "group" => "Rotate Exits"),
        "Rotate Out Down Right"         => array("class" => "rotateOutDownRight",   "group" => "Rotate Exits"),
        "Rotate Out Up Left"            => array("class" => "rotateOutUpLeft",      "group" => "Rotate Exits"),
        "Rotate Out Up Right"           => array("class" => "rotateOutUpRight",     "group" => "Rotate Exits"),

        "Slide In Up"                   => array("class" => "slideInUp",            "group" => "Slide Entries"),
        "Slide In Down"                 => array("class" => "slideInDown",          "group" => "Slide Entries"),
        "Slide In Left"                 => array("class" => "slideInLeft",          "group" => "Slide Entries"),
        "Slide In Right"                => array("class" => "slideInRight",         "group" => "Slide Entries"),
        
        "Slide Out Up"                  => array("class" => "slideOutUp",           "group" => "Slide Exits"),
        "Slide Out Down"                => array("class" => "slideOutDown",         "group" => "Slide Exits"),
        "Slide Out Left"                => array("class" => "slideOutLeft",         "group" => "Slide Exits"),
        "Slide Out Right"               => array("class" => "slideOutRight",        "group" => "Slide Exits"),

        "Wobble Standard"               => array("class" => "wobble",               "group" => "Wobblers"),
        "Wobble Vertical"               => array("class" => "wobbleVertical",       "group" => "Wobblers"),
        "Wobble Horizontal"             => array("class" => "wobbleHorizontal",     "group" => "Wobblers"),
        "Wobble Top"                    => array("class" => "wobbleTop",            "group" => "Wobblers"),
        "Wobble Bottom"                 => array("class" => "wobbleBottom",         "group" => "Wobblers"),
        
        "Appear (VC)"                   => array("class" => "appear",               "group" => "Standard Visual Composer"),
        "Right to Left (VC)"            => array("class" => "right-to-left",        "group" => "Standard Visual Composer"),
        "Left to Right (VC)"            => array("class" => "left-to-right",        "group" => "Standard Visual Composer"),
        "Bottom to Top (VC)"            => array("class" => "bottom-to-top",        "group" => "Standard Visual Composer"),
        "Top to Bottom (VC)"            => array("class" => "top-to-bottom",        "group" => "Standard Visual Composer"),
    );
    
    // Define Array for Background Styles
    $this->TS_VCSC_Background_Type_Values = array(
        'color', 'pattern'
    );
    
    // Define Array for SVG Shapes
    $this->TS_VCSC_SVG_RowShapes_List = array(
        //'No Effect (Square)'          => '0',
        'Triangle Inwards'              => '1',
        'Triangle Outwards'             => '2',
        'Slight Center Curve Inwards'   => '3',
        'Slight Left Curve Inwards'     => '4',
        'Slight Right Curve Inwards'    => '5',
        'Sharp Left Curve Inwards'      => '6',
        'Sharp Right Curve Inwards'     => '7',
        'Sharp Left Line Inwards'       => '8',
        'Sharp Right Line Inwards'      => '9',
        'Inwards Wave Pattern'          => '10',
        'Inwards Cloud Pattern'         => '11',
        'Simple Cloud Pattern'          => '12',
        'Stamps'                        => '13',
        'Slits'                         => '14',        
        'Big Triangle'                  => '15',
        'Big Triangle with Shadow'      => '16',        
        'Curve Up'                      => '17',
        'Curve Down'                    => '18',
        'Big Half Circle'               => '19',
    );
    
    // Define Array for Backgrounds
    $this->TS_VCSC_Background_List = array(
        ''                              => '',
        'P00'                           => 'images/pattern/00.jpg',
        'P01'                           => 'images/pattern/01.jpg',
        'P02'                           => 'images/pattern/02.jpg',
        'P03'                           => 'images/pattern/03.jpg',
        'P04'                           => 'images/pattern/04.jpg',
        'P05'                           => 'images/pattern/05.jpg',
        'P06'                           => 'images/pattern/06.jpg',
        'P07'                           => 'images/pattern/07.jpg',
        'P08'                           => 'images/pattern/08.jpg',
        'P09'                           => 'images/pattern/09.jpg',
        'P10'                           => 'images/pattern/10.jpg',
        'P11'                           => 'images/pattern/11.jpg',
        'P12'                           => 'images/pattern/12.jpg',
        'P13'                           => 'images/pattern/13.jpg',
        'P14'                           => 'images/pattern/14.jpg',
        'P15'                           => 'images/pattern/15.jpg',
        'P16'                           => 'images/pattern/16.jpg',
        'P17'                           => 'images/pattern/17.jpg',
        'P18'                           => 'images/pattern/18.jpg',
        'P19'                           => 'images/pattern/19.jpg',
        'P20'                           => 'images/pattern/20.jpg',
        'P21'                           => 'images/pattern/21.jpg',
        'P22'                           => 'images/pattern/22.jpg',
        'P23'                           => 'images/pattern/23.jpg',
        'P24'                           => 'images/pattern/24.jpg',
        'P25'                           => 'images/pattern/25.jpg',
        'P26'                           => 'images/pattern/26.jpg',
        'P27'                           => 'images/pattern/27.jpg',
        'P28'                           => 'images/pattern/28.jpg',
        'P29'                           => 'images/pattern/29.jpg',
        'P30'                           => 'images/pattern/30.jpg',
        'P31'                           => 'images/pattern/31.jpg',
        'P32'                           => 'images/pattern/32.jpg',
        'P33'                           => 'images/pattern/33.jpg',
        'P34'                           => 'images/pattern/34.jpg',
        'P35'                           => 'images/pattern/35.jpg',
        'P36'                           => 'images/pattern/36.jpg',
        'P37'                           => 'images/pattern/37.jpg',
        'P38'                           => 'images/pattern/38.jpg',
        'P39'                           => 'images/pattern/39.jpg',
        'P40'                           => 'images/pattern/40.jpg',
        'P41'                           => 'images/pattern/41.jpg',
        'P42'                           => 'images/pattern/42.jpg',
        'P43'                           => 'images/pattern/43.jpg',
        'P44'                           => 'images/pattern/44.jpg',
        'P45'                           => 'images/pattern/45.jpg',
        'P46'                           => 'images/pattern/46.jpg',
        'P47'                           => 'images/pattern/47.jpg',
        'P48'                           => 'images/pattern/48.jpg',
        'P49'                           => 'images/pattern/49.jpg',
        'P50'                           => 'images/pattern/50.jpg',
        'P51'                           => 'images/pattern/51.jpg',
        'P52'                           => 'images/pattern/52.jpg',
        'P53'                           => 'images/pattern/53.jpg',
        'P54'                           => 'images/pattern/54.jpg',
        'P55'                           => 'images/pattern/55.jpg',
        'P56'                           => 'images/pattern/56.jpg',
        'P57'                           => 'images/pattern/57.jpg',
        'P58'                           => 'images/pattern/58.jpg',
        'P59'                           => 'images/pattern/59.jpg',
        'P60'                           => 'images/pattern/60.jpg',
        'P61'                           => 'images/pattern/61.jpg',
        'P62'                           => 'images/pattern/62.jpg',
        'P63'                           => 'images/pattern/63.jpg',
        'P64'                           => 'images/pattern/64.jpg',
        'P65'                           => 'images/pattern/65.jpg',
        'P66'                           => 'images/pattern/66.jpg',
        'P67'                           => 'images/pattern/67.jpg',
        'P68'                           => 'images/pattern/68.jpg',
        'P69'                           => 'images/pattern/69.jpg',
        'P70'                           => 'images/pattern/70.jpg',
        'P71'                           => 'images/pattern/71.jpg',
        'P72'                           => 'images/pattern/72.jpg',
        'P73'                           => 'images/pattern/73.jpg',
        'P74'                           => 'images/pattern/74.jpg',
        'P75'                           => 'images/pattern/75.jpg',
        'P76'                           => 'images/pattern/76.jpg',
        'P77'                           => 'images/pattern/77.jpg',
        'P78'                           => 'images/pattern/78.jpg',
        'P79'                           => 'images/pattern/79.jpg',
        'P80'                           => 'images/pattern/80.jpg',
        'P81'                           => 'images/pattern/81.jpg',
        'P82'                           => 'images/pattern/82.jpg',
        'P83'                           => 'images/pattern/83.jpg',
        'P84'                           => 'images/pattern/84.jpg',
        'P85'                           => 'images/pattern/85.jpg',
        'P86'                           => 'images/pattern/86.jpg',
        'P87'                           => 'images/pattern/87.jpg',
        'P88'                           => 'images/pattern/88.jpg',
        'P89'                           => 'images/pattern/89.jpg',
        'P90'                           => 'images/pattern/90.jpg',
        'P91'                           => 'images/pattern/91.jpg',
        'P92'                           => 'images/pattern/92.jpg',
        'P93'                           => 'images/pattern/93.jpg',
        'P94'                           => 'images/pattern/94.jpg',
        'P95'                           => 'images/pattern/95.jpg',
        'P96'                           => 'images/pattern/96.jpg',
        'P97'                           => 'images/pattern/97.jpg',
        'P98'                           => 'images/pattern/98.jpg',
        'P99'                           => 'images/pattern/99.jpg',
    );
    
    // Define Array for Raster Images
    $this->TS_VCSC_Rasters_List = array(
        ''                              => '',
        'R00'                           => 'images/rasters/00.png',
        'R01'                           => 'images/rasters/01.png',
        'R02'                           => 'images/rasters/02.png',
        'R03'                           => 'images/rasters/03.png',
        'R04'                           => 'images/rasters/04.png',
        'R05'                           => 'images/rasters/05.png',
        'R06'                           => 'images/rasters/06.png',
        'R07'                           => 'images/rasters/07.png',
        'R08'                           => 'images/rasters/08.png',
        'R09'                           => 'images/rasters/09.png',
        'R10'                           => 'images/rasters/10.png',
        'R11'                           => 'images/rasters/11.png',
        'R12'                           => 'images/rasters/12.png',
        'R13'                           => 'images/rasters/13.png',
        'R14'                           => 'images/rasters/14.png',
        'R15'                           => 'images/rasters/15.png',
        'R16'                           => 'images/rasters/16.png',
        'R17'                           => 'images/rasters/17.png',
        'R18'                           => 'images/rasters/18.png',
        'R19'                           => 'images/rasters/19.png',
        'R20'                           => 'images/rasters/20.png',
        'R21'                           => 'images/rasters/21.png',
        'R22'                           => 'images/rasters/22.png',
        'R23'                           => 'images/rasters/23.png',
        'R24'                           => 'images/rasters/24.png',
        'R25'                           => 'images/rasters/25.png',
        'R26'                           => 'images/rasters/26.png',
        'R27'                           => 'images/rasters/27.png',
        'R28'                           => 'images/rasters/28.png',
        'R29'                           => 'images/rasters/29.png',
        'R30'                           => 'images/rasters/30.png',
        'R31'                           => 'images/rasters/31.png',
        'R32'                           => 'images/rasters/32.png',
        'R33'                           => 'images/rasters/33.png',
        'R34'                           => 'images/rasters/34.png',
    );
    
    // Define Array for Bullet Images
    $this->TS_VCSC_Bullets_List = array(
        'B00'                           => 'images/bullets/bullet_arrow_black.png',
        'B01'                           => 'images/bullets/bullet_arrow_blue.png',
        'B02'                           => 'images/bullets/bullet_arrow_gray.png',
        'B03'                           => 'images/bullets/bullet_arrow_green.png',
        'B04'                           => 'images/bullets/bullet_arrow_red.png',
        'B05'                           => 'images/bullets/bullet_arrow_yellow.png',
        'B06'                           => 'images/bullets/bullet_check_black.png',
        'B07'                           => 'images/bullets/bullet_check_blue.png',
        'B08'                           => 'images/bullets/bullet_check_gray.png',
        'B09'                           => 'images/bullets/bullet_check_green.png',
        'B10'                           => 'images/bullets/bullet_check_red.png',
        'B11'                           => 'images/bullets/bullet_check_yellow.png',
        'B12'                           => 'images/bullets/bullet_cross_black.png',
        'B13'                           => 'images/bullets/bullet_cross_blue.png',
        'B14'                           => 'images/bullets/bullet_cross_gray.png',
        'B15'                           => 'images/bullets/bullet_cross_green.png',
        'B16'                           => 'images/bullets/bullet_cross_red.png',
        'B17'                           => 'images/bullets/bullet_cross_yellow.png',
        'B18'                           => 'images/bullets/bullet_minus_black.png',
        'B19'                           => 'images/bullets/bullet_minus_blue.png',
        'B20'                           => 'images/bullets/bullet_minus_gray.png',
        'B21'                           => 'images/bullets/bullet_minus_green.png',
        'B22'                           => 'images/bullets/bullet_minus_red.png',
        'B23'                           => 'images/bullets/bullet_minus_yellow.png',
        'B24'                           => 'images/bullets/bullet_plus_black.png',
        'B25'                           => 'images/bullets/bullet_plus_blue.png',
        'B26'                           => 'images/bullets/bullet_plus_gray.png',
        'B27'                           => 'images/bullets/bullet_plus_green.png',
        'B28'                           => 'images/bullets/bullet_plus_red.png',
        'B29'                           => 'images/bullets/bullet_plus_yellow.png',
    );
?>