<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                      => __( "TS Content Flip", "ts_visual_composer_extend" ),
            "base"                      => "TS-VCSC-Content-Flip",
            "icon" 	                    => "icon-wpb-ts_vcsc_content_flip",
            "class"                     => "",
            "category"                  => __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"               => __("Place a content flip element", "ts_visual_composer_extend"),
            "admin_enqueue_js"			=> "",
            "admin_enqueue_css"			=> "",
            "params"                    => array(
                // Main Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_1",
					"value"				=> "",
                    "seperator"			=> "Flip Effect",
                    "description"       => __( "", "ts_visual_composer_extend" )
                ),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Style", "ts_visual_composer_extend" ),
					"param_name"        => "flip_style",
					"width"             => 300,
					"value"             => array(
						__( 'Standard', "ts_visual_composer_extend" )     			=> "style1",
                        __( 'Cube', "ts_visual_composer_extend" )         			=> "style2",
					),
                    "admin_label"       => true,
					"description"       => __( "Select the type of flip box element.", "ts_visual_composer_extend" )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Effect Style", "ts_visual_composer_extend" ),
					"param_name"        => "flip_effect_style1",
					"width"             => 300,
					"value"             => array(
						__( 'Horizontal Flip', "ts_visual_composer_extend" )      	=> "horizontal",
                        __( 'Vertical Flip', "ts_visual_composer_extend" )        	=> "vertical",
					),
					"description"       => __( "Select the type of flip effect.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_style", 'value' => 'style1' )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Effect Style", "ts_visual_composer_extend" ),
					"param_name"        => "flip_effect_style2",
					"width"             => 300,
					"value"             => array(
						__( 'Flip Right', "ts_visual_composer_extend" )   			=> "ts-flip-right",
                        __( 'Flip Up', "ts_visual_composer_extend" )      			=> "ts-flip-up",
					),
					"description"       => __( "Select the type of flip effect.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_style", 'value' => 'style2' )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Effect Speed", "ts_visual_composer_extend" ),
					"param_name"        => "flip_effect_speed",
					"width"             => 300,
					"value"             => array(
                        __( 'Medium', "ts_visual_composer_extend" )       			=> "medium",
						__( 'Very Slow', "ts_visual_composer_extend" )    			=> "veryslow",
                        __( 'Slow', "ts_visual_composer_extend" )         			=> "slow",
                        __( 'Fast', "ts_visual_composer_extend" )         			=> "fast",
                        __( 'Very Fast', "ts_visual_composer_extend" )    			=> "veryfast",
					),
					"description"       => __( "Select the speed for the flip effect.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_style", 'value' => 'style1' )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Trigger", "ts_visual_composer_extend" ),
					"param_name"        => "flip_trigger",
					"width"             => 300,
					"value"             => array(
                        __( 'Hover', "ts_visual_composer_extend" )       			=> "hover",
						__( 'Click', "ts_visual_composer_extend" )    				=> "click",
					),
					"description"       => __( "Select how the flip effect should be triggered; mobile devices will always revert to a tap event.", "ts_visual_composer_extend" ),
				),	
				array(
					"type"             	=> "switch_button",
                    "heading"           => __( "Auto-Size Flip Box Height", "ts_visual_composer_extend" ),
                    "param_name"        => "flip_size_auto",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "admin_label"       => true,
                    "description"       => __( "Switch the toggle if you want to auto-size the height of the content flip box.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Flip Box Size", "ts_visual_composer_extend" ),
					"param_name"        => "flip_size_type",
					"width"             => 300,
					"value"             => array(
                        __( 'Fixed Height', "ts_visual_composer_extend" )       			=> "fixed",
						__( 'Minimum Height', "ts_visual_composer_extend" )    				=> "minimum",
                        __( 'Maximum Height', "ts_visual_composer_extend" )					=> "maximum",
					),
					"description"       => __( "Select the speed for the flip effect.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_size_auto", 'value' => 'false' )
				),				
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Fixed Height", "ts_visual_composer_extend" ),
                    "param_name"        => "flip_size",
                    "value"             => "100",
                    "min"               => "200",
                    "max"               => "800",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the fixed height for the content flip element.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_size_type", 'value' => 'fixed' )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Minimum Height", "ts_visual_composer_extend" ),
                    "param_name"        => "flip_size_min",
                    "value"             => "100",
                    "min"               => "200",
                    "max"               => "800",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the minimum height for the content flip element.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_size_type", 'value' => 'minimum' )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Maximum Height", "ts_visual_composer_extend" ),
                    "param_name"        => "flip_size_max",
                    "value"             => "100",
                    "min"               => "200",
                    "max"               => "800",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the maximum height for the content flip element.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "flip_size_type", 'value' => 'maximum' )
                ),
                // Content Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_2",
					"value"				=> "",
                    "seperator"			=> "Front Panel",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Content",
                ),
                array(
                    "type"              => "textfield",
                    "heading"           => __( "Front Panel Title", "ts_visual_composer_extend" ),
                    "param_name"        => "front_title",
                    "value"             => "",
                    "description"       => __( "Enter the title for the front panel.", "ts_visual_composer_extend" ),
					"group" 			=> "Content",
                ),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Front Panel Title Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_fronttitle_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_fronttitle_type",
                    "description"		=> __( "Select the font to be used for the front title text.", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_fronttitle_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Allow HTML Code", "ts_visual_composer_extend" ),
                    "param_name"        => "front_html",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to allow for HTML code to create the front panel content.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Content",
				),
                array(
                    "type"              => "textarea",
                    "class"             => "",
                    "heading"           => __( "Front Panel Message", "ts_visual_composer_extend" ),
                    "param_name"        => "front_content",
                    "value"             => "",
                    "description"       => __( "Enter the content for the front panel; HTML code can NOT be used.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_html", 'value' => 'false' ),
					"group" 			=> "Content",
                ),
                array(
                    "type"              => "textarea_raw_html",
                    "class"             => "",
                    "heading"           => __( "Front Panel Message", "ts_visual_composer_extend" ),
                    "param_name"        => "front_content_html",
                    "value"             => base64_encode(""),
                    "description"       => __( "Enter the content for front panel; HTML code can be used.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_html", 'value' => 'true' ),
					"group" 			=> "Content",
                ),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Front Panel Message Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_frontcontent_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_frontcontent_type",
                    "description"		=> __( "Select the font to be used for the front message text.", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_frontcontent_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_3",
					"value"				=> "",
                    "seperator"			=> "Back Panel",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Content",
                ),
                array(
                    "type"              => "textfield",
                    "heading"           => __( "Back Panel Title", "ts_visual_composer_extend" ),
                    "param_name"        => "back_title",
                    "value"             => "",
                    "description"       => __( "Enter the title for the back panel.", "ts_visual_composer_extend" ),
					"group" 			=> "Content",
                ),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Back Panel Title Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_backtitle_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_backtitle_type",
                    "description"		=> __( "Select the font to be used for the back title text.", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_backtitle_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Allow HTML Code", "ts_visual_composer_extend" ),
                    "param_name"        => "back_html",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to allow for HTML code to create the back panel content.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Content",
				),
                array(
                    "type"              => "textarea",
                    "class"             => "",
                    "heading"           => __( "Back Panel Message", "ts_visual_composer_extend" ),
                    "param_name"        => "back_content",
                    "value"             => "",
                    "description"       => __( "Enter the content for the back panel; HTML code can NOT be used.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "back_html", 'value' => 'false' ),
					"group" 			=> "Content",
                ),
                array(
                    "type"              => "textarea_raw_html",
                    "class"             => "",
                    "heading"           => __( "Back Panel Message", "ts_visual_composer_extend" ),
                    "param_name"        => "back_content_html",
                    "value"             => base64_encode(""),
                    "description"       => __( "Enter the content for the back panel; HTML code can be used.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "back_html", 'value' => 'true' ),
					"group" 			=> "Content",
                ),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Back Panel Message Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_backcontent_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_backcontent_type",
                    "description"		=> __( "Select the font to be used for the back message text.", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_backcontent_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group"				=> "Content",
                ),
				// Read More Button Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_4",
					"value"				=> "",
					"seperator"			=> "Read More Link",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Content",
				),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Add Link", "ts_visual_composer_extend" ),
                    "param_name"        => "read_more_link",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to add a link to the back panel.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Content",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Read More Button Text", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_txt",
					"value"             => "Read More",
					"description"       => __( "Enter the text to be shown in the link button.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => 'true' ),
					"group" 			=> "Content",
				),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Button Text Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_button_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_button_type",
                    "description"		=> __( "Select the font to be used for the link button text.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group"				=> "Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_button_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group"				=> "Content",
                ),
				array(
					"type"              => "textfield",
					"heading"           => __( "Read More URL", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_url",
					"value"             => "",
					"description"       => __( "Enter the URL for the link (starting with http://).", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group" 			=> "Content",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Link Target", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_target",
					"value"             => array(
						__( "Same Window", "ts_visual_composer_extend" )                    => "_parent",
						__( "New Window", "ts_visual_composer_extend" )                     => "_blank"
					),
					"description"       => __( "Define how the link should be opened.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group" 			=> "Content",
				),
                // Icon / Image Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_5",
					"value"				=> "",
                    "seperator"			=> "Flip Box Icon / Image",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Icon / Image",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Use Normal Image", "ts_visual_composer_extend" ),
                    "param_name"        => "front_icon_replace",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle to either use a font icon or a normal image on the front panel.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Icon / Image",
				),
				array(
					'type' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorType,
					'heading' 			=> __( 'Select Icon', 'ts_visual_composer_extend' ),
					'param_name' 		=> 'front_icon',
					'value'				=> '',
					'source'			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorValue,
					'settings' 			=> array(
						'emptyIcon' 			=> true,
						'type' 					=> 'extensions',
						'iconsPerPage' 			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorPager,
						'source' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorSource,
					),
					"admin_label"       => true,
					"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon for the front panel.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
                    "dependency"        => array( 'element' => "front_icon_replace", 'value' => 'false' ),
					"group" 			=> "Icon / Image",
				),
                array(
                    "type"              => "attach_image",
                    "heading"           => __( "Select Image", "ts_visual_composer_extend" ),
                    "param_name"        => "front_image",
                    "value"             => "false",
                    "description"       => __( "If not used as full size, image should have equal dimensions for scaling purposes (i.e. 100x100)", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_icon_replace", 'value' => 'true' ),
					"group" 			=> "Icon / Image",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Use as Full Size Image", "ts_visual_composer_extend" ),
                    "param_name"        => "front_image_full",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to use the image as full-size image on the front without any other elements.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_icon_replace", 'value' => 'true' ),
					"group" 			=> "Icon / Image",
				),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image Size", "ts_visual_composer_extend" ),
                    "param_name"        => "front_icon_size",
                    "value"             => "70",
                    "min"               => "16",
                    "max"               => "512",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the icon / image size for the front panel.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_image_full", 'value' => 'false' ),
					"group" 			=> "Icon / Image",
                ),
                // Flip Box Border
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_6",
					"value"				=> "",
                    "seperator"			=> "Flip Box Border",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Borders",
                ),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "flip_border_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
					"description"       => __( "Select the type of border around the icon / image.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Borders",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "flip_border_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "10",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the thickness of the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "flip_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Borders",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "flip_border_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
						__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
					),
					"description"       => __( "Define the radius of the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "flip_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Borders",
				),
				// Icon / Image Border Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_7",
					"value"				=> "",
                    "seperator"			=> "Icon / Image Border",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Borders",
                ),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon / Image Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_frame_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
					"description"       => __( "Select the type of border around the icon / image.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Borders",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_frame_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "10",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the thickness of the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "front_icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Borders",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon / Image Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_frame_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
						__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
					),
					"description"       => __( "Define the radius of the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "front_icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Borders",
				),
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Apply Padding to Icon / Image", "ts_visual_composer_extend" ),
					"param_name"        => "front_padding",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle if you want to apply a padding to the icon / image.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "front_icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Borders",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image Padding", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_padding",
					"value"             => "0",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "If image instead of icon, increase the image size by padding value.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "front_padding", 'value' => 'true' ),
					"group" 			=> "Borders",
				),
                // Main Color Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_8",
					"value"				=> "",
                    "seperator"			=> "Front Panel Colors",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Color Settings",
                ),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_color",
					"value"             => "#cccccc",
					"description"       => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "front_icon_replace", 'value' => 'false' ),
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon / Image Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_background",
					"value"             => "",
					"description"       => __( "Define the background color for the icon / transparent image.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon / Image Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_icon_frame_color",
					"value"             => "#000000",
					"description"       => __( "Define the color of the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "front_icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Font Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_color",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the front panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Title Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_color_title",
					"value"             => "#000000",
					"description"       => __( "Define the title color for the front panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "front_background",
					"value"             => "#ffffff",
					"description"       => __( "Define the background color for the front panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "flip_border_color_front",
					"value"             => "#dddddd",
					"description"       => __( "Define the border for the front panel.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "flip_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Color Settings",
				),
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_9",
					"value"				=> "",
                    "seperator"			=> "Back Panel Colors",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Color Settings",
                ),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Font Color", "ts_visual_composer_extend" ),
					"param_name"        => "back_color",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the back panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Title Color", "ts_visual_composer_extend" ),
					"param_name"        => "back_color_title",
					"value"             => "#000000",
					"description"       => __( "Define the title color for the back panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "back_background",
					"value"             => "#ffffff",
					"description"       => __( "Define the background color for the back panel.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "flip_border_color_back",
					"value"             => "#dddddd",
					"description"       => __( "Define the border for the back panel.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "flip_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Link Font Color", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_color",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the back panel link.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group" 			=> "Color Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Link Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_background",
					"value"             => "#dddddd",
					"description"       => __( "Define the background color for back panel link.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => "true" ),
					"group" 			=> "Color Settings",
				),
				// Animation Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_10",
					"value"				=> "",
					"seperator"			=> "Animations",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Add Animations", "ts_visual_composer_extend" ),
					"param_name"        => "animations",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle if you want to apply animations or a shadow to the flip box element.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Other Settings",
				),			
				array(
					"type"				=> "css3animations",
					"class"				=> "",
					"heading"			=> __("Icon / Image Animation", "ts_visual_composer_extend"),
					"param_name"		=> "animation_icon",
					"standard"			=> "false",
					"prefix"			=> "ts-infinite-css-",
					"connector"			=> "css3animations_in",
					"noneselect"		=> "true",
					"default"			=> "",
					"value"				=> "",
					"admin_label"		=> false,
					"description"		=> __("Select the animation for the icon / image.", "ts_visual_composer_extend"),
					"dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"				=> "hidden_input",
					"heading"			=> __( "Icon / Image Animation", "ts_visual_composer_extend" ),
					"param_name"		=> "css3animations_in",
					"value"				=> "",
					"admin_label"		=> true,
					"description"		=> __( "", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Viewport Animation", "ts_visual_composer_extend" ),
					"param_name"        => "animation_view",
					"value"             =>  array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Top to Bottom", "ts_visual_composer_extend" )                 => "top-to-bottom",
						__( "Bottom to Top", "ts_visual_composer_extend" )                 => "bottom-to-top",
						__( "Left to Right", "ts_visual_composer_extend" )                 => "left-to-right",
						__( "Right to Left", "ts_visual_composer_extend" )                 => "right-to-left",
						__( "Appear from Center", "ts_visual_composer_extend" )            => "appear",
					),
					"description"       => __( "Select the viewport animation for the flip box element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
				),
				// Other Flip Box Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_11",
					"value"				=> "",
					"seperator"			=> "Other Flip Box Settings",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
					"param_name"        => "margin_top",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
					"param_name"        => "margin_bottom",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_id",
					"value"             => "",
					"description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_class",
					"value"             => "",
					"description"       => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
                // Load Custom CSS/JS File
				array(
					"type"				=> "load_file",
					"heading"			=> __( "", "ts_visual_composer_extend" ),
					"value"				=> "",
					"param_name"		=> "el_file1",
					"file_type"			=> "js",
					"file_path"			=> "js/ts-visual-composer-extend-element.min.js",
					"description"		=> __( "", "ts_visual_composer_extend" )
				),
				array(
					"type"				=> "load_file",
					"heading"			=> __( "", "ts_visual_composer_extend" ),
					"value"				=> "",
					"param_name"		=> "el_file2",
					"file_type"			=> "css",
					"file_id"			=> "ts-extend-animations",
					"file_path"			=> "css/ts-visual-composer-extend-animations.min.css",
					"description"		=> __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>