<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                      => __( "TS Countdown", "ts_visual_composer_extend" ),
            "base"                      => "TS-VCSC-Countdown",
            "icon" 	                    => "icon-wpb-ts_vcsc_countdown",
            "class"                     => "",
            "category"                  => __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"               => __("Place a countdown element", "ts_visual_composer_extend"),
            "admin_enqueue_js"			=> "",
            "admin_enqueue_css"			=> "",
            "params"                    => array(
                // Date and Time Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_1",
					"value"				=> "",
                    "seperator"			=> "Date & Time Settings",
                    "description"       => __( "", "ts_visual_composer_extend" )
                ),				
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Date / Time Limitations", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_scope",
                    "width"             => 150,
                    "value"             => array(
						__( 'Specific Date Only', "ts_visual_composer_extend" )												=> "1",
						__( 'Specific Date Only [Shortcode]', "ts_visual_composer_extend" )									=> "1S",
						__( 'Specific Date and Time', "ts_visual_composer_extend" )											=> "2",
						__( 'Specific Date and Time [Shortcode]', "ts_visual_composer_extend" )								=> "2S",
                        __( 'Specific Time Only (repeating on every day)', "ts_visual_composer_extend" )					=> "3",
						__( 'Resetting Counter (set interval up to 24 hours)', "ts_visual_composer_extend" )				=> "4",
						__( 'Count Time Since Pageload', "ts_visual_composer_extend" )										=> "5",
                    ),
					"admin_label"		=> true,
                    "description"       => __( "Select the countdown scope in terms of date and time.", "ts_visual_composer_extend" )
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Timezone Adjustment", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_zone",
                    "width"             => 150,
                    "value"             => array(
						__( 'User Time / No Adjustment', "ts_visual_composer_extend" )			=> "false",
						'GMT -12:00'															=> "-12",
						'GMT -11:00'															=> "-11",
						'GMT -10:00'															=> "-10",
						'GMT -09:00'															=> "-9",
						'GMT -08:00'															=> "-8",
						'GMT -07:00'															=> "-7",
						'GMT -06:00'															=> "-6",
						'GMT -05:00'															=> "-5",
						'GMT -04:00'															=> "-4",
						'GMT -03:00'															=> "-3",
						'GMT -03:30'															=> "-3.5",
						'GMT -02:00'															=> "-2",
						'GMT -01:00'															=> "-1",
						'GMT 00:00'																=> "0",
						'GMT +01:00'															=> "1",
						'GMT +02:00'															=> "2",
						'GMT +03:00'															=> "3",
						'GMT +03:30'															=> "3.5",
						'GMT +04:00'															=> "4",
						'GMT +04:30'															=> "4.5",
						'GMT +05:00'															=> "5",
						'GMT +05:30'															=> "5.5",
						'GMT +05:45'															=> "5.75",
						'GMT +06:00'															=> "6",
						'GMT +06:30'															=> "6.5",
						'GMT +07:00'															=> "7",
						'GMT +08:00'															=> "8",
						'GMT +09:00'															=> "9",
						'GMT +09:30'															=> "9.5",
						'GMT +10:00'															=> "10",
						'GMT +11:00'															=> "11",
						'GMT +12:00'															=> "12",
						'GMT +13:00'															=> "13",
                    ),
					"admin_label"		=> true,
                    "description"       => __( "If required, define a timezone adjustment for the countdown. Learn more:", "ts_visual_composer_extend" ) . ' <a href="http://www.timeanddate.com/time/map/" target="_blank">' . __( 'Time Zones', "ts_visual_composer_extend" ) . '</a>',
                ),				
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Switch to CountUp", "ts_visual_composer_extend" ),
                    "param_name"        => "countup",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"admin_label"		=> true,
                    "description"       => __( "Switch the toggle if you want the countdown to automatically switch into 'count up' mode once target date / time has been reached or was intentionally set in the past in order to show expired time.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('1', '1S', '2', '2S') )
				),				
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Minute Intervals", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_interval",
                    "width"             => 150,
                    "value"             => array(
						__( '60 Minutes', "ts_visual_composer_extend" )											=> "60",
						__( '30 Minutes', "ts_visual_composer_extend" )											=> "30",
                        __( '15 Minutes', "ts_visual_composer_extend" )											=> "15",
						__( '10 Minutes', "ts_visual_composer_extend" )											=> "10",
						__( '5 Minutes', "ts_visual_composer_extend" )											=> "5",
						__( '1 Minute', "ts_visual_composer_extend" )											=> "1",
                    ),
                    "description"       => __( "Select the intervals for the time selector.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('2', '3') )
                ),				
                array(
                    "type"              => "datetime_picker",
                    "heading"           => __( "Date", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_date",
					"period"			=> "date",
                    "value"             => "",
                    "admin_label"		=> true,
                    "description"       => __( "Select the date to which you want to count down to.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('1') )
                ),
				array(
					"type"              => "textarea_raw_html",
					"heading"           => __( "Date [Shortcode]", "ts_visual_composer_extend" ),
					"param_name"        => "shortcode_date",
					"value"             => base64_encode(""),
					"description"       => __( "Enter the shortcode that will dynamically generate the target date for the countdown; required date format: mm/dd/yyyy.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => '1S' ),
				),				
                array(
                    "type"              => "datetime_picker",
                    "heading"           => __( "Date / Time", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_datetime",
					"period"			=> "datetime",
                    "value"             => "",
                    "admin_label"		=> true,
                    "description"       => __( "Select the date and time to which you want to count down to.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('2') )
                ),
				array(
					"type"              => "textarea_raw_html",
					"heading"           => __( "Date / Time [Shortcode]", "ts_visual_composer_extend" ),
					"param_name"        => "shortcode_datetime",
					"value"             => base64_encode(""),
					"description"       => __( "Enter the shortcode that will dynamically generate the target date and time for the countdown; required date/time format: mm/dd/yyyy hh:mm AM/PM.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => '2S' ),
				),	
                array(
                    "type"              => "datetime_picker",
                    "heading"           => __( "Time", "ts_visual_composer_extend" ),
                    "param_name"        => "counter_time",
					"period"			=> "time",
                    "value"             => "",
                    "admin_label"		=> true,
                    "description"       => __( "Select the time on the day above to which you want to count down to.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('3') )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Reset in Hours", "ts_visual_composer_extend" ),
                    "param_name"        => "reset_hours",
                    "value"             => "0",
                    "min"               => "0",
                    "max"               => "23",
                    "step"              => "1",
                    "unit"              => 'hr',
                    "description"       => __( "Define the number of hours until countdown reset.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('4') )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Reset in Minutes", "ts_visual_composer_extend" ),
                    "param_name"        => "reset_minutes",
                    "value"             => "15",
                    "min"               => "0",
                    "max"               => "59",
                    "step"              => "1",
                    "unit"              => 'min',
                    "description"       => __( "Define the number of minutes until countdown reset.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('4') )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Reset in Seconds", "ts_visual_composer_extend" ),
                    "param_name"        => "reset_seconds",
                    "value"             => "0",
                    "min"               => "0",
                    "max"               => "59",
                    "step"              => "1",
                    "unit"              => 's',
                    "description"       => __( "Define the number of seconds until countdown reset.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('4') )
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Automatic Restart", "ts_visual_composer_extend" ),
                    "param_name"        => "reset_restart",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to restart the countdown after each expiration.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('4') )
				),
				array(
					"type" 				=> "vc_link",
					"heading" 			=> __("Page Referrer", "ts_visual_composer_extend"),
					"param_name" 		=> "reset_link",
					"description" 		=> __("Provide an optional link to another site/page to be opened after countdown expires.", "ts_visual_composer_extend"),
					"dependency"        => array( 'element' => "counter_scope", 'value' => array('4') )
				),
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_2",
					"value"				=> "",
                    "seperator"			=> "Display Options",
                    "description"       => __( "", "ts_visual_composer_extend" )
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Show Remaining Days", "ts_visual_composer_extend" ),
                    "param_name"        => "date_days",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to show the number of days remaining.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "style", 'value' => array('minimum', 'columns', 'bars', 'circles', 'flipboard') )
				),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Show Remaining Hours", "ts_visual_composer_extend" ),
                    "param_name"        => "date_hours",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to show the number of hours remaining.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
				),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Show Remaining Minutes", "ts_visual_composer_extend" ),
                    "param_name"        => "date_minutes",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to show the number of minutes remaining.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
				),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Show Remaining Seconds", "ts_visual_composer_extend" ),
                    "param_name"        => "date_seconds",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to show the number of seconds remaining.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
				),
                // Style Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_3",
					"value"				=> "",
                    "seperator"			=> "Style Settings",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Style", "ts_visual_composer_extend" ),
                    "param_name"        => "style",
                    "width"             => 150,
                    "value"             => array(
						__( 'Minimum Styling', "ts_visual_composer_extend" )				=> "minimum",
						__( 'Basic Styling with Columns', "ts_visual_composer_extend" )		=> "columns",
                        __( 'Bars Layout', "ts_visual_composer_extend" )					=> "bars",
                        __( 'Digital Clock 1', "ts_visual_composer_extend" )        		=> "clock1",
						__( 'Digital Clock 2', "ts_visual_composer_extend" )        		=> "clock2",
						__( 'Circles Layout', "ts_visual_composer_extend" )					=> "circles",
						__( '3D Horizontal Flip', "ts_visual_composer_extend" )				=> "horizontal",
						__( 'Flipboard Layout', "ts_visual_composer_extend" )				=> "flipboard",
                    ),
					"admin_label"		=> true,
                    "description"       => __( "Select the style for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => '',
					"group" 			=> "Style Settings",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Show Leading Zeros", "ts_visual_composer_extend" ),
                    "param_name"        => "date_zeros",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to show a leading zero for values less than 10.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('minimum', 'columns', 'bars', 'clock1', 'clock2', 'circles', 'horizontal') ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Countdown Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "border_type",
					"width"             => 300,
                    "value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
                    ),
					"description"       => __( "Select the type of border around the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Countdown Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "border_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "10",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the thickness of the countdown element border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Countdown Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "border_radius",
                    "value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
                    ),
					"description"       => __( "Define the radius of the countdown element border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Countdown Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "border_color",
					"value"             => "#dddddd",
					"description"       => __( "Define the color of the countdown element border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Circle Width", "ts_visual_composer_extend" ),
                    "param_name"        => "circle_width",
                    "value"             => "5",
                    "min"               => "5",
                    "max"               => "25",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define the circle width in pixel.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
                ),
				// Color Settings for Basic Style
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_basic",
					"value"             => "#f7f7f7",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('minimum', 'columns') ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_basic",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('minimum', 'columns') ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Text Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_text_basic",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the text strings.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('minimum', 'columns') ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for Bars Style
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_bars",
					"value"             => "#ffc728",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'bars' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_bars",
					"value"             => "#ffffff",
					"description"       => __( "Define the font color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'bars' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Text Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_text_bars",
					"value"             => "#a76500",
					"description"       => __( "Define the font color for the text strings.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'bars' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Bar Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_barback_bars",
					"value"             => "#a66600",
					"description"       => __( "Define the background color for the animated bars.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'bars' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Bar Value Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_barfore_bars",
					"value"             => "#ffffff",
					"description"       => __( "Define the foreground color for the animated bars.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'bars' ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for Digital Clock Style 1
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_clock1",
					"value"             => "#000000",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'clock1' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_clock1",
					"value"             => "#ffffff",
					"description"       => __( "Define the font color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'clock1' ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for Digital Clock Style 2
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_clock2",
					"value"             => "#000000",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'clock2' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_clock2",
					"value"             => "#00deff",
					"description"       => __( "Define the font color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'clock2' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Dividers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_dividers_clock2",
					"value"             => "#00deff",
					"description"       => __( "Define the color for the dividers between the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'clock2' ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for Circles Style
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_circles",
					"value"             => "#000000",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_circles",
					"value"             => "#ffffff",
					"description"       => __( "Define the font color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Text Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_text_circles",
					"value"             => "#929292",
					"description"       => __( "Define the font color for the text strings.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Circles Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_circleback_all",
					"value"             => "#282828",
					"description"       => __( "Define the background color for the animated circles.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Circles Value Color: Days", "ts_visual_composer_extend" ),
					"param_name"        => "color_circlefore_days",
					"value"             => "#117d8b",
					"description"       => __( "Define the background color for the animated days value.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Circles Value Color: Hours", "ts_visual_composer_extend" ),
					"param_name"        => "color_circlefore_hours",
					"value"             => "#117d8b",
					"description"       => __( "Define the background color for the animated hours value.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Circles Value Color: Minutes", "ts_visual_composer_extend" ),
					"param_name"        => "color_circlefore_minutes",
					"value"             => "#117d8b",
					"description"       => __( "Define the background color for the animated minutes value.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Circles Value Color: Seconds", "ts_visual_composer_extend" ),
					"param_name"        => "color_circlefore_seconds",
					"value"             => "#117d8b",
					"description"       => __( "Define the background color for the animated seconds value.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'circles' ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for 3D Horizontal Flip Style
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_horizontal",
					"value"             => "#ffffff",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'horizontal' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_flippers_horizontal",
					"value"             => "#00bfa0",
					"description"       => __( "Define the background color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'horizontal' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Numbers Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_numbers_horizontal",
					"value"             => "#ffffff",
					"description"       => __( "Define the color for the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'horizontal' ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Text Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_text_horizontal",
					"value"             => "#929292",
					"description"       => __( "Define the font color for the text strings below the numbers.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'horizontal' ),
					"group" 			=> "Style Settings",
				),
				// Color Settings for Flipboard Style
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "color_background_flipboard",
					"value"             => "#ffffff",
					"description"       => __( "Define the background color for the countdown element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'flipboard' ),
					"group" 			=> "Style Settings",
				),
				// Column Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_4",
					"value"				=> "",
                    "seperator"			=> "Column Settings",
                    "description"       => __( 'These settings only apply to "Basic Styling with Columns".', "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
                ),
				array(
					"type"				=> "switch_button",
                    "heading"           => __( "Equalize Column Width", "ts_visual_composer_extend" ),
                    "param_name"        => "column_equal_width",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want all columns to have an equal width based on the largest column.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Column Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "column_background_color",
					"value"             => "#f7f7f7",
					"description"       => __( "Define the color of the countdown column border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "border_column_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Column Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "column_border_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
					"description"       => __( "Select the type of border around countdown columns.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Column Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "column_border_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "10",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the thickness of the countdown column border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "column_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Column Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "column_border_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
						__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
					),
					"description"       => __( "Define the radius of the countdown column border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "column_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Column Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "column_border_color",
					"value"             => "#dddddd",
					"description"       => __( "Define the color of the countdown column border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "column_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				// Other Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_5",
					"value"				=> "",
					"seperator"			=> "Other Settings",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
					"param_name"        => "margin_top",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
					"param_name"        => "margin_bottom",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_id",
					"value"             => "",
					"description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_class",
					"value"             => "",
					"description"       => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				// Load Custom CSS/JS File
				array(
					"type"              => "load_file",
					"heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "el_file",
					"value"             => "",
					"file_type"         => "js",
					"file_path"         => "js/ts-visual-composer-extend-element.min.js",
					"description"       => __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>