<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                      => __( "TS Fancy List", "ts_visual_composer_extend" ),
            "base"                      => "TS_VCSC_Fancy_List",
            "icon" 	                    => "icon-wpb-ts_vcsc_fancylist",
            "class"                     => "",
            "category"                  => __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"               => __("Place a fancy list element", "ts_visual_composer_extend"),
			"js_view"     				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorLivePreview == "true" ? "TS_VCSC_FancyListViewCustom" : ""),
            "admin_enqueue_js"        	=> "",
            "admin_enqueue_css"       	=> "",
            "params"                    => array(
                // List Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_1",
					"value"				=> "",
                    "seperator"         => "List Settings",
                    "description"       => __( "", "ts_visual_composer_extend" )
                ),
				array(
					"type"              => "dropdown",
					"heading"           => __( "List Type", "ts_visual_composer_extend" ),
					"param_name"        => "list_type",
					"width"             => 150,
					"value"             => array(
						__( "Unordered List (UL)", "ts_visual_composer_extend" )                    => "standard",
						__( "List with Image (UL)", "ts_visual_composer_extend" )                   => "image",
						__( "List with Icon (UL)", "ts_visual_composer_extend" )                   	=> "icon",
						__( "Ordered List (OL)", "ts_visual_composer_extend" )                      => "ordered",
					),
					"admin_label"       => true,
					"description"       => __( "Select the general type of list you want to create.", "ts_visual_composer_extend" )
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "List Bullet", "ts_visual_composer_extend" ),
					"param_name"        => "list_marker",
					"width"             => 150,
					"value"             => array(
						__( "Disc", "ts_visual_composer_extend" )                      				=> "disc",
						__( "Circle", "ts_visual_composer_extend" )                    				=> "circle",
						__( "Square", "ts_visual_composer_extend" )                   				=> "square",
						__( "Decimal", "ts_visual_composer_extend" )                   				=> "decimal",
						__( "Decimal Leading Zero", "ts_visual_composer_extend" )                   => "decimal-leading-zero",
						__( "Lower Roman", "ts_visual_composer_extend" )                   			=> "lower-roman",
						__( "Upper Roman", "ts_visual_composer_extend" )                   			=> "upper-roman",
						__( "Lower Greek", "ts_visual_composer_extend" )                   			=> "lower-greek",
						__( "Lower Latin", "ts_visual_composer_extend" )                   			=> "lower-latin",
						__( "Upper Latin", "ts_visual_composer_extend" )                   			=> "upper-latin",
						__( "Lower Alpha", "ts_visual_composer_extend" )                   			=> "lower-alpha",
						__( "Upper Alpha", "ts_visual_composer_extend" )                   			=> "upper-alpha",
						__( "Upper Armenian", "ts_visual_composer_extend" )                   		=> "upper-armenian",
						__( "Lower Armenian", "ts_visual_composer_extend" )                   		=> "lower-armenian",
						__( "Georgian", "ts_visual_composer_extend" )                   			=> "georgian",
						__( "None", "ts_visual_composer_extend" )                   				=> "none",
					),
					"description"       => __( "Select the type of list item bullet you want to utilize.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_type", 'value' => 'standard' )
				),		
				array(
					"type"              => "dropdown",
					"heading"           => __( "Order Type", "ts_visual_composer_extend" ),
					"param_name"        => "list_order",
					"width"             => 150,
					"value"             => array(
						__( "Decimal", "ts_visual_composer_extend" )                   				=> "decimal",
						__( "Decimal Leading Zero", "ts_visual_composer_extend" )                   => "decimal-leading-zero",
						__( "Lower Roman", "ts_visual_composer_extend" )                   			=> "lower-roman",
						__( "Upper Roman", "ts_visual_composer_extend" )                   			=> "upper-roman",
						__( "Lower Greek", "ts_visual_composer_extend" )                   			=> "lower-greek",
						__( "Lower Latin", "ts_visual_composer_extend" )                   			=> "lower-latin",
						__( "Upper Latin", "ts_visual_composer_extend" )                   			=> "upper-latin",
						__( "Lower Alpha", "ts_visual_composer_extend" )                   			=> "lower-alpha",
						__( "Upper Alpha", "ts_visual_composer_extend" )                   			=> "upper-alpha",
						__( "Upper Armenian", "ts_visual_composer_extend" )                   		=> "upper-armenian",
						__( "Lower Armenian", "ts_visual_composer_extend" )                   		=> "lower-armenian",
						__( "Georgian", "ts_visual_composer_extend" )                   			=> "georgian",
					),
					"description"       => __( "Select the type of list item bullet you want to utilize.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_type", 'value' => 'ordered' )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Order Start", "ts_visual_composer_extend" ),
					"param_name"        => "order_start1",
					"value"             => "0",
					"min"               => "-100",
					"max"               => "100",
					"step"              => "1",
					"unit"              => '',
					"description"       => __( "Define with which number or letter the ordered list should begin.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_order", 'value' => array('decimal', 'decimal-leading-zero') )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Order Start", "ts_visual_composer_extend" ),
					"param_name"        => "order_start2",
					"value"             => "1",
					"min"               => "1",
					"max"               => "100",
					"step"              => "1",
					"unit"              => '',
					"description"       => __( "Define with which number or letter the ordered list should begin.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_order", 'value' => array('lower-roman', 'upper-roman', 'lower-greek', 'lower-latin', 'upper-latin', 'lower-alpha', 'upper-alpha', 'upper-armenian', 'lower-armenian', 'georgian') )
				),
				array(
					"type"              => "background",
					"heading"           => __( "Bullet Image", "ts_visual_composer_extend" ),
					"param_name"        => "marker_image",
					"height"            => 130,
					"pattern"           => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Bullets_List,
					"value"				=> "",
					"encoding"          => "false",
					"empty"          	=> "false",
					"description"       => __( "Select the bullet image you want to use for the list.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_type", 'value' => 'image' )
				),
				array(
					'type' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorType,
					'heading' 			=> __( 'Bullet Icon', 'ts_visual_composer_extend' ),
					'param_name' 		=> 'marker_icon',
					'value'				=> '',
					'source'			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorValue,
					'settings' 			=> array(
						'emptyIcon' 			=> false,
						'type' 					=> 'extensions',
						'iconsPerPage' 			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorPager,
						'source' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorSource,
					),					
					"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon to be used as list bullet.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
					"dependency"        => array( 'element' => "list_type", 'value' => 'icon' )
				),	
				array(
					"type"              => "dropdown",
					"heading"           => __( "Bullet Position", "ts_visual_composer_extend" ),
					"param_name"        => "list_position",
					"width"             => 150,
					"value"             => array(
						__( "Outside", "ts_visual_composer_extend" )                      			=> "outside",
						__( "Inside", "ts_visual_composer_extend" )                    				=> "inside",
					),
					"description"       => __( "Select where the list bullet should be positioned in relation to the list item.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_type", 'value' => array('standard', 'ordered') )
				),	
				array(
					"type"              => "dropdown",
					"heading"           => __( "Bullet Position", "ts_visual_composer_extend" ),
					"param_name"        => "marker_position",
					"width"             => 150,
					"value"             => array(
						__( "Center", "ts_visual_composer_extend" )                      			=> "center",
						__( "Top", "ts_visual_composer_extend" )                    				=> "top",
						__( "Bottom", "ts_visual_composer_extend" )                    				=> "bottom",
					),
					"description"       => __( "Select where the list bullet should be positioned in relation to the list item.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "list_type", 'value' => array('image', 'icon') )
				),
                // List Content
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_2",
					"value"				=> "",
                    "seperator"         => "List Content",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "List Content",
                ),
                array(
                    "type"				=> "textarea_html",
                    "class"				=> "",
                    "heading"			=> __( "List Content", "ts_visual_composer_extend" ),
                    "param_name"		=> "content",
                    "value"				=> "<ul>
                                                <li>List Item 1</li>
                                                <li>List Item 2</li>
                                                <li>List Item 3</li>
                                                <li>List Item 4</li>
                                                <li>List Item 5</li>
                                            </ul>",
					"description"       => __( "Create the content for the list, using the predefined layout above. Add a new list item by pressing 'Enter' at the end of an existing item. Please do NOT:<br/>- Break the UL list layout<br/>- Convert the UL list into a OL list<br/>- Use nested lists<br/>- Add any other content besides the list", "ts_visual_composer_extend" ),
					"group" 			=> "List Content",
                ),
				// Bullet Style
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_3",
					"value"				=> "",
                    "seperator"         => "Bullet Style",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
                ),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Bullet Margin", "ts_visual_composer_extend" ),
					"param_name"        => "marker_margin",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Bullet Color", "ts_visual_composer_extend" ),
					"param_name"        => "marker_color",
					"value"             => "#000000",
					"description"       => __( "Define the color for the list bullet.", "ts_visual_composer_extend" ),
					"dependency"        => "",
					"group" 			=> "Style Settings",
				),		
				array(
					"type"              => "nouislider",
					"heading"           => __( "Bullet Size", "ts_visual_composer_extend" ),
					"param_name"        => "marker_size",
					"value"             => "12",
					"min"               => "10",
					"max"               => "32",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the size for the list element bullet.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				// Content Style
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_4",
					"value"				=> "",
                    "seperator"         => "Content Style",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
                ),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Content Color", "ts_visual_composer_extend" ),
					"param_name"        => "content_color",
					"value"             => "#000000",
					"description"       => __( "Define the font color for the list content.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Font Size", "ts_visual_composer_extend" ),
					"param_name"        => "content_size",
					"value"             => "14",
					"min"               => "12",
					"max"               => "70",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the font size to be used for each individual list item.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Line Height", "ts_visual_composer_extend" ),
					"param_name"        => "line_height",
					"value"             => "18",
					"min"               => "14",
					"max"               => "75",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the line height to be used for each individual list item.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "List Item Margin", "ts_visual_composer_extend" ),
					"param_name"        => "content_margin",
					"value"             => "5",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the top and bottom margin to be applied to each individual list item.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "List Item Intendation", "ts_visual_composer_extend" ),
					"param_name"        => "content_intend",
					"value"             => "0",
					"min"               => "0",
					"max"               => "250",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the intendation you want to apply to the list (to mimic a nested list).", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				// Border Settings
				array(
					"type"              => "dropdown",
					"heading"           => __( "Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "frame_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
					),
					"description"       => __( "Select the type of border to be used for each list item section.", "ts_visual_composer_extend" ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Border Position", "ts_visual_composer_extend" ),
					"param_name"        => "frame_position",
					"width"             => 300,
					"value"             => array(
						__( "Bottom", "ts_visual_composer_extend" )                         => "bottom",
						__( "Left", "ts_visual_composer_extend" )                  			=> "left",
						__( "Right", "ts_visual_composer_extend" )                 			=> "right",
						__( "Top", "ts_visual_composer_extend" )                 			=> "top",
					),
					"description"       => __( "Select where the border for each list item section should be placed.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "frame_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "10",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the thickness of the list item border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "frame_color",
					"value"             => "#cccccc",
					"description"       => __( "Define the color of the list item border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Border Spacing", "ts_visual_composer_extend" ),
					"param_name"        => "frame_padding",
					"value"             => "5",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the spacing between the border and the list element.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Style Settings",
				),
				// Other Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_5",
					"value"				=> "",
					"seperator"			=> "Other Settings",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
					"param_name"        => "margin_top",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
					"param_name"        => "margin_bottom",
					"value"             => "0",
					"min"               => "-50",
					"max"               => "200",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_id",
					"value"             => "",
					"description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"        => "el_class",
					"value"             => "",
					"description"       => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
				),
				// Load Custom CSS/JS File
				array(
					"type"              => "load_file",
					"heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "el_file",
					"value"             => "",
					"file_type"         => "js",
					"file_path"         => "js/ts-visual-composer-extend-element.min.js",
					"description"       => __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>