<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                          => __( "TS Video HTML5", "ts_visual_composer_extend" ),
            "base"                          => "TS_VCSC_HTML5_Video",
            "icon" 	                        => "icon-wpb-ts_vcsc_html5_video",
            "class"                         => "",
            "category"                      => __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"                   => __("Place a HTML5 video element", "ts_visual_composer_extend"),
            "admin_enqueue_js"              => "",
            "admin_enqueue_css"             => "",
            "params"                        => array(
				// Video Sources
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_1",
                    "value"                 => "",
					"seperator"				=> "Video Sources",
                    "description"           => __( "", "ts_visual_composer_extend" ),
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "MP4 Video Source", "ts_visual_composer_extend" ),
					"param_name"		    => "video_mp4_source",
                    "value"                 => "true",
                    "on"				    => __( 'Local', "ts_visual_composer_extend" ),
                    "off"				    => __( 'Remote', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want to use a local or remote MP4 video file.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
                ),
				array(
					"type"                  => "videoselect",
					"heading"               => __( "MP4 Video", "ts_visual_composer_extend" ),
					"param_name"            => "video_mp4_local",
					"video_format"			=> "mp4,m4v",
					"value"                 => "",
					"description"           => __( "Select a local MP4 video from WordPress.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "video_mp4_source", 'value' => 'true' ),
				),
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "MP4 Video", "ts_visual_composer_extend" ),
                    "param_name"            => "video_mp4_remote",
                    "value"                 => "",
                    "description"           => __( "Enter the remote path to the MP4 version of the video.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_mp4_source", 'value' => 'false' ),
                ),				
				array(
					"type"              	=> "messenger",
					"heading"           	=> __( "", "ts_visual_composer_extend" ),
					"param_name"        	=> "messenger",
					"color"					=> "#006BB7",
					"weight"				=> "normal",
					"size"					=> "14",
					"value"					=> "",
					"message"            	=> __( "If no alternative video formats (WEBM / OGG) are provided, the player will attempt to use the flash fallback in order to play the MP4 version on browsers without MP4 support.", "ts_visual_composer_extend" ),
					"description"       	=> __( "", "ts_visual_composer_extend" )
				),				
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "WEBM Video Source", "ts_visual_composer_extend" ),
					"param_name"		    => "video_webm_source",
                    "value"                 => "true",
                    "on"				    => __( 'Local', "ts_visual_composer_extend" ),
                    "off"				    => __( 'Remote', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want to use a local or remote WEBM video file.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
                ),
				array(
					"type"                  => "videoselect",
					"heading"               => __( "WEBM Video", "ts_visual_composer_extend" ),
					"param_name"            => "video_webm_local",
					"video_format"			=> "webm",
					"value"                 => "",
					"description"           => __( "Select a local WEBM video from WordPress.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "video_webm_source", 'value' => 'true' ),
				),
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "WEBM Video", "ts_visual_composer_extend" ),
                    "param_name"            => "video_webm_remote",
                    "value"                 => "",
                    "description"           => __( "Enter the remote path to the WEBM version of the video.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_webm_source", 'value' => 'false' ),
                ),				
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "OGV Video Source", "ts_visual_composer_extend" ),
					"param_name"		    => "video_ogg_source",
                    "value"                 => "true",
                    "on"				    => __( 'Local', "ts_visual_composer_extend" ),
                    "off"				    => __( 'Remote', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want to use a local or remote OGV video file.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
                ),
				array(
					"type"                  => "videoselect",
					"heading"               => __( "OGV Video", "ts_visual_composer_extend" ),
					"param_name"            => "video_ogg_local",
					"video_format"			=> "ogg,ogv",
					"value"                 => "",
					"description"           => __( "Select a local OGV video from WordPress.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "video_ogg_source", 'value' => 'true' ),
				),
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "OGV Video", "ts_visual_composer_extend" ),
                    "param_name"            => "video_ogg_remote",
                    "value"                 => "",
                    "description"           => __( "Enter the remote path to the OGV version of the video.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_ogg_source", 'value' => 'false' ),
                ),
				// Video Settings
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_2",
                    "value"                 => "",
					"seperator"				=> "Player Settings",
                    "description"           => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Player Settings",
                ),				
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Player Theme", "ts_visual_composer_extend" ),
					"param_name"		    => "video_theme",
                    "value"                 => array(
                        __("Maccaco", "ts_visual_composer_extend")					=> "maccaco",                        
                        __("Totally Looks Alike", "ts_visual_composer_extend")		=> "totallylookslike",
						__("Minimum", "ts_visual_composer_extend")					=> "minimum",
                    ),
					"description"		    => __( "Select the overall theme for the player.", "ts_visual_composer_extend" ),
					"dependency"		    => "",
					"group" 				=> "Player Settings",
				),				
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Video Sizing", "ts_visual_composer_extend" ),
					"param_name"		    => "video_objectfit",
                    "value"                 => array(
                        __("Aspect-Ratio", "ts_visual_composer_extend")				=> "aspectratio",
                        __("Fill", "ts_visual_composer_extend")                  	=> "fill",
                        __("None", "ts_visual_composer_extend")                 	=> "none",
                    ),
					"description"           => __( "Select how the video should be sized inside the player container.", "ts_visual_composer_extend" ),
					"dependency"            => "",
					"group" 				=> "Player Settings",
				),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Show as Fixed Player", "ts_visual_composer_extend" ),
					"param_name"		    => "video_fixed",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => true,
					"description"		    => __( "Switch the toggle if you want to show the player fixed on the screen; only if video is not shown in lightbox.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_lightbox", 'value' => 'false' ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Fixed Position", "ts_visual_composer_extend" ),
                    "param_name"            => "video_fixed_position",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'Bottom Left', "ts_visual_composer_extend" )		=> "bottomleft",
						__( 'Bottom Right', "ts_visual_composer_extend" )		=> "bottomright",
                        __( 'Top Left', "ts_visual_composer_extend" )			=> "topleft",
						__( 'Top Right', "ts_visual_composer_extend" )			=> "topright",
                    ),
                    "description"           => __( "Select the fixed position for the player on the screen.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
					"group" 				=> "Player Settings",
                ),
				array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Fixed Adjustment", "ts_visual_composer_extend" ),
                    "param_name"            => "video_fixed_adjust",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "500",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Define an additional position adjustment for the fixed player; i.e. to account for fixed menu bars.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Fixed Control", "ts_visual_composer_extend" ),
                    "param_name"            => "video_fixed_switch",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'Show / Hide Toggle', "ts_visual_composer_extend" )	=> "toggle",
						__( 'Remove Switch', "ts_visual_composer_extend" )		=> "remove",
                        __( 'None', "ts_visual_composer_extend" )				=> "none",
                    ),
                    "description"           => __( "Select if and which additional controls should be added to the fixed player.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Show on Page Load", "ts_visual_composer_extend" ),
					"param_name"		    => "video_fixed_show",
                    "value"                 => "true",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => false,
					"description"		    => __( "Switch the toggle if you want to show the fixed player on page load or initially hide it.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed_switch", 'value' => 'toggle' ),
					"group" 				=> "Player Settings",
                ),		
				array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Fixed Width", "ts_visual_composer_extend" ),
                    "param_name"            => "video_fixed_width",
                    "value"                 => "250",
                    "min"                   => "250",
                    "max"                   => "500",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Define the width for the fixed player.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
					"group" 				=> "Player Settings",
                ),
				array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Fixed Height", "ts_visual_composer_extend" ),
                    "param_name"            => "video_fixed_height",
                    "value"                 => "140",
                    "min"                   => "100",
                    "max"                   => "500",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Define the height for the fixed player.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_fixed", 'value' => 'true' ),
					"group" 				=> "Player Settings",
                ),	
				array(
					"type"                  => "attach_image",
					"heading"               => __( "Video Poster", "ts_visual_composer_extend" ),
					"param_name"            => "video_poster",
					"value"                 => "",
					"description"           => __( "Select the image that should be used as video poster.", "ts_visual_composer_extend" ),
					"dependency"            => "",
					"group" 				=> "Player Settings",
				),				
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Poster Sizing", "ts_visual_composer_extend" ),
					"param_name"		    => "video_posterfit",
                    "value"                 => array(
                        __("Aspect-Ratio", "ts_visual_composer_extend")				=> "aspectratio",
                        __("Fill", "ts_visual_composer_extend")                  	=> "fill",
                        __("None", "ts_visual_composer_extend")                 	=> "none",
                    ),
					"description"           => __( "Select how the poster image should be sized inside the player container.", "ts_visual_composer_extend" ),
					"dependency"            => "",
					"group" 				=> "Player Settings",
				),				
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Video Title", "ts_visual_composer_extend" ),
                    "param_name"            => "video_title",
                    "value"                 => "",
                    "description"           => __( "Enter a title or name for the video.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Video Volume", "ts_visual_composer_extend" ),
                    "param_name"            => "video_volume",
                    "value"                 => "50",
                    "min"                   => "0",
                    "max"                   => "100",
                    "step"                  => "1",
                    "unit"                  => '%',
                    "description"           => __( "Select the startup volume for the media; set to 0 (Zero) to mute; desktop only (valid for first session).", "ts_visual_composer_extend" ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Video Fullscreen", "ts_visual_composer_extend" ),
					"param_name"		    => "video_fullscreen",
                    "value"                 => "true",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => true,
					"description"		    => __( "Switch the toggle if you want the media to have a fullscreen option.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Video Auto-Play", "ts_visual_composer_extend" ),
					"param_name"		    => "video_auto",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => true,
					"description"		    => __( "Switch the toggle if you want the media to start playing upon page load.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Video Auto-Stop", "ts_visual_composer_extend" ),
					"param_name"		    => "video_stop",
                    "value"                 => "true",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => true,
					"description"		    => __( "Switch the toggle if you want all other medias to stop once this one starts playing.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Video Loop", "ts_visual_composer_extend" ),
					"param_name"		    => "video_loop",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want the media to loop and start over each time it has finished.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Video Share Buttons", "ts_visual_composer_extend" ),
					"param_name"		    => "video_share",
                    "value"                 => "true",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"admin_label"           => true,
					"description"		    => __( "Switch the toggle if you want to show social share button for the media.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
				// Logo Settings
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_3",
                    "value"                 => "",
					"seperator"				=> "Logo Settings",
                    "description"           => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Show Logo", "ts_visual_composer_extend" ),
                    "param_name"            => "video_logo_show",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'No Logo', "ts_visual_composer_extend" )							=> "logonone",
                        __( 'Show Logo on Top of Video', "ts_visual_composer_extend" )			=> "logotop",
						__( 'Show Logo in Controlbar', "ts_visual_composer_extend" )			=> "logocontrol",
                    ),
                    "description"           => __( "Select if and where an additional logo should be shown.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Player Settings",
                ),
				array(
					"type"                  => "attach_image",
					"heading"               => __( "Logo Image", "ts_visual_composer_extend" ),
					"param_name"            => "video_logo_image",
					"value"                 => "",
					"description"           => __( "Select the logo image that will be shown on top of the media or in the control bar.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
					"group" 				=> "Player Settings",
				),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Logo Position", "ts_visual_composer_extend" ),
                    "param_name"            => "video_logo_position",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'Top Left', "ts_visual_composer_extend" )			=> "topleft",
						__( 'Top Right', "ts_visual_composer_extend" )			=> "topright",
                        __( 'Bottom Left', "ts_visual_composer_extend" )		=> "bottomleft",
						__( 'Bottom Right', "ts_visual_composer_extend" )		=> "bottomright",
                    ),
                    "description"           => __( "Select the position for the logo that will be shown on top of the media.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_logo_show", 'value' => 'logotop' ),
					"group" 				=> "Player Settings",
                ),
				array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Max. Logo Height", "ts_visual_composer_extend" ),
                    "param_name"            => "video_logo_height",
                    "value"                 => "50",
                    "min"                   => "25",
                    "max"                   => "200",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Define the maximum height in px for the logo that is shown on top of the media.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_logo_show", 'value' => 'logotop' ),
					"group" 				=> "Player Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Logo Opacity", "ts_visual_composer_extend" ),
                    "param_name"            => "video_logo_opacity",
                    "value"                 => "50",
                    "min"                   => "0",
                    "max"                   => "100",
                    "step"                  => "1",
                    "unit"                  => '%',
                    "description"           => __( "Define the opacity for the logo that is shown on top of the media.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
					"group" 				=> "Player Settings",
                ),
				array(
					"type" 					=> "vc_link",
					"heading" 				=> __("Logo Link + Title", "ts_visual_composer_extend"),
					"param_name" 			=> "video_logo_link",
					"description" 			=> __("Provide an optional link to another site/page for the logo.", "ts_visual_composer_extend"),
					"dependency"            => array( 'element' => "video_logo_show", 'value' => array('logotop','logocontrol') ),
					"group" 				=> "Player Settings",
				),
				// Border Settings
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_4",
                    "value"                 => "",
					"seperator"				=> "Border Settings",
                    "description"           => __( "", "ts_visual_composer_extend" ),
					"dependency"            => "",
					"group" 				=> "Player Settings",
                ),
				array(
					"type"              	=> "dropdown",
					"heading"           	=> __( "Border Type", "ts_visual_composer_extend" ),
					"param_name"        	=> "frame_border_type",
					"width"             	=> 300,
					"value"             	=> array(
						__( "None", "ts_visual_composer_extend" )                          => "none",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
					),
					"description"       	=> __( "Select the type of border around the video frame.", "ts_visual_composer_extend" ),					
					"group" 				=> "Player Settings",
				),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Border Width", "ts_visual_composer_extend" ),
                    "param_name"            => "frame_border_width",
                    "value"                 => "1",
                    "min"                   => "0",
                    "max"                   => "100",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Define the border width around the video frame.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "frame_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 				=> "Player Settings",
                ),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Border Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "frame_border_color",
					"value"             	=> "#dadada",
					"description"       	=> __( "Define the border color around the video frame.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "frame_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 				=> "Player Settings",
				),
                // Modal Settings
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_5",
                    "value"                 => "",
					"seperator"				=> "Lightbox Settings",
                    "description"           => __( "", "ts_visual_composer_extend" ),
					"dependency"            => "",
					"group" 				=> "Lightbox & Trigger Settings",
                ),
				array(
					"type"              	=> "switch_button",
					"heading"           	=> __( "Open in Lightbox", "ts_visual_composer_extend" ),
					"param_name"        	=> "content_lightbox",
					"value"             	=> "false",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"       	=> __( "Switch the toggle to show the video in a lightbox.", "ts_visual_composer_extend" ),
					"dependency"        	=> "",
					"group" 				=> "Lightbox & Trigger Settings",
				),
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Group Name", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_group_name",
                    "value"                 => "nachogroup",
                    "description"           => __( "Enter a custom group name to manually build group with other video items; leave empty for non-grouping", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_lightbox", 'value' => "true" )
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_effect",
                    "width"                 => 150,
                    "value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
                    "description"           => __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Backlight Color", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_backlight_choice",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'Predefined Color', "ts_visual_composer_extend" )	=> "predefined",
						__( 'Custom Color', "ts_visual_composer_extend" )		=> "customized",
                    ),
                    "description"           => __( "Select the (backlight) color style for the popup box.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Select Backlight Color", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_backlight_color",
                    "width"                 => 150,
                    "value"                 => array(
                        __( 'Default', "ts_visual_composer_extend" )      		=> "#0084E2",
                        __( 'Neutral', "ts_visual_composer_extend" )      		=> "#FFFFFF",
                        __( 'Success', "ts_visual_composer_extend" )      		=> "#4CFF00",
                        __( 'Warning', "ts_visual_composer_extend" )      		=> "#EA5D00",
                        __( 'Error', "ts_visual_composer_extend" )        		=> "#CC0000",
                        __( 'None', "ts_visual_composer_extend" )         		=> "#000000",
                    ),
                    "description"           => __( "Select the predefined backlight color for the modal popup.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "lightbox_backlight_choice", 'value' => 'predefined' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Select Backlight Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "lightbox_backlight_custom",
					"value"             	=> "#000000",
					"description"       	=> __( "Define a custom backlight color for the modal popup.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "lightbox_backlight_choice", 'value' => 'customized' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Show on Page Load", "ts_visual_composer_extend" ),
					"param_name"		    => "content_open",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want show the popup on page load (limit to one per page).", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Hide Popup Trigger on Page", "ts_visual_composer_extend" ),
					"param_name"		    => "content_open_hide",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want show or hide the popup trigger on the page.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_open", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Time Delay", "ts_visual_composer_extend" ),
                    "param_name"            => "content_open_delay",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "10000",
                    "step"                  => "100",
                    "unit"                  => 'ms',
                    "description"           => __( "Define the delay in ms until the modal popup should be shown (starting from 'Document Ready').", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_open", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Modal Triggger
				array(
					"type"				    => "seperator",
					"heading"			    => __( "", "ts_visual_composer_extend" ),
					"param_name"		    => "seperator_6",
                    "value"                 => "",
					"seperator"				=> "Trigger Settings",
					"description"		    => __( "", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				array(
					"type"                  => "dropdown",
					"heading"               => __( "Trigger Type", "ts_visual_composer_extend" ),
					"param_name"            => "content_trigger",
                    "value"                 => array(
						__("Poster Image", "ts_visual_composer_extend")          	=> "poster",
                        __("Default Image", "ts_visual_composer_extend")          	=> "default",
                        __("Custom Image", "ts_visual_composer_extend")           	=> "image",
                        __("Font Icon", "ts_visual_composer_extend")              	=> "icon",
                        __("Winged Button", "ts_visual_composer_extend")          	=> "winged",
                        __("Simple Button", "ts_visual_composer_extend")          	=> "simple",
						__("Flat Icon Button", "ts_visual_composer_extend")       	=> "flaticon",
						__("Flat Button", "ts_visual_composer_extend")       		=> "flat",
                        __("Text", "ts_visual_composer_extend")                   	=> "text",
                        __("Custom HTML", "ts_visual_composer_extend")            	=> "custom",
                    ),
					"description"           => __( "Select the type of trigger to click on in order to show the lightbox.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_lightbox", 'value' => 'true' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
                // Custom Image
				array(
					"type"                  => "attach_image",
					"heading"               => __( "Select Image", "ts_visual_composer_extend" ),
					"param_name"            => "content_image",
					"value"                 => "",
					"description"           => __( "Select the preview image for the modal popup.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => 'image' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Simple Image Only", "ts_visual_composer_extend" ),
					"param_name"		    => "content_image_simple",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want display just the image without any styling.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => 'image' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Auto Height Setting", "ts_visual_composer_extend" ),
                    "param_name"            => "content_image_height",
                    "width"                 => 150,
                    "value"                 => array(
                        __( '100% Height Setting', "ts_visual_composer_extend" )		=> "height: 100%;",
                        __( 'Auto Height Setting', "ts_visual_composer_extend" )     	=> "height: auto;",
                    ),
                    "description"           => __( "Select what CSS height setting should be applied to the image (change only if image height does not display correctly).", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => array('poster', 'default', 'image') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Font Icon
				array(
					'type' 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorType,
					'heading' 				=> __( 'Select Icon', 'ts_visual_composer_extend' ),
					'param_name' 			=> 'content_icon',
					'value'					=> '',
					'source'				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorValue,
					'settings' 				=> array(
						'emptyIcon' 				=> false,
						'type' 						=> 'extensions',
						'iconsPerPage' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorPager,
						'source' 					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorSource,
					),
					"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
					"dependency"            => array( 'element' => "content_trigger", 'value' => array('icon', 'flaticon') ),
					"group" 				=> "Lightbox & Trigger Settings",
				),	
				array(
					"type"                  => "nouislider",
					"heading"               => __( "Icon Size", "ts_visual_composer_extend" ),
					"param_name"            => "content_iconsize",
					"value"                 => "30",
					"min"                   => "16",
					"max"                   => "512",
					"step"                  => "1",
					"unit"                  => 'px',
					"description"           => __( "Select the icon size", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => 'icon' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				array(
					"type"                  => "colorpicker",
					"heading"               => __( "Icon Color", "ts_visual_composer_extend" ),
					"param_name"            => "content_iconcolor",
					"value"                 => "#cccccc",
					"description"           => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => 'icon' ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				// Flat Button
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Button Color Style", "ts_visual_composer_extend" ),
                    "param_name"            => "content_buttonstyle",
                    "width"                 => 300,
					"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
                    "description"           => __( "Select the general color style for button.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Button Hover Style", "ts_visual_composer_extend" ),
                    "param_name"            => "content_buttonhover",
                    "width"                 => 300,
					"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
                    "description"           => __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Button
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Button Text", "ts_visual_composer_extend" ),
                    "param_name"            => "content_buttontext",
                    "value"                 => "View Video",
                    "description"           => __( "Enter the text for the button.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => array('winged', 'simple', 'flat', 'flaticon') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Button Text Size", "ts_visual_composer_extend" ),
                    "param_name"            => "content_buttonsize",
                    "value"                 => "16",
                    "min"                   => "12",
                    "max"                   => "20",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_trigger", 'value' => array('flat', 'flaticon') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Text Link
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Trigger Text", "ts_visual_composer_extend" ),
                    "param_name"            => "content_text",
                    "value"                 => "",
                    "description"           => __( "Enter the trigger text for the modal popup.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => 'text' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Custom Code
                array(
                    "type"                  => "textarea_raw_html",
                    "heading"               => __("Raw HTML", "ts_visual_composer_extend"),
                    "param_name"            => "content_raw",
                    "value"                 => base64_encode(""),
                    "description"           => __("Enter your custom HTML code; code will be wrapped in appropriate link automatically.", "ts_visual_composer_extend"),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => 'custom' ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Subtitle
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Subtitle", "ts_visual_composer_extend" ),
                    "param_name"            => "content_subtitle",
                    "value"                 => "",
                    "description"           => __( "Enter a subtitle for video trigger.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "content_trigger", 'value' => array('winged') ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
                // Tooltip Settings
				array(
					"type"				    => "seperator",
					"heading"			    => __( "", "ts_visual_composer_extend" ),
					"param_name"		    => "seperator_7",
					"value"					=> "",
					"seperator"				=> "Trigger Tooltip",
					"description"		    => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
                array(
                    "type"                  => "switch_button",
					"heading"			    => __( "Use Advanced Tooltip", "ts_visual_composer_extend" ),
					"param_name"		    => "content_tooltip_css",
                    "value"                 => "false",
                    "on"				    => __( 'Yes', "ts_visual_composer_extend" ),
                    "off"				    => __( 'No', "ts_visual_composer_extend" ),
                    "style"				    => "select",
                    "design"			    => "toggle-light",
					"description"		    => __( "Switch the toggle if you want to apply am advanced tooltip to the image.", "ts_visual_composer_extend" ),
					"group" 				=> "Lightbox & Trigger Settings",
                ),
				array(
					"type"				    => "textarea",
					"class"				    => "",
					"heading"			    => __( "Tooltip Content", "ts_visual_composer_extend" ),
					"param_name"		    => "content_tooltip_content",
					"value"				    => "",
					"description"		    => __( "Enter the tooltip content here (do not use quotation marks or HTML code).", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_tooltip_css", 'value' => "false" ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				array(
					"type"              	=> "textarea_raw_html",
					"heading"           	=> __( "Tooltip Content", "ts_visual_composer_extend" ),
					"param_name"        	=> "content_tooltip_encoded",
					"value"             	=> base64_encode(""),
					"description"      	 	=> __( "Enter the tooltip content here (HTML code can be used).", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_tooltip_css", 'value' => "true" ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
					"param_name"		    => "content_tooltip_position",
                    "value"                 => array(
                        __("Top", "ts_visual_composer_extend")                    => "ts-simptip-position-top",
                        __("Bottom", "ts_visual_composer_extend")                 => "ts-simptip-position-bottom",
                    ),
					"description"		    => __( "Select the tooltip position in relation to the image.", "ts_visual_composer_extend" ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Tooltip Style", "ts_visual_composer_extend" ),
					"param_name"		    => "content_tooltip_style",
                    "value"                 => array(
                        __("Black", "ts_visual_composer_extend")                  => "",
                        __("Gray", "ts_visual_composer_extend")                   => "ts-simptip-style-gray",
                        __("Green", "ts_visual_composer_extend")                  => "ts-simptip-style-green",
                        __("Blue", "ts_visual_composer_extend")                   => "ts-simptip-style-blue",
                        __("Red", "ts_visual_composer_extend")                    => "ts-simptip-style-red",
                        __("Orange", "ts_visual_composer_extend")                 => "ts-simptip-style-orange",
                        __("Yellow", "ts_visual_composer_extend")                 => "ts-simptip-style-yellow",
                        __("Purple", "ts_visual_composer_extend")                 => "ts-simptip-style-purple",
                        __("Pink", "ts_visual_composer_extend")                   => "ts-simptip-style-pink",
                        __("White", "ts_visual_composer_extend")                  => "ts-simptip-style-white"
                    ),
					"description"		    => __( "Select the tooltip style.", "ts_visual_composer_extend" ),
					"group" 				=> "Lightbox & Trigger Settings",
				),
				// Other Settings
				array(
					"type"				    => "seperator",
					"heading"			    => __( "", "ts_visual_composer_extend" ),
					"param_name"		    => "seperator_8",
					"value"					=> "",
					"seperator"				=> "Other Settings",
					"description"		    => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
                    "param_name"            => "margin_top",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "200",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
                    "param_name"            => "margin_bottom",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "200",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
                ),
				array(
					"type"                  => "textfield",
					"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"            => "el_id",
					"value"                 => "",
					"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"                  => "textfield",
					"heading"               => __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"            => "el_class",
					"value"                 => "",
					"description"           => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				// Load Custom CSS/JS File
				array(
					"type"                  => "load_file",
					"heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "el_file",
					"value"                 => "",
					"file_type"             => "js",
					"file_path"             => "js/ts-visual-composer-extend-element.min.js",
					"description"           => __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>