<?php
	global $VISUAL_COMPOSER_EXTENSIONS;
	if (function_exists('vc_map')) {
		vc_map( array(
			"name"                      => __( "TS Icon Box", "ts_visual_composer_extend" ),
			"base"                      => "TS-VCSC-Icon-Box-Tiny",
			"icon" 	                    => "icon-wpb-ts_vcsc_icon_box",
			"class"                     => "",
			"category"                  => __("VC Extensions", "ts_visual_composer_extend"),
			"description" 		    	=> __("Place an icon or image box", "ts_visual_composer_extend"),
			"js_view"     				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorLivePreview == "true" ? "TS_VCSC_IconBoxViewCustom" : ""),
            "admin_enqueue_js"			=> "",
            "admin_enqueue_css"			=> "",			
			"params"                    => array(
				// Icon Box Design
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_1",
					"value"				=> "",
					"seperator"			=> "Box Design",
					"description"       => __( "", "ts_visual_composer_extend" )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon Box Style", "ts_visual_composer_extend" ),
					"param_name"        => "style",
					"width"             => 300,
					"value"             => array(
						__( 'Icon Inside - Left', "ts_visual_composer_extend" )       	=> "icon_left",
						__( 'Icon Inside - Top', "ts_visual_composer_extend" )        	=> "icon_top",
						__( 'Icon Outside - Left', "ts_visual_composer_extend" )      	=> "boxed_left",
						__( 'Icon Outside - Top', "ts_visual_composer_extend" )       	=> "boxed_top",
					),
					"admin_label"		=> true,
					"description"       => __( "Select the general layout of your icon box.", "ts_visual_composer_extend" )
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon Position", "ts_visual_composer_extend" ),
					"param_name"        => "icon_placement",
					"width"             => 300,
					"value"             => array(
						__( 'Center', "ts_visual_composer_extend" )       			=> "center",
						__( 'Top', "ts_visual_composer_extend" )        			=> "top",
						__( 'Bottom', "ts_visual_composer_extend" )      			=> "bottom",
					),
					"description"       => __( "Select where the icon should be positioned in relation to the content text.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => 'boxed_left' )
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Box Background Style", "ts_visual_composer_extend" ),
					"param_name"        => "box_background_type",
					"width"             => 300,
					"value"             => array(
						__( "Solid Color", "ts_visual_composer_extend" )				=> "color",
						__( "Background Pattern", "ts_visual_composer_extend" )			=> "pattern",
						__( "Custom Image", "ts_visual_composer_extend" )				=> "image",
					),
					"description"       => __( "Select the background type for your icon box.", "ts_visual_composer_extend" )
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Box Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "box_background_color",
					"value"             => "#ffffff",
					"description"       => __( "Select the background color for your icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_background_type", 'value' => 'color' )
				),
				array(
					"type"              => "background",
					"heading"           => __( "Box Background Pattern", "ts_visual_composer_extend" ),
					"param_name"        => "box_background_pattern",
					"height"            => 200,
					"pattern"           => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Background_List,
					"value"				=> "",
					"encoding"          => "false",
					"empty"				=> "true",
					"description"       => __( "Select the background pattern for your icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_background_type", 'value' => 'pattern' )
				),
				array(
					"type"              => "attach_image",
					"heading"           => __( "Select Image", "ts_visual_composer_extend" ),
					"param_name"        => "box_background_image",
					"value"             => "false",
					"description"       => __( "Select an image or pattern to be used as background for the icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_background_type", 'value' => 'image' )
				),		
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Background Size", "ts_visual_composer_extend" ),
                    "param_name"		=> "box_background_size",
                    "width"				=> 150,
					"value"				=> array(
						__( "Cover", "ts_visual_composer_extend" ) 			=> "cover",
						__( "150%", "ts_visual_composer_extend" )			=> "150%",
						__( "200%", "ts_visual_composer_extend" )			=> "200%",
						__( "Contain", "ts_visual_composer_extend" ) 		=> "contain",
						__( "Initial", "ts_visual_composer_extend" ) 		=> "initial",
						__( "Auto", "ts_visual_composer_extend" ) 			=> "auto",
					),
                    "description"		=> __( "Select how the custom background image should be sized.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "box_background_type", 'value' => 'image' )
                ),
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Background Repeat", "ts_visual_composer_extend" ),
                    "param_name"		=> "box_background_repeat",
                    "width"				=> 150,
					"value"				=> array(
						__( "No Repeat", "ts_visual_composer_extend" )		=> "no-repeat",
						__( "Repeat X + Y", "ts_visual_composer_extend" )	=> "repeat",
						__( "Repeat X", "ts_visual_composer_extend" )		=> "repeat-x",
						__( "Repeat Y", "ts_visual_composer_extend" )		=> "repeat-y"
					),
                    "description"		=> __( "Select if and how the background image should be repeated.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "box_background_type", 'value' => 'image' )
                ),
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Height Setting", "ts_visual_composer_extend" ),
                    "param_name"		=> "height",
                    "width"				=> 150,
					"value"				=> array(
						__( "Auto Height", "ts_visual_composer_extend" )		=> "auto",
						__( "Minimum Height", "ts_visual_composer_extend" )		=> "minheight",
						__( "Maximum Height", "ts_visual_composer_extend" )		=> "maxheight",
						__( "Fixed Height", "ts_visual_composer_extend" )		=> "fixheight",
					),
                    "description"		=> __( "Select how the inner height for the icon box should be set.", "ts_visual_composer_extend" ),
                ),		
				array(
					"type"              => "nouislider",
					"heading"           => __( "Minimum Height", "ts_visual_composer_extend" ),
					"param_name"        => "min_height",
					"value"             => "200",
					"min"               => "50",
					"max"               => "1024",
					"step"              => "1",
					"unit"              => 'px',
					"dependency"        => array( 'element' => "height", 'value' => 'minheight' ),
					"description"       => __( "Define the inner internal minimum height of the icon box (including any paddings).", "ts_visual_composer_extend" ),
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Maximum Height", "ts_visual_composer_extend" ),
					"param_name"        => "max_height",
					"value"             => "200",
					"min"               => "50",
					"max"               => "1024",
					"step"              => "1",
					"unit"              => 'px',
					"dependency"        => array( 'element' => "height", 'value' => 'maxheight' ),
					"description"       => __( "Define the inner internal maximum height of the icon box (including any paddings); might cause overflow scrollbars.", "ts_visual_composer_extend" ),
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Fixed Height", "ts_visual_composer_extend" ),
					"param_name"        => "fix_height",
					"value"             => "200",
					"min"               => "50",
					"max"               => "1024",
					"step"              => "1",
					"unit"              => 'px',
					"dependency"        => array( 'element' => "height", 'value' => 'fixheight' ),
					"description"       => __( "Define the inner internal fixed height of the icon box (including any paddings); might cause overflow scrollbars.", "ts_visual_composer_extend" ),
				),	
				// Padding Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_2",
					"value"				=> "",
					"seperator"			=> "Internal Padding",
					"description"       => __( "", "ts_visual_composer_extend" ),
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Padding: Top", "ts_visual_composer_extend" ),
					"param_name"        => "padding_top",
					"value"             => "10",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the inner top padding for the icon box content.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('icon_left', 'icon_top') )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Padding: Bottom", "ts_visual_composer_extend" ),
					"param_name"        => "padding_bottom",
					"value"             => "10",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the inner bottom padding for the icon box content.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('icon_left', 'icon_top') )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Padding: Left", "ts_visual_composer_extend" ),
					"param_name"        => "padding_left",
					"value"             => "10",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the inner left padding for the icon box content.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('icon_left', 'icon_top') )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Padding: Right", "ts_visual_composer_extend" ),
					"param_name"        => "padding_right",
					"value"             => "10",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the inner right padding for the icon box content.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('icon_left', 'icon_top') )
				),				
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Use Custom Spacing", "ts_visual_composer_extend" ),
					"param_name"        => "padding_custom",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to apply a custom spacing between the icon and box content.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "style", 'value' => array('boxed_left', 'boxed_top') )
				),				
				array(
					"type"              => "nouislider",
					"heading"           => __( "Padding: Icon to Content", "ts_visual_composer_extend" ),
					"param_name"        => "padding_outside",
					"value"             => "60",
					"min"               => "0",
					"max"               => "100",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the inner padding for the icon box side that shows the icon.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "padding_custom", 'value' => 'true' )
				),				
				// Box Title Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_3",
					"value"				=> "",
					"seperator"			=> "Box Title",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Title", "ts_visual_composer_extend" ),
					"param_name"        => "title",
					"value"             => "",
					"description"       => __( "Enter the title for your icon box.", "ts_visual_composer_extend" ),
					"admin_label"		=> true,
					"group" 			=> "Box Content",
				),			
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Title Wrap", "ts_visual_composer_extend" ),
                    "param_name"		=> "title_wrap",
                    "width"				=> 150,
					"value"				=> array(
						__( "Standard DIV", "ts_visual_composer_extend" )		=> "div",
						__( "H1", "ts_visual_composer_extend" )					=> "h1",
						__( "H2", "ts_visual_composer_extend" )					=> "h2",
						__( "H3", "ts_visual_composer_extend" )					=> "h3",
						__( "H4", "ts_visual_composer_extend" )					=> "h4",
						__( "H5", "ts_visual_composer_extend" )					=> "h5",
						__( "H6", "ts_visual_composer_extend" )					=> "h6",
					),
                    "description"		=> __( "Select in which DOM element type the title should be wrapped in; specific theme styling might apply.", "ts_visual_composer_extend" ),
                    "group" 			=> "Box Content",
                ),	
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Font Family", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_title_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_title_type",
                    "description"		=> __( "Select the font to be used for the title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_title_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
                ),				
				array(
					"type"              => "nouislider",
					"heading"           => __( "Title Font Size", "ts_visual_composer_extend" ),
					"param_name"        => "title_size",
					"value"             => "24",
					"min"               => "10",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the title size for your icon box.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Title Font Weight", "ts_visual_composer_extend" ),
					"param_name"        => "title_weight",
					"width"             => 200,
					"value"             => array(
						__( 'Default', "ts_visual_composer_extend" )      => "inherit",
						__( 'Bold', "ts_visual_composer_extend" )         => "bold",
						__( 'Bolder', "ts_visual_composer_extend" )       => "bolder",
						__( 'Normal', "ts_visual_composer_extend" )       => "normal",
						__( 'Light', "ts_visual_composer_extend" )        => "300",
					),
					"description"       => __( "Select the title weight for your icon box.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Title Color", "ts_visual_composer_extend" ),
					"param_name"        => "title_color",
					"value"             => "#000000",
					"description"       => __( "Select the title color for your icon box.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Title Text Align", "ts_visual_composer_extend" ),
					"param_name"        => "title_align",
					"width"             => 150,
					"value"             => array(
						__( "Center", "ts_visual_composer_extend" )                        	=> "center",
						__( "Left", "ts_visual_composer_extend" )                          	=> "left",
						__( "Right", "ts_visual_composer_extend" )                         	=> "right",
						__( "Justify", "ts_visual_composer_extend" )                        => "justify",
					),
					"description"       => __( "Select the title alignment for your icon box.", "ts_visual_composer_extend" ),
					//"dependency"      => array( 'element' => "style", 'value' => array( 'boxed_top', 'boxed_left', 'icon_top' ) ),
					"dependency"		=> "",
					"group" 			=> "Box Content",
				),
				// Box Content Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_4",
					"value"				=> "",
					"seperator"			=> "Box Content",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
                array(
                    "type"				=> "textarea_html",
                    "class"				=> "",
                    "heading"			=> __( "Box Content", "ts_visual_composer_extend" ),
                    "param_name"		=> "content",
                    "value"				=> "This is some icon box content. Click to change.",
                    "description"		=> __( "Create the content for the icon box element.", "ts_visual_composer_extend" ),
                    "dependency"		=> "",
					"group" 			=> "Box Content",
                ),
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Font Family", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_content_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_content_type",
                    "description"		=> __( "Select the font to be used for the content text.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_content_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
                ),	
				array(
					"type"              => "nouislider",
					"heading"           => __( "Font Size", "ts_visual_composer_extend" ),
					"param_name"        => "font_size",
					"value"             => "14",
					"min"               => "10",
					"max"               => "60",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the general font size for the icon box content.", "ts_visual_composer_extend" ),
                    "dependency"		=> "",
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Line Height", "ts_visual_composer_extend" ),
					"param_name"        => "line_height",
					"value"             => "14",
					"min"               => "10",
					"max"               => "60",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the general line height for the icon box content.", "ts_visual_composer_extend" ),
                    "dependency"		=> "",
					"group" 			=> "Box Content",
				),
				// Read More Button Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_5",
					"value"				=> "",
					"seperator"			=> "Read More Link",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Add Link", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_link",
					"width"             => 300,
					"value"             => array(
						__( 'None', "ts_visual_composer_extend" )             		=> "false",
						__( 'Link Button', "ts_visual_composer_extend" )      		=> "button",
						__( 'Link Button + Title', "ts_visual_composer_extend" )	=> "buttontitle",
						__( 'Title Only', "ts_visual_composer_extend" )      		=> "title",
						__( 'Link Entire Box', "ts_visual_composer_extend" )  		=> "box",
					),
					"description"       => __( "Select the type of link to be applied to the icon box.", "ts_visual_composer_extend" ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "textfield",
					"heading"           => __( "Read More Button Text", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_txt",
					"value"             => "",
					"description"       => __( "Enter the text to be shown in the link button.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group" 			=> "Box Content",
				),				
                array(
                    "type"				=> "fontsmanager",
                    "heading"			=> __( "Button Text Font", "ts_visual_composer_extend" ),
                    "param_name"		=> "font_button_family",
                    "value"				=> "",
					"default"			=> "true",
					"connector"			=> "font_button_type",
                    "description"		=> __( "Select the font to be used for the link button text.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group"				=> "Box Content",
                ),
                array(
                    "type"				=> "hidden_input",
                    "param_name"		=> "font_button_type",
                    "value"				=> "",
                    "description"		=> __( "", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group"				=> "Box Content",
                ),				
				array(
					"type"              => "textfield",
					"heading"           => __( "Read More URL", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_url",
					"value"             => "",
					"description"       => __( "Enter the URL for the link (starting with http://).", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'box', 'buttontitle', 'title') ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Link Target", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_target",
					"value"             => array(
						__( "Same Window", "ts_visual_composer_extend" )                    => "_parent",
						__( "New Window", "ts_visual_composer_extend" )                     => "_blank"
					),
					"description"       => __( "Define how the link should be opened.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_url", 'not_empty' => true ),
					"group" 			=> "Box Content",
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Button Design", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_type",
					"width"             => 300,
					"value"             => array(
						__( 'Basic Styles', "ts_visual_composer_extend" )          			=> "basic",
						__( 'Flat Button Styles', "ts_visual_composer_extend" )          	=> "flat",
					),
					"description"       => __( "Select the general button style for the link.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group" 			=> "Box Content",
				),				
				array(
					"type"              => "dropdown",
					"heading"           => __( "Button Style", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_style",
					"width"             => 300,
					"value"             => array(
						__( 'Style 1', "ts_visual_composer_extend" )          => "1",
						__( 'Style 2', "ts_visual_composer_extend" )          => "2",
						__( 'Style 3', "ts_visual_composer_extend" )          => "3",
						__( 'Style 4', "ts_visual_composer_extend" )          => "4",
						__( 'Style 5', "ts_visual_composer_extend" )          => "5"
					),
					"description"       => __( "Select the button style for the link.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_type", 'value' => 'basic' ),
					"group" 			=> "Box Content",
				),
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Button Color Style", "ts_visual_composer_extend" ),
                    "param_name"		=> "read_more_flat_default",
                    "width"				=> 300,
					"value"				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
                    "description"		=> __( "Select the general color style for button.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_type", 'value' => 'flat' ),
					"group" 			=> "Box Content",
                ),
                array(
                    "type"				=> "dropdown",
                    "heading"			=> __( "Button Hover Style", "ts_visual_composer_extend" ),
                    "param_name"		=> "read_more_flat_hover",
                    "width"				=> 300,
					"value"				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
                    "description"		=> __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_type", 'value' => 'flat' ),
					"group" 			=> "Box Content",
                ),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Button Align", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_align",
					"width"             => 150,
					"value"             => array(
						__( "Center", "ts_visual_composer_extend" )                        	=> "center",
						__( "Left", "ts_visual_composer_extend" )                          	=> "left",
						__( "Right", "ts_visual_composer_extend" )                         	=> "right",
					),
					"description"       => __( "Select the title alignment for your icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group" 			=> "Box Content",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Button Width", "ts_visual_composer_extend" ),
					"param_name"        => "read_more_width",
					"value"             => "50",
					"min"               => "0",
					"max"               => "100",
					"step"              => "1",
					"unit"              => '%',
					"description"       => __( "Define the width of the button.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "read_more_link", 'value' => array('button', 'buttontitle') ),
					"group" 			=> "Box Content",
				),
				// Box Icon Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_6",
					"value"				=> "",
					"seperator"			=> "Box Icon / Image",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Use Normal Image", "ts_visual_composer_extend" ),
					"param_name"        => "icon_replace",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to either use and icon or a normal image.", "ts_visual_composer_extend" ),
                    "dependency"		=> "",
					"group" 			=> "Icon Settings",
				),		
				array(
					'type' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorType,
					'heading' 			=> __( 'Select Icon', 'ts_visual_composer_extend' ),
					'param_name' 		=> 'icon',
					'value'				=> '',
					'source'			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorValue,
					'settings' 			=> array(
						'emptyIcon' 			=> true,
						'type' 					=> 'extensions',
						'iconsPerPage' 			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorPager,
						'source' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorSource,
					),
					"admin_label"       => true,
					"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon for your icon box.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
					"dependency"        => array( 'element' => "icon_replace", 'value' => 'false' ),
					"group" 			=> "Icon Settings",
				),	
				array(
					"type"              => "attach_image",
					"heading"           => __( "Select Image", "ts_visual_composer_extend" ),
					"param_name"        => "icon_image",
					"value"             => "false",
					"description"       => __( "Image must have equal dimensions for scaling purposes (i.e. 100x100).", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_replace", 'value' => 'true' ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon Color", "ts_visual_composer_extend" ),
					"param_name"        => "icon_color",
					"value"             => "#000000",
					"description"       => __( "Select the color of the icon for your icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_replace", 'value' => 'false' ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon / Image Background Color", "ts_visual_composer_extend" ),
					"param_name"        => "icon_background",
					"value"             => "",
					"description"       => __( "Select the background color of the icon or transparent image.", "ts_visual_composer_extend" ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image Size", "ts_visual_composer_extend" ),
					"param_name"        => "icon_size_slide",
					"value"             => "36",
					"min"               => "16",
					"max"               => "512",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the size of the icon.", "ts_visual_composer_extend" ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image to Text Spacing", "ts_visual_composer_extend" ),
					"param_name"        => "icon_margin",
					"value"             => "10",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define the space between the icon / image and the icon box content.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "style", 'value' => array('icon_left', 'icon_top') ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon / Image Border Type", "ts_visual_composer_extend" ),
					"param_name"        => "icon_frame_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
					"description"       => __( "Select the border type for the icon or image.", "ts_visual_composer_extend" ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "icon_frame_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "20",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the thickness for the icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Icon / Image Frame Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "icon_frame_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
						__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
					),
					"description"       => __( "Select the radius for your icon / image border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Icon / Image Frame Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "icon_frame_color",
					"value"             => "#000000",
					"description"       => __( "Select the color for your icon border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Icon Settings",
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Icon / Image Padding", "ts_visual_composer_extend" ),
					"param_name"        => "icon_padding",
					"value"             => "5",
					"min"               => "0",
					"max"               => "50",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Define a padding for your icon / image.", "ts_visual_composer_extend" ),
					"group" 			=> "Icon Settings",
				),
				// Separator Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_7",
					"value"				=> "",
					"seperator"			=> "Separator Line",
					"description"       => __( "", "ts_visual_composer_extend" ),
					"dependency"      	=> array( 'element' => "style", 'value' => array( 'boxed_top', 'boxed_left' ) ),
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Separator Style", "ts_visual_composer_extend" ),
					"param_name"        => "separator_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          	=> "",
						__( "Solid Line", "ts_visual_composer_extend" )                  	=> "solid",
						__( "Dotted Line", "ts_visual_composer_extend" )                 	=> "dotted",
						__( "Dashed Line", "ts_visual_composer_extend" )                 	=> "dashed",
						__( "Double Line", "ts_visual_composer_extend" )                 	=> "double",
						__( "Grouve Line", "ts_visual_composer_extend" )                 	=> "groove",
						__( "Ridge Line", "ts_visual_composer_extend" )                  	=> "ridge",
						__( "Inset Line", "ts_visual_composer_extend" )                  	=> "inset",
						__( "Outset Line", "ts_visual_composer_extend" )                 	=> "outset"
					),
					"description"       => __( "Select an optional separator line type between icon and content.", "ts_visual_composer_extend" ),
					"dependency"      	=> array( 'element' => "style", 'value' => array( 'boxed_top', 'boxed_left' ) ),
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Separator Color", "ts_visual_composer_extend" ),
					"param_name"        => "separator_color",
					"value"             => "#000000",
					"description"       => __( "Select the color for the separator line.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "separator_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Separator Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "separator_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "20",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the thickness for the separator line.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "separator_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
				),
				// Box Border Settings
				array(
					"type"              => "seperator",
					"heading"           => __( "", "ts_visual_composer_extend" ),
					"param_name"        => "seperator_8",
					"value"				=> "",
					"seperator"			=> "Box Border",
					"description"       => __( "", "ts_visual_composer_extend" ),
				),
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Advanced Border Settings", "ts_visual_composer_extend" ),
					"param_name"        => "box_border_controls",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to either use the basic or advanced border setting controls.", "ts_visual_composer_extend" ),
                    "dependency"		=> "",
				),	
				array(
					"type"              => "dropdown",
					"heading"           => __( "Box Border Style", "ts_visual_composer_extend" ),
					"param_name"        => "box_border_type",
					"width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
					"description"       => __( "Select the border type for the icon box.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_border_controls", 'value' => 'false' )
				),
				array(
					"type"              => "colorpicker",
					"heading"           => __( "Box Border Color", "ts_visual_composer_extend" ),
					"param_name"        => "box_border_color",
					"value"             => "#000000",
					"description"       => __( "Select the color for the icon box border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
				),
				array(
					"type"              => "nouislider",
					"heading"           => __( "Box Border Thickness", "ts_visual_composer_extend" ),
					"param_name"        => "box_border_thick",
					"value"             => "1",
					"min"               => "1",
					"max"               => "20",
					"step"              => "1",
					"unit"              => 'px',
					"description"       => __( "Select the thickness for the icon box border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
				),
				array(
					"type"              => "dropdown",
					"heading"           => __( "Box Frame Border Radius", "ts_visual_composer_extend" ),
					"param_name"        => "box_border_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
					),
					"description"       => __( "Select the radius for the icon box border.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "box_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
				),				
				array(
					"type" 					=> "advanced_styling",
					"heading" 				=> __("Box Border Settings", "ts_visual_composer_extend"),
					"param_name" 			=> "box_border_setting",
					"style_type"			=> "border",
					"show_main"				=> "false",
					"show_preview"			=> "true",
					"show_width"			=> "true",
					"show_style"			=> "true",
					"show_radius" 			=> "true",					
					"show_color"			=> "true",
					"show_unit_width"		=> "true",
					"show_unit_radius"		=> "true",			
					"default_positions"		=> array(
						//__("All", "ts_visual_composer_extend")     		=> array("width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Top", "ts_visual_composer_extend")     			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Right", "ts_visual_composer_extend")   			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Bottom", "ts_visual_composer_extend")  			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Left", "ts_visual_composer_extend")    			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					),
					"description"       	=> __( "Define the border settings for each side and corner of the element.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "box_border_controls", 'value' => 'true' )
				),				
				// Tooltip Settings
				array(
					"type"              	=> "seperator",
					"heading"           	=> __( "", "ts_visual_composer_extend" ),
					"param_name"        	=> "seperator_9",
					"value"					=> "",
					"seperator"            	=> "Tooltip Settings",
					"description"       	=> __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Tooltip Settings",
				),
				array(
					"type"              	=> "textarea_raw_html",
					"heading"           	=> __( "Tooltip Content", "ts_visual_composer_extend" ),
					"param_name"        	=> "tooltip_content",
					"value"             	=> base64_encode(""),
					"description"      	 	=> __( "Enter the tooltip content for the element; basic HTML code can be used.", "ts_visual_composer_extend" ),
					"group" 				=> "Tooltip Settings",
				),
				array(
					"type"					=> "dropdown",
					"class"					=> "",
					"heading"				=> __( "Tooltip Position", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltip_position",
					"value"					=> array(
						__( "Top", "ts_visual_composer_extend" )                            => "ts-simptip-position-top",
						__( "Bottom", "ts_visual_composer_extend" )                         => "ts-simptip-position-bottom",
					),
					"description"			=> __( "Select the tooltip position in relation to the element.", "ts_visual_composer_extend" ),
					"dependency"			=> "",
					"group" 				=> "Tooltip Settings",
				),							
				array(
					"type"					=> "dropdown",
					"class"					=> "",
					"heading"				=> __( "Tooltip Style", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltip_style",
					"value"             	=> array(
						__( "Black", "ts_visual_composer_extend" )                          => "",
						__( "Gray", "ts_visual_composer_extend" )                           => "ts-simptip-style-gray",
						__( "Green", "ts_visual_composer_extend" )                          => "ts-simptip-style-green",
						__( "Blue", "ts_visual_composer_extend" )                           => "ts-simptip-style-blue",
						__( "Red", "ts_visual_composer_extend" )                            => "ts-simptip-style-red",
						__( "Orange", "ts_visual_composer_extend" )                         => "ts-simptip-style-orange",
						__( "Yellow", "ts_visual_composer_extend" )                         => "ts-simptip-style-yellow",
						__( "Purple", "ts_visual_composer_extend" )                         => "ts-simptip-style-purple",
						__( "Pink", "ts_visual_composer_extend" )                           => "ts-simptip-style-pink",
						__( "White", "ts_visual_composer_extend" )                          => "ts-simptip-style-white"
					),
					"description"			=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
					"dependency"			=> array( 'element' => "tooltip_css", 'value' => 'true' ),
					"group" 				=> "Tooltip Settings",
				),
				array(
					"type"					=> "nouislider",
					"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltipster_offsetx",
					"value"					=> "0",
					"min"					=> "-100",
					"max"					=> "100",
					"step"					=> "1",
					"unit"					=> 'px',
					"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
					"group" 				=> "Tooltip Settings",
				),
				array(
					"type"					=> "nouislider",
					"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltipster_offsety",
					"value"					=> "0",
					"min"					=> "-100",
					"max"					=> "100",
					"step"					=> "1",
					"unit"					=> 'px',
					"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
					"group" 				=> "Tooltip Settings",
				),
				// Animation Settings
				array(
					"type"              	=> "seperator",
					"heading"           	=> __( "", "ts_visual_composer_extend" ),
					"param_name"        	=> "seperator_10",
					"value"					=> "",
					"seperator"				=> "Animations",
					"description"       	=> __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"					=> "switch_button",
					"heading"           	=> __( "Add Animations / Shadow", "ts_visual_composer_extend" ),
					"param_name"        	=> "animations",
					"value"             	=> "false",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"       	=> __( "Switch the toggle if you want to apply animations or a shadow to the icon box.", "ts_visual_composer_extend" ),
                    "dependency"			=> "",
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "dropdown",
					"heading"           	=> __( "Icon / Image Animation Style", "ts_visual_composer_extend" ),
					"param_name"        	=> "animation_effect",
					"width"             	=> 150,
					"value"             	=> array(
						__( "One Time Effect while Hover", "ts_visual_composer_extend" )    			=> "ts-hover-css-",
						__( "Infinite (Looping) Effect", "ts_visual_composer_extend" )                	=> "ts-infinite-css-",
					),
					"description"       	=> __( "Select the animation style for the icon / image.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"					=> "css3animations",
					"class"					=> "",
					"heading"				=> __("Icon / Image Animation", "ts_visual_composer_extend"),
					"param_name"			=> "animation_class",
					"standard"				=> "false",
					"prefix"				=> "",
					"connector"				=> "css3animations_in",
					"noneselect"			=> "true",
					"default"				=> "",
					"value"					=> "",
					"admin_label"			=> false,
					"description"			=> __("Select the animation for the icon / image.", "ts_visual_composer_extend"),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"					=> "hidden_input",
					"heading"				=> __( "Icon / Image Animation", "ts_visual_composer_extend" ),
					"param_name"			=> "css3animations_in",
					"value"					=> "",
					"admin_label"			=> true,
					"description"			=> __( "", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "dropdown",
					"heading"           	=> __( "Box Hover Effect", "ts_visual_composer_extend" ),
					"param_name"        	=> "animation_box",
					"width"             	=> 300,
					"value"            	 	=> array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Tilt Up", "ts_visual_composer_extend" )                       => "ts-css-effect1",
						__( "Tilt Left", "ts_visual_composer_extend" )                     => "ts-css-effect2",
						__( "Tilt Right", "ts_visual_composer_extend" )                    => "ts-css-effect3",
						__( "Tilt Left (Up)", "ts_visual_composer_extend" )                => "ts-css-effect4",
						__( "Tilt Right (Down)", "ts_visual_composer_extend" )             => "ts-css-effect5",
						__( "Grow Out", "ts_visual_composer_extend" )                      => "ts-css-effect6",
					),
					"description"       	=> __( "Select the hover animation for the icon box.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "dropdown",
					"heading"           	=> __( "Box Shadow Effect", "ts_visual_composer_extend" ),
					"param_name"        	=> "animation_shadow",
					"width"             	=> 300,
					"value"             	=> array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Lifted", "ts_visual_composer_extend" )                        => "lifted",
						__( "Raised", "ts_visual_composer_extend" )                        => "raised",
						__( "Perspective - Right", "ts_visual_composer_extend" )           => "perspective-right",
						__( "Perspective - Left", "ts_visual_composer_extend" )            => "perspective-left",
						__( "Curved - Horizontal", "ts_visual_composer_extend" )           => "curved",
						__( "Curved - Horizontal (Top)", "ts_visual_composer_extend" )     => "curved-top",
						__( "Curved - Horizontal (Bottom)", "ts_visual_composer_extend" )  => "curved-bottom",
						__( "Curved - Vertical", "ts_visual_composer_extend" )             => "curved-vertical",
						__( "Curved - Vertical (Left)", "ts_visual_composer_extend" )      => "curved-vertical-left",
						__( "Curved - Vertical (Right)", "ts_visual_composer_extend" )     => "curved-vertical-right",
					),
					"description"       	=> __( "Select the shadow effect for the icon box.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "dropdown",
					"heading"           	=> __( "Viewport Animation", "ts_visual_composer_extend" ),
					"param_name"        	=> "animation_view",
					"value"             	=>  array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Top to Bottom", "ts_visual_composer_extend" )                 => "top-to-bottom",
						__( "Bottom to Top", "ts_visual_composer_extend" )                 => "bottom-to-top",
						__( "Left to Right", "ts_visual_composer_extend" )                 => "left-to-right",
						__( "Right to Left", "ts_visual_composer_extend" )                 => "right-to-left",
						__( "Appear from Center", "ts_visual_composer_extend" )            => "appear",
					),
					"description"       	=> __( "Select the viewport animation for the icon box.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "animations", 'value' => 'true' ),
					"group" 				=> "Other Settings",
				),
				// Other Icon Box Settings
				array(
					"type"              	=> "seperator",
					"heading"           	=> __( "", "ts_visual_composer_extend" ),
					"param_name"        	=> "seperator_11",
					"value"					=> "",
					"seperator"             => "Other Box Settings",
					"description"       	=> __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "nouislider",
					"heading"           	=> __( "Margin: Top", "ts_visual_composer_extend" ),
					"param_name"        	=> "margin_top",
					"value"             	=> "0",
					"min"               	=> "-50",
					"max"               	=> "200",
					"step"              	=> "1",
					"unit"             	 	=> 'px',
					"description"       	=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "nouislider",
					"heading"           	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
					"param_name"        	=> "margin_bottom",
					"value"             	=> "0",
					"min"               	=> "-50",
					"max"               	=> "200",
					"step"              	=> "1",
					"unit"              	=> 'px',
					"description"       	=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "textfield",
					"heading"           	=> __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"        	=> "el_id",
					"value"             	=> "",
					"description"       	=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"              	=> "textfield",
					"heading"           	=> __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"        	=> "el_class",
					"value"             	=> "",
					"description"       	=> __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				// Load Custom CSS/JS File
				array(
					"type"					=> "load_file",
					"heading"				=> __( "", "ts_visual_composer_extend" ),
					"value"					=> "",
					"param_name"			=> "el_file1",
					"file_type"				=> "js",
					"file_path"				=> "js/ts-visual-composer-extend-element.min.js",
					"description"			=> __( "", "ts_visual_composer_extend" )
				),
				array(
					"type"					=> "load_file",
					"heading"				=> __( "", "ts_visual_composer_extend" ),
					"value"					=> "",
					"param_name"			=> "el_file2",
					"file_type"				=> "css",
					"file_id"				=> "ts-extend-animations",
					"file_path"				=> "css/ts-visual-composer-extend-animations.min.css",
					"description"			=> __( "", "ts_visual_composer_extend" )
				),
			))
		);
	}
?>