<?php
	global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                      => __( "TS Icon Title", "ts_visual_composer_extend" ),
            "base"                      => "TS-VCSC-Icon-Title",
            "icon" 	                    => "icon-wpb-ts_vcsc_icon_title",
            "class"                     => "",
            "category"                  => __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"               => __("Place an icon or image title", "ts_visual_composer_extend"),
			"js_view"     				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorLivePreview == "true" ? "TS_VCSC_IconTitleViewCustom" : ""),
            "admin_enqueue_js"			=> "",
            "admin_enqueue_css"			=> "",
            "params"                    => array(
                // Icon Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_1",
                    "seperator"			=> "Icon Settings",
					"value"				=> "",
                    "description"       => __( "", "ts_visual_composer_extend" )
                ),
				array(
					"type"              => "switch_button",
                    "heading"           => __( "Use Normal Image", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_replace",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to either use a font icon or a normal image.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
				),
				array(
					'type' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorType,
					'heading' 			=> __( 'Select Icon', 'ts_visual_composer_extend' ),
					'param_name' 		=> 'icon',
					'value'				=> '',
					'source'			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorValue,
					'settings' 			=> array(
						'emptyIcon' 			=> true,
						'type' 					=> 'extensions',
						'iconsPerPage' 			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorPager,
						'source' 				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorSource,
					),
					"admin_label"       => true,
					"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon for your icon title.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
					"dependency"        => array( 'element' => "icon_replace", 'value' => 'false' )
				),			
                array(
                    "type"              => "attach_image",
                    "heading"           => __( "Select Image", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_image",
                    "value"             => "false",
                    "description"       => __( "Image must have equal dimensions for scaling purposes (i.e. 100x100).", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_replace", 'value' => 'true' )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image Size", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_size_slide",
                    "value"             => "30",
                    "min"               => "16",
                    "max"               => "512",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the icon / image size", "ts_visual_composer_extend" ),
                    "dependency"        => ""
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Icon / Image Position", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_location",
                    "width"             => 150,
                    "value"             => array(
                        __( 'Left', "ts_visual_composer_extend" )     => "left",
                        __( 'Right', "ts_visual_composer_extend" )    => "right",
                        __( 'Top', "ts_visual_composer_extend" )      => "top",
                        __( 'Bottom', "ts_visual_composer_extend" )   => "bottom"),
                    "description"       => __( "Select how to position the icon / image in relation to the title wording.", "ts_visual_composer_extend" ),
                    "admin_label"       => true,
                    "dependency"        => ""
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image to Text Spacing", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_margin",
                    "value"             => "10",
                    "min"               => "0",
                    "max"               => "50",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define the space between the icon / image and the icon title content.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image to Side Spacing", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_spacing",
                    "value"             => "0",
                    "min"               => "0",
                    "max"               => "50",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define an additional spacing between the icon / image and the element side it is aligned to.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "icon_location", 'value' => array('left', 'right') ),
                ),
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Icon Color", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_color",
                    "value"             => "#cccccc",
                    "description"       => __( "Define the color of the icon.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_replace", 'value' => 'false' )
                ),
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Icon / Image Background Color", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_background",
                    "value"             => "",
                    "description"       => __( "Define the background color for the icon / transparent image.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Icon / Image Border Type", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_frame_type",
                    "width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset"
					),
                    "description"       => __( "Select the type of border around the icon / image.", "ts_visual_composer_extend" ),
                    "dependency"        => ""
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image Border Thickness", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_frame_thick",
                    "value"             => "1",
                    "min"               => "1",
                    "max"               => "10",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define the thickness of the icon / image border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Icon / Image Border Radius", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_frame_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
						__( "Full Circle", "ts_visual_composer_extend" )                   => "ts-radius-full"
					),
                    "description"       => __( "Define the radius of the icon / image border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
                ),
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Icon / Image Frame Border Color", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_frame_color",
                    "value"             => "#000000",
                    "description"       => __( "Define the color of the icon / image border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_frame_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values )
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Icon / Image Padding", "ts_visual_composer_extend" ),
                    "param_name"        => "icon_padding",
                    "value"             => "0",
                    "min"               => "0",
                    "max"               => "50",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define an additional padding for the icon / image.", "ts_visual_composer_extend" ),
                ),
                // Icon Title Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_2",
                    "seperator"			=> "Title Content",
					"value"				=> "",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "textfield",
                    "heading"           => __( "Title", "ts_visual_composer_extend" ),
                    "param_name"        => "title",
                    "value"             => "",
                    "admin_label"       => true,
                    "description"       => __( "Enter the icon title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Align", "ts_visual_composer_extend" ),
                    "param_name"        => "align",
                    "width"             => 150,
					"value"             => array(
						__( "Left", "ts_visual_composer_extend" )                          => "left",
						__( "Center", "ts_visual_composer_extend" )                        => "center",
						__( "Right", "ts_visual_composer_extend" )                         => "right",
					),
                    "description"       => __( "Select how to align the icon title text.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "icon_location", 'value' => array('left', 'right') ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Title Spacing", "ts_visual_composer_extend" ),
                    "param_name"        => "title_spacing",
                    "value"             => "0",
                    "min"               => "0",
                    "max"               => "50",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define an additional spacing between the title and the element side it is aligned to.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "align", 'value' => array('left', 'right') ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "fontsmanager",
                    "heading"           => __( "Font Family", "ts_visual_composer_extend" ),
                    "param_name"        => "font_family",
                    "value"             => "",
					"default"			=> "true",
					"connector"			=> "font_type",
                    "description"       => __( "Select the font to be used for the icon title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "hidden_input",
                    "param_name"        => "font_type",
                    "value"             => "",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),	
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Font Color", "ts_visual_composer_extend" ),
                    "param_name"        => "color",
                    "value"             => "#393836",
                    "description"       => __( "Define the color for the icon title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Font Size", "ts_visual_composer_extend" ),
                    "param_name"        => "size",
                    "value"             => "30",
                    "min"               => "12",
                    "max"               => "70",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the font size for the icon title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Font Weight", "ts_visual_composer_extend" ),
                    "param_name"        => "font_weight",
                    "width"             => 150,
                    "value"             => array(
                        __( 'Default', "ts_visual_composer_extend" )  => "inherit",
                        __( 'Bold', "ts_visual_composer_extend" )     => "bold",
                        __( 'Bolder', "ts_visual_composer_extend" )   => "bolder",
                        __( 'Normal', "ts_visual_composer_extend" )   => "normal",
                        __( 'Light', "ts_visual_composer_extend" )    => "300",
                    ),
                    "description"       => __( "Select the font weight for the icon title text.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Content",
                ),
                // Title Design Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_3",
                    "seperator"			=> "Title Design",
					"value"				=> "",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Title Design",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Title Background Style", "ts_visual_composer_extend" ),
                    "param_name"        => "title_background_type",
                    "width"             => 300,
					"value"             => array(
						__( "Solid Color", "ts_visual_composer_extend" )                   => "color",
						__( "Background Pattern", "ts_visual_composer_extend" )            => "pattern",
					),
                    "description"       => __( "Select the type of background to be applied to the icon title.", "ts_visual_composer_extend" ),
					"group" 			=> "Title Design",
                ),
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Title Background Color", "ts_visual_composer_extend" ),
                    "param_name"        => "title_background_color",
                    "value"             => "",
                    "description"       => __( "Define the background color for the icon title.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_background_type", 'value' => 'color' ),
					"group" 			=> "Title Design",
                ),
				array(
					"type"              => "switch_button",
                    "heading"           => __( "Strikethrough Pattern?", "ts_visual_composer_extend" ),
                    "param_name"        => "style",
                    "value"             => "true",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle to show or hide a strikethrough pattern with the icon title.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_background_type", 'value' => 'color' ),
					"group" 			=> "Title Design",
				),
                array(
                    "type"              => "background",
                    "heading"           => __( "Background Pattern", "ts_visual_composer_extend" ),
                    "param_name"        => "title_background_pattern",
                    "height"            => 200,
                    "pattern"           => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Background_List,
					"value"				=> "",
                    "encoding"          => "false",
                    "description"       => __( "Select the background pattern for your icon title.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_background_type", 'value' => 'pattern' ),
					"group" 			=> "Title Design",
                ),
				// Border Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_4",
                    "seperator"			=> "Border Style",
					"value"				=> "",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Title Design",
                ),
				array(
					"type"				=> "switch_button",
					"heading"           => __( "Advanced Border Settings", "ts_visual_composer_extend" ),
					"param_name"        => "title_border_controls",
					"value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
					"description"       => __( "Switch the toggle to either use the basic or advanced border setting controls.", "ts_visual_composer_extend" ),
                    "group" 			=> "Title Design",
				),	
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Title Border Style", "ts_visual_composer_extend" ),
                    "param_name"        => "title_border_type",
                    "width"             => 300,
                    "value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
						__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
						__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
						__( "Double Border", "ts_visual_composer_extend" )                 => "double",
						__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
						__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
						__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
						__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
					),
                    "description"       => __( "Select the type of border for the icon title.", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "title_border_controls", 'value' => 'false' ),
					"group" 			=> "Title Design",
                ),
				array(
					"type"              => "switch_button",
                    "heading"           => __( "Bottom Border Only?", "ts_visual_composer_extend" ),
                    "param_name"        => "title_border_bottom",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if the border should be applied to the bottom of the icon title only.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Title Design",
				),
                array(
                    "type"              => "colorpicker",
                    "heading"           => __( "Title Border Color", "ts_visual_composer_extend" ),
                    "param_name"        => "title_border_color",
                    "value"             => "#cccccc",
                    "description"       => __( "Define the color of the icon title border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Title Design",
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Title Border Thickness", "ts_visual_composer_extend" ),
                    "param_name"        => "title_border_thick",
                    "value"             => "1",
                    "min"               => "1",
                    "max"               => "10",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Define the thickness of the icon title border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Title Design",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Title Border Radius", "ts_visual_composer_extend" ),
                    "param_name"        => "title_border_radius",
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Small Radius", "ts_visual_composer_extend" )                  => "ts-radius-small",
						__( "Medium Radius", "ts_visual_composer_extend" )                 => "ts-radius-medium",
						__( "Large Radius", "ts_visual_composer_extend" )                  => "ts-radius-large",
					),
                    "description"       => __( "Select the radius for the icon title border.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "title_border_type", 'value' => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Border_Type_Values ),
					"group" 			=> "Title Design",
                ),
				array(
					"type" 					=> "advanced_styling",
					"heading" 				=> __("Box Border Settings", "ts_visual_composer_extend"),
					"param_name" 			=> "title_border_setting",
					"style_type"			=> "border",
					"show_main"				=> "false",
					"show_preview"			=> "true",
					"show_width"			=> "true",
					"show_style"			=> "true",
					"show_radius" 			=> "true",					
					"show_color"			=> "true",
					"show_unit_width"		=> "true",
					"show_unit_radius"		=> "true",			
					"default_positions"		=> array(
						//__("All", "ts_visual_composer_extend")     		=> array("width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Top", "ts_visual_composer_extend")     			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Right", "ts_visual_composer_extend")   			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Bottom", "ts_visual_composer_extend")  			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
						__("Left", "ts_visual_composer_extend")    			=> array("width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					),
					"description"       	=> __( "Define the border settings for each side and corner of the element.", "ts_visual_composer_extend" ),
					"dependency"        	=> array( 'element' => "title_border_controls", 'value' => 'true' ),
					"group" 				=> "Title Design",
				),	
                // Animation Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_5",
					"value"				=> "",
                    "seperator"			=> "Animations",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
				array(
					"type"              => "switch_button",
                    "heading"           => __( "Add Animations / Shadow", "ts_visual_composer_extend" ),
                    "param_name"        => "animations",
                    "value"             => "false",
					"on"				=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"				=> __( 'No', "ts_visual_composer_extend" ),
					"style"				=> "select",
					"design"			=> "toggle-light",
                    "description"       => __( "Switch the toggle if you want to apply animations or a shadow to the icon box.", "ts_visual_composer_extend" ),
                    "dependency"        => "",
					"group" 			=> "Other Settings",
				),
				array(
					"type"				=> "css3animations",
					"class"				=> "",
					"heading"			=> __("Icon / Image Hover Animation", "ts_visual_composer_extend"),
					"param_name"		=> "animation_icon",
					"standard"			=> "false",
					"prefix"			=> "ts-hover-css-",
					"connector"			=> "css3animations_in",
					"noneselect"		=> "true",
					"default"			=> "",
					"value"				=> "",
					"admin_label"		=> false,
					"description"		=> __("Select the hover animation for the icon / image.", "ts_visual_composer_extend"),
					"dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
				),
				array(
					"type"				=> "hidden_input",
					"heading"			=> __( "Icon / Image Hover Animation", "ts_visual_composer_extend" ),
					"param_name"		=> "css3animations_in",
					"value"				=> "",
					"admin_label"		=> true,
					"description"		=> __( "", "ts_visual_composer_extend" ),
					"dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
				),	
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Title Hover Effect", "ts_visual_composer_extend" ),
                    "param_name"        => "animation_title",
                    "width"             => 300,
                    "value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Tilt Up", "ts_visual_composer_extend" )                       => "ts-css-effect1",
						__( "Tilt Left", "ts_visual_composer_extend" )                     => "ts-css-effect2",
						__( "Tilt Right", "ts_visual_composer_extend" )                    => "ts-css-effect3",
						__( "Tilt Left (Up)", "ts_visual_composer_extend" )                => "ts-css-effect4",
						__( "Tilt Right (Down)", "ts_visual_composer_extend" )             => "ts-css-effect5",
						__( "Grow Out", "ts_visual_composer_extend" )                      => "ts-css-effect6",
					),
                    "description"       => __( "Select the hover animation for the icon title.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Title Shadow Effect", "ts_visual_composer_extend" ),
                    "param_name"        => "animation_shadow",
                    "width"             => 300,
					"value"             => array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Lifted", "ts_visual_composer_extend" )                        => "lifted",
						__( "Raised", "ts_visual_composer_extend" )                        => "raised",
						__( "Perspective - Right", "ts_visual_composer_extend" )           => "perspective-right",
						__( "Perspective - Left", "ts_visual_composer_extend" )            => "perspective-left",
						__( "Curved - Horizontal", "ts_visual_composer_extend" )           => "curved",
						__( "Curved - Horizontal (Top)", "ts_visual_composer_extend" )     => "curved-top",
						__( "Curved - Horizontal (Bottom)", "ts_visual_composer_extend" )  => "curved-bottom",
						__( "Curved - Vertical", "ts_visual_composer_extend" )             => "curved-vertical",
						__( "Curved - Vertical (Left)", "ts_visual_composer_extend" )      => "curved-vertical-left",
						__( "Curved - Vertical (Right)", "ts_visual_composer_extend" )     => "curved-vertical-right",
					),
                    "description"       => __( "Select the shadow effect for the icon title; requires a title background.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "dropdown",
                    "heading"           => __( "Viewport Animation", "ts_visual_composer_extend" ),
                    "param_name"        => "animation_view",
					"value"             =>  array(
						__( "None", "ts_visual_composer_extend" )                          => "",
						__( "Top to Bottom", "ts_visual_composer_extend" )                 => "top-to-bottom",
						__( "Bottom to Top", "ts_visual_composer_extend" )                 => "bottom-to-top",
						__( "Left to Right", "ts_visual_composer_extend" )                 => "left-to-right",
						__( "Right to Left", "ts_visual_composer_extend" )                 => "right-to-left",
						__( "Appear from Center", "ts_visual_composer_extend" )            => "appear",
					),
                    "description"       => __( "Select the viewport animation for the icon title.", "ts_visual_composer_extend" ),
                    "dependency"        => array( 'element' => "animations", 'value' => 'true' ),
					"group" 			=> "Other Settings",
                ),
                // Other Icon Title Settings
                array(
                    "type"              => "seperator",
                    "heading"           => __( "", "ts_visual_composer_extend" ),
                    "param_name"        => "seperator_6",
                    "seperator"			=> "Other Settings",
					"value"				=> "",
                    "description"       => __( "", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
                    "param_name"        => "margin_top",
                    "value"             => "0",
                    "min"               => "-50",
                    "max"               => "500",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "nouislider",
                    "heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
                    "param_name"        => "margin_bottom",
                    "value"             => "20",
                    "min"               => "-50",
                    "max"               => "500",
                    "step"              => "1",
                    "unit"              => 'px',
                    "description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "textfield",
                    "heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
                    "param_name"        => "el_id",
                    "value"             => "",
                    "description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
                array(
                    "type"              => "textfield",
                    "heading"           => __( "Extra Class Name", "ts_visual_composer_extend" ),
                    "param_name"        => "el_class",
                    "value"             => "",
                    "description"       => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 			=> "Other Settings",
                ),
                // Load Custom CSS/JS File
				array(
					"type"				=> "load_file",
					"heading"			=> __( "", "ts_visual_composer_extend" ),
					"value"				=> "",
					"param_name"		=> "el_file1",
					"file_type"			=> "js",
					"file_path"			=> "js/ts-visual-composer-extend-element.min.js",
					"description"		=> __( "", "ts_visual_composer_extend" )
				),
				array(
					"type"				=> "load_file",
					"heading"			=> __( "", "ts_visual_composer_extend" ),
					"value"				=> "",
					"param_name"		=> "el_file2",
					"file_type"			=> "css",
					"file_id"			=> "ts-extend-animations",
					"file_path"			=> "css/ts-visual-composer-extend-animations.min.css",
					"description"		=> __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>