<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
    if (function_exists('vc_map')) {
        vc_map( array(
            "name"                      	=> __( "TS Image SVG", "ts_visual_composer_extend" ),
            "base"                      	=> "TS_VCSC_Image_SVG",
            "icon" 	                    	=> "icon-wpb-ts_vcsc_image_svg",
            "class"                     	=> "",
            "category"                  	=> __( "VC Extensions", "ts_visual_composer_extend" ),
            "description"               	=> __("Place an image with SVG effects", "ts_visual_composer_extend"),
            "admin_enqueue_js"        		=> "",
            "admin_enqueue_css"       		=> "",
            "params"                    	=> array(
                // Image Settings
                array(
                    "type"              	=> "seperator",
                    "heading"           	=> __( "", "ts_visual_composer_extend" ),
                    "param_name"        	=> "seperator_1",
					"value"					=> "",
                    "seperator"         	=> "Image Settings",
                    "description"       	=> __( "", "ts_visual_composer_extend" )
                ),
				array(
                    "type"                  => "attach_image",
					"holder" 				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? "img" : ""),
                    "heading"               => __( "Select Image", "ts_visual_composer_extend" ),
                    "param_name"            => "image",
					"class"					=> "ts_vcsc_holder_image",
                    "value"                 => "",
                    "admin_label"           => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? false : true),
					"description"           => __( "Select the image for the element.", "ts_visual_composer_extend" ),
					"dependency"            => ""
				),
				array(
					"type"                  => "dropdown",
					"heading"               => __( "Preview Image Source", "ts_visual_composer_extend" ),
					"param_name"            => "content_image_size",
					"width"                 => 150,
					"value"                 => array(
						__( 'Medium Size Image', "ts_visual_composer_extend" )			=> "medium",
						__( 'Large Size Image', "ts_visual_composer_extend" )			=> "large",
						__( 'Full Size Image', "ts_visual_composer_extend" )			=> "full",
					),
					"description"           => __( "Select which image size based on WordPress settings should be used for the preview image.", "ts_visual_composer_extend" ),
					"dependency"            => ""
				),
				array(
					"type"                  => "dropdown",
					"heading"               => __( "SVG Style", "ts_visual_composer_extend" ),
					"param_name"            => "style",
					"width"                 => 150,
					"value"                 => array(
						__( 'Style 1', "ts_visual_composer_extend" )						=> "imagesvg1",
						__( 'Style 2', "ts_visual_composer_extend" )						=> "imagesvg2",
						__( 'Style 3', "ts_visual_composer_extend" )						=> "imagesvg3",
						__( 'Style 4', "ts_visual_composer_extend" )						=> "imagesvg4",
						__( 'Style 5', "ts_visual_composer_extend" )						=> "imagesvg5",
					),
					"admin_label"           => true,
					"description"           => __( "Select which SVG style should be applied to the image.", "ts_visual_composer_extend" ),
					"dependency"            => ""
				),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "SVG Background Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "color_fill",
					"value"             	=> "#ffffff",
					"description"       	=> __( "Define the background color for the SVG shape.", "ts_visual_composer_extend" ),
					"dependency"			=> "",
				),
				array(
					"type"					=> "switch_button",
                    "heading"           	=> __( "Apply Grayscale Effect", "ts_visual_composer_extend" ),
                    "param_name"        	=> "grayscale",
                    "value"             	=> "true",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"       	=> __( "Switch the toggle if you want to apply a grayscale effect to the image.", "ts_visual_composer_extend" ),
                    "dependency"        	=> ""
				),
				// Link Settings
                array(
                    "type"              	=> "seperator",
                    "heading"           	=> __( "", "ts_visual_composer_extend" ),
                    "param_name"        	=> "seperator_2",
					"value"					=> "",
                    "seperator"         	=> "Link Settings",
                    "description"       	=> __( "", "ts_visual_composer_extend" )
                ),
				array(
					"type"                  => "dropdown",
					"heading"               => __( "Button Link", "ts_visual_composer_extend" ),
					"param_name"            => "trigger",
					"width"                 => 150,
					"value"                 => array(
						__( 'Open Image in Lightbox', "ts_visual_composer_extend" )			=> "image",
						__( 'Open Other Page', "ts_visual_composer_extend" )				=> "link",
					),
					"admin_label"           => true,
					"description"           => __( "Select the action that should be triggered when clicking on the button.", "ts_visual_composer_extend" ),
					"dependency"            => ""
				),
				array(
					"type"					=> "switch_button",
                    "heading"           	=> __( "Link Full Element", "ts_visual_composer_extend" ),
                    "param_name"        	=> "link_container",
                    "value"             	=> "false",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"       	=> __( "Switch the toggle if you want to apply the link to the full element instead of just the button.", "ts_visual_composer_extend" ),
                    "dependency"        	=> ""
				),
				array(
					"type" 					=> "vc_link",
					"heading" 				=> __("Link + Title", "ts_visual_composer_extend"),
					"param_name" 			=> "link",
					"description" 			=> __("Provide a link to another site/page for the Icon Button.", "ts_visual_composer_extend"),
					"dependency"			=> array( 'element' => "trigger", 'value' => 'link' )
				),
				array(
					"type"                  => "dropdown",
					"heading"               => __( "Lightbox Image Source", "ts_visual_composer_extend" ),
					"param_name"            => "lightbox_size",
					"width"                 => 150,
					"value"                 => array(
						__( 'Full Size Image', "ts_visual_composer_extend" )			=> "full",
						__( 'Large Size Image', "ts_visual_composer_extend" )			=> "large",
						__( 'Medium Size Image', "ts_visual_composer_extend" )			=> "medium",
					),
					"description"           => __( "Select which image size based on WordPress settings should be used for the lightbox image.", "ts_visual_composer_extend" ),
					"dependency"			=> array( 'element' => "trigger", 'value' => 'image' )
				),
				// Content Settings
                array(
                    "type"              	=> "seperator",
                    "heading"           	=> __( "", "ts_visual_composer_extend" ),
                    "param_name"        	=> "seperator_3",
					"value"					=> "",
                    "seperator"         	=> "Content",
                    "description"       	=> __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Content",
                ),
				array(
					"type"              	=> "textfield",
					"heading"           	=> __( "Title", "ts_visual_composer_extend" ),
					"param_name"        	=> "text_title",
					"value"             	=> "",
					"description"       	=> __( "Enter a title for the element.", "ts_visual_composer_extend" ),
					"dependency"        	=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Title Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "color_title",
					"value"             	=> "#3498db",
					"description"       	=> __( "Define the color of the title text.", "ts_visual_composer_extend" ),
					"dependency"			=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "textarea",
					"heading"           	=> __( "Message", "ts_visual_composer_extend" ),
					"param_name"        	=> "text_content",
					"value"             	=> "",
					"description"       	=> __( "Enter a message for the element; will be shortened to one line inside element but can be shown in full via tooltip.", "ts_visual_composer_extend" ),
					"dependency"        	=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Message Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "color_text",
					"value"             	=> "#333333",
					"description"       	=> __( "Define the color of the message text.", "ts_visual_composer_extend" ),
					"dependency"			=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "textfield",
					"heading"           	=> __( "Button Text", "ts_visual_composer_extend" ),
					"param_name"        	=> "text_button",
					"value"             	=> "",
					"description"       	=> __( "Enter the button text to be used for the element.", "ts_visual_composer_extend" ),
					"dependency"        	=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Button Text Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "color_button_text",
					"value"             	=> "#333333",
					"description"       	=> __( "Define the color of the text in the button.", "ts_visual_composer_extend" ),
					"dependency"			=> "",
					"group" 				=> "Content",
				),
				array(
					"type"              	=> "colorpicker",
					"heading"           	=> __( "Button Background Color", "ts_visual_composer_extend" ),
					"param_name"        	=> "color_button_back",
					"value"             	=> "#ffffff",
					"description"       	=> __( "Define the background color for the button.", "ts_visual_composer_extend" ),
					"dependency"			=> array( 'element' => "style", 'value' => array('imagesvg1', 'imagesvg2', 'imagesvg3', 'imagesvg4') ),
					"group" 				=> "Content",
				),				
                // Tooltip Settings
				array(
					"type"				    => "seperator",
					"heading"			    => __( "", "ts_visual_composer_extend" ),
					"param_name"		    => "seperator_4",
					"value"					=> "",
					"seperator"				=> "Image Tooltip",
					"description"		    => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Tooltip",
				),
				array(
					"type"					=> "switch_button",
                    "heading"           	=> __( "Use Tooltip", "ts_visual_composer_extend" ),
                    "param_name"        	=> "content_tooltip",
                    "value"             	=> "true",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"       	=> __( "Switch the toggle if you want to show the full title and description via tooltip as well.", "ts_visual_composer_extend" ),
                    "dependency"        	=> "",
					"group" 				=> "Tooltip",
				),
				array(
					"type"				    => "dropdown",
					"class"				    => "",
					"heading"			    => __( "Tooltip Position", "ts_visual_composer_extend" ),
					"param_name"		    => "content_tooltip_position",
                    "value"                 => array(
                        __("Top", "ts_visual_composer_extend")                    	=> "ts-simptip-position-top",
                        __("Bottom", "ts_visual_composer_extend")                 	=> "ts-simptip-position-bottom",
                        __("Left", "ts_visual_composer_extend")                    	=> "ts-simptip-position-left",
                        __("Right", "ts_visual_composer_extend")                 	=> "ts-simptip-position-right",
                    ),
					"description"		    => __( "Select the tooltip position in relation to the player.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
					"group" 				=> "Tooltip",
				),
				array(
					"type"					=> "nouislider",
					"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltipster_offsetx",
					"value"					=> "0",
					"min"					=> "-100",
					"max"					=> "100",
					"step"					=> "1",
					"unit"					=> 'px',
					"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
					"group" 				=> "Tooltip",
				),
				array(
					"type"					=> "nouislider",
					"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
					"param_name"			=> "tooltipster_offsety",
					"value"					=> "0",
					"min"					=> "-100",
					"max"					=> "100",
					"step"					=> "1",
					"unit"					=> 'px',
					"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "content_tooltip", 'value' => 'true' ),
					"group" 				=> "Tooltip",
				),				
                // Lightbox Settings
                array(
                    "type"                  => "seperator",
                    "heading"               => __( "", "ts_visual_composer_extend" ),
                    "param_name"            => "seperator_5",
					"value"					=> "",
                    "seperator"				=> "Lightbox Settings",
                    "description"           => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Lightbox",
                ),
				array(
					"type"              	=> "switch_button",
					"heading"			    => __( "Create AutoGroup", "ts_visual_composer_extend" ),
					"param_name"		    => "lightbox_group",
					"value"				    => "true",
					"on"					=> __( 'Yes', "ts_visual_composer_extend" ),
					"off"					=> __( 'No', "ts_visual_composer_extend" ),
					"style"					=> "select",
					"design"				=> "toggle-light",
					"description"		    => __( "Switch the toggle if you want the plugin to group this image with all other non-gallery images on the page.", "ts_visual_composer_extend" ),
					"dependency"        	=> "",
					"group" 				=> "Lightbox",
				),
                array(
                    "type"                  => "textfield",
                    "heading"               => __( "Group Name", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_group_name",
                    "value"                 => "",
                    "admin_label"           => true,
                    "description"           => __( "Enter a custom group name to manually build group with other non-gallery items.", "ts_visual_composer_extend" ),
                    "dependency"            => array( 'element' => "lightbox_group", 'value' => 'false' ),
					"group" 				=> "Lightbox",
                ),		
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Transition Effect", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_effect",
                    "width"                 => 150,
                    "value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Lightbox_Animations,
                    "description"           => __( "Select the transition effect to be used for the image in the lightbox.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Lightbox",
                ),
                array(
                    "type"                  => "dropdown",
                    "heading"               => __( "Backlight Effect", "ts_visual_composer_extend" ),
                    "param_name"            => "lightbox_backlight",
                    "width"                 => 150,
                    "value"                 => array(
						__( 'Auto Color', "ts_visual_composer_extend" )       											=> "auto",
						__( 'Custom Color', "ts_visual_composer_extend" )     											=> "custom",
						__( 'No Backlight (only for simple Black Lightbox Overlay)', "ts_visual_composer_extend" )     	=> "hideit",
                    ),
                    "description"           => __( "Select the backlight effect for the image.", "ts_visual_composer_extend" ),
                    "dependency"            => "",
					"group" 				=> "Lightbox",
                ),
				array(
					"type"                  => "colorpicker",
					"heading"               => __( "Custom Backlight Color", "ts_visual_composer_extend" ),
					"param_name"            => "lightbox_backlight_color",
					"value"                 => "#ffffff",
					"description"           => __( "Define the backlight color for the lightbox image.", "ts_visual_composer_extend" ),
					"dependency"            => array( 'element' => "lightbox_backlight", 'value' => 'custom' ),
					"group" 				=> "Lightbox",
				),				
				// Other Settings
				array(
					"type"				    => "seperator",
					"heading"			    => __( "", "ts_visual_composer_extend" ),
					"param_name"		    => "seperator_6",
					"value"					=> "",
					"seperator"				=> "Other Settings",
					"description"		    => __( "", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Margin: Top", "ts_visual_composer_extend" ),
                    "param_name"            => "margin_top",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "200",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
                ),
                array(
                    "type"                  => "nouislider",
                    "heading"               => __( "Margin: Bottom", "ts_visual_composer_extend" ),
                    "param_name"            => "margin_bottom",
                    "value"                 => "0",
                    "min"                   => "0",
                    "max"                   => "200",
                    "step"                  => "1",
                    "unit"                  => 'px',
                    "description"           => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
                ),
				array(
					"type"                  => "textfield",
					"heading"               => __( "Define ID Name", "ts_visual_composer_extend" ),
					"param_name"            => "el_id",
					"value"                 => "",
					"description"           => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				array(
					"type"                  => "textfield",
					"heading"               => __( "Extra Class Name", "ts_visual_composer_extend" ),
					"param_name"            => "el_class",
					"value"                 => "",
					"description"           => __( "Enter a class name for the element.", "ts_visual_composer_extend" ),
					"group" 				=> "Other Settings",
				),
				// Load Custom CSS/JS File
				array(
					"type"              	=> "load_file",
					"heading"           	=> __( "", "ts_visual_composer_extend" ),
                    "param_name"        	=> "el_file",
					"value"             	=> "",
					"file_type"         	=> "js",
					"file_path"         	=> "js/ts-visual-composer-extend-element.min.js",
					"description"       	=> __( "", "ts_visual_composer_extend" )
				),
            ))
        );
    }
?>