<?php

if ( !class_exists( 'ICWP_WPSF_Processor_Headers' ) ):

	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'base_wpsf.php' );

	class ICWP_WPSF_Processor_Headers extends ICWP_WPSF_Processor_BaseWpsf {

		/**
		 * @var bool
		 */
		protected $bHeadersPushed;

		/**
		 * @var array
		 */
		protected $aHeaders;

		/**
		 */
		public function run() {
			if ( $this->getPushHeadersEarly() ) {
				$this->pushHeaders();
			}
			else {
				add_filter( 'wp_headers', array( $this, 'addToHeaders' ) );
			}
		}

		/**
		 * @return bool
		 */
		protected function getPushHeadersEarly() {
			return defined( 'WPCACHEHOME' ); //WP Super Cache
		}

		/**
		 */
		protected function pushHeaders() {
			if ( !$this->isHeadersPushed() ) {
				$aHeaders = $this->gatherSecurityHeaders();
				foreach ( $aHeaders as $sHeader => $sValue ) {
					header( sprintf( '%s: %s', $sHeader, $sValue ) );
				}
				$this->setHeadersPushed( true );
			}
		}

		/**
		 * @param array $aCurrentWpHeaders
		 * @return array
		 */
		public function addToHeaders( $aCurrentWpHeaders ) {
			if ( !$this->isHeadersPushed() ) {
				$aCurrentWpHeaders = array_merge( $aCurrentWpHeaders, $this->gatherSecurityHeaders() );
				$this->setHeadersPushed( true );
			}
			return $aCurrentWpHeaders;
		}

		protected function setXFrameHeader() {
			$sXFrame = $this->getOption( 'x_frame' );
			switch ( $sXFrame ) {
				case 'on_sameorigin':
					$sXFrameOption = 'SAMEORIGIN';
					break;
				case 'on_deny':
					$sXFrameOption = 'DENY';
					break;
				default:
					$sXFrameOption = '';
					break;
			}
			if ( !empty( $sXFrameOption ) ) {
				return array( 'x-frame-options' => $sXFrameOption );
			}
			return null;
		}

		protected function setXssProtectionHeader() {
			if ( $this->getIsOption( 'x_xss_protect', 'Y' ) ) {
				return array( 'X-XSS-Protection' => '1; mode=block' );
			}
			return null;
		}

		protected function setContentTypeOptionHeader() {
			if ( $this->getIsOption( 'x_content_type', 'Y' ) ) {
				return array( 'X-Content-Type-Options' => 'nosniff' );
			}
			return null;
		}

		/**
		 * @return array|null
		 */
		protected function setContentSecurityPolicyHeader() {
			/** @var ICWP_WPSF_FeatureHandler_Headers $oFO */
			$oFO = $this->getFeature();
			if ( !$oFO->getIsContentSecurityPolicyEnabled() ) {
				return null;
			}

			$sTemplate = 'default-src %s;';

			$aDefaultSrcDirectives = array();

			if ( $oFO->getOptIs( 'xcsp_self', 'Y' ) ) {
				$aDefaultSrcDirectives[] = "'self'";
			}
			if ( $oFO->getOptIs( 'xcsp_data', 'Y' ) ) {
				$aDefaultSrcDirectives[] = "data:";
			}
			if ( $oFO->getOptIs( 'xcsp_inline', 'Y' ) ) {
				$aDefaultSrcDirectives[] = "'unsafe-inline'";
			}
			if ( $oFO->getOptIs( 'xcsp_eval', 'Y' ) ) {
				$aDefaultSrcDirectives[] = "'unsafe-eval'";
			}
			if ( $oFO->getOptIs( 'xcsp_https', 'Y' ) ) {
				$aDefaultSrcDirectives[] = "https:";
			}

			$aDomains = $oFO->getCspHosts();
			if ( !empty( $aDomains ) && is_array( $aDomains ) ) {
				$aDefaultSrcDirectives[] = implode( " ", $aDomains );
			}
			return array( 'Content-Security-Policy' => sprintf( $sTemplate, implode( " ", $aDefaultSrcDirectives ) ) );
		}

		/**
		 * @return array
		 */
		protected function gatherSecurityHeaders() {
			/** @var ICWP_WPSF_FeatureHandler_Headers $oFO */
			$oFO = $this->getFeature();

			$this->addHeader( $this->setXFrameHeader() );
			$this->addHeader( $this->setXssProtectionHeader() );
			$this->addHeader( $this->setContentTypeOptionHeader() );
			if ( $oFO->getIsContentSecurityPolicyEnabled() ) {
				$this->addHeader( $this->setContentSecurityPolicyHeader() );
			}
			return $this->getHeaders();
		}

		/**
		 * @return array
		 */
		private function getHeaders() {
			if ( !isset( $this->aHeaders ) || !is_array( $this->aHeaders ) ) {
				$this->aHeaders = array();
			}
			return $this->aHeaders;
		}

		/**
		 * @param string $aHeader
		 */
		private function addHeader( $aHeader ) {
			if ( !empty( $aHeader ) && is_array( $aHeader ) ) {
				$this->aHeaders = array_merge( $this->getHeaders(), $aHeader );
			}
		}

		/**
		 * @return bool
		 */
		protected function isHeadersPushed() {
			return (bool)$this->bHeadersPushed;
		}

		/**
		 * @param bool $bHeadersPushed
		 * @return $this
		 */
		protected function setHeadersPushed( $bHeadersPushed ) {
			$this->bHeadersPushed = $bHeadersPushed;
			return $this;
		}
	}

endif;