<?php 
/* 
* Template Name: Africa Twin Page
*/

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<?php while ( have_posts() ) : the_post(); ?>
                <?php get_template_part( 'content', 'page' ); ?>

                <?php
                    // If comments are open or we have at least one comment, load up the comment template
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;
                ?>

            <?php endwhile; // end of the loop. ?>

        </main><!-- #main -->
    </div><!-- #primary -->
    
<script>
    $(function() {
        var $allVideos = $("iframe[src*='//player.vimeo.com'], iframe[src*='//www.youtube.com'], object, embed"),
        $fluidEl = $("div.modal-dialog");
        $allVideos.each(function() {
          $(this)
            // jQuery .data does not work on object/embed elements
            .attr('data-aspectRatio', this.height / this.width)
            .removeAttr('height')
            .removeAttr('width');
        
        });
        
        $(window).resize(function() {
          var newWidth = $fluidEl.width();
          $allVideos.each(function() {
            var $el = $(this);
            $el
                .width(newWidth)
                .height(newWidth * $el.attr('data-aspectRatio'));     
          });
        }).resize();
    });
</script>
    
<div id="TrailerModal" class="modal fade trailer" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Honda Africa Twin</h4>
            </div>
            <div class="modal-body">
                <iframe id="TrailerVideo" width="100%" height="349" src="http://www.youtube.com/embed/OPf0YbXqDm0" frameborder="0" allowfullscreen></iframe>
            </div>
        </div>
    </div>
</div>

<div id="fullpage">
    <div class="section" id="section0">
        <section class="">
            <div class="container">
                <div align="middle">
                    <img src="img/title.png" class="img-responsive">
                </div>
                <div class="col-md-8 col-md-offset-2">
                    <hr class="white-lines">
                </div>
                <div class="col-md-12" align="middle">
                    <!-- <a href="" class="text-center">
                        <img src="img/playfull.png">
                    </a> -->

                    <a type="button" data-toggle="modal" data-target="#TrailerModal">
                        <img src="img/playfull.png">
                    </a>
                </div>

                <!-- <div align="middle">
              <img src="img/triangle.png">
            </div> -->
            </div>
        </section>
    </div><!-- /#section0 -->

    <div class="section" id="section1">
        <div class="container">
            <div class="col-md-10 col-md-offset-1">
                <div class="col-md-6">
                    <h2 class="bold">AFRICA TWIN</h2>
                    <h2 class="thin">TRUE ADVENTURE</h2>
                    <p class="desc-txt">
                
                    </p>
                    <div class="prod-details">
                        <h2 class="bold">PRODUCT<a class="thin"> DETAILS</a></h2>
                        <table class="prod-table">
                            <tr>
                                <td>Product Name</td>
                                <td class="space-between">&nbsp;:&nbsp;</td>
                                <td>CRF 1000 L Africa Twin </td>
                            </tr>
                            <tr>
                                <td>Type</td>
                                <td class="space-between">&nbsp;:&nbsp;</td>
                                <td>Adventure Sport, 1000 series</td>
                            </tr>
                            <tr>
                                <td>Price (OTR Jakarta)</td>
                                <td class="space-between">&nbsp;:&nbsp;</td>
                                <td>diinformasikan lagi</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <!-- <div align="middle">
                <img src="img/bike.png" class="img-responsive">
              </div>
              <div class="color-det">
                <h2 class="bold">COLOR<a class="thin"> DETAILS</a></h2>
                <p class="color-row">
                  <a href=""><img src="img/color1.png"></a>
                  <a href=""><img src="img/color2.png"></a>
                </p>
              </div> -->
                    <div id="main_area">
                        <!-- Slider -->
                        <div class="row">
                            <div class="col-xs-12" id="slider">
                                <!-- Top part of the slider -->
                                <div class="row">
                                    <div class="col-sm-12 nopadding" id="carousel-bounding-box">
                                        <div class="carousel slide" id="myCarousel2">
                                            <!-- Carousel items -->
                                            <div class="carousel-inner">
                                                <div class="active item" data-slide-number="0">
                                                    <img src="img/bike-blue-red-white.png"></div>

                                                <div class="item" data-slide-number="1">
                                                    <img src="img/bike-red-white.png"></div>
                                            </div><!-- Carousel nav -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!--/Slider-->

                        <div class="row" id="slider-thumbs">
                            <!-- Bottom switcher of slider -->
                            <h2 class="bold">COLOR<a class="thin"> DETAILS</a></h2>
                            <ul class="hide-bullets">
                                <li class="col-sm-2 col-xs-4">
                                    <a class="thumbnail block-select" id="carousel-selector2-0"><img src="img/color1.png"></a>
                                </li>

                                <li class="col-sm-2 col-xs-4">
                                    <a class="thumbnail block-select" id="carousel-selector2-1"><img src="img/color2.png"></a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="section" id="section2">
        <div class="container">

            <div id="main_area">
                <!-- Slider -->
                <div class="col-md-10 col-md-offset-1">
                    <div align="middle" class="img-title">
                        <img src="img/prodfeat.png" class="img-responsive">
                    </div>
                    <div class="col-sm-6 mobilegutter" id="slider-thumbs">
                        <!-- Bottom switcher of slider -->
                        <ul class="hide-bullets">
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-0">
                                    <div class="prev-block" style="background: url('img/1-hstc.png');"></div>
                                </a>
                            </li>
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-1">
                                    <div class="prev-block" style="background: url('img/2-Gswitch.png');"></div>
                                </a>
                            </li>
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-2">
                                    <div class="prev-block" style="background: url('img/3-largewheel.png');"></div>
                                </a>
                            </li>
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-3">
                                    <div class="prev-block" style="background: url('img/4-dualled.png');"></div>
                                </a>
                            </li>
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-4">
                                    <div class="prev-block" style="background: url('img/5-lcd.png');"></div>
                                </a>
                            </li>
                            <li class="col-xs-6 mobilegutter">
                                <a class="thumbnail" id="carousel-selector-5">
                                    <div class="prev-block" style="background: url('img/6-1000CC.png');"></div>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-sm-6">
                        <div class="col-xs-12 mobilegutter" id="slider">
                            <!-- Top part of the slider -->
                            <div class="row">
                                <div class="col-sm-12 mobilegutter spacing-top" id="carousel-bounding-box">
                                    <div class="carousel slide" id="myCarousel">
                                        <!-- Carousel items -->
                                        <div class="carousel-inner">
                                            <div class="active item" data-slide-number="0">
                                                <img src="img/1-det.png">
                                            </div>
                                            <div class="item" data-slide-number="1">
                                                <img src="img/2-det.png">
                                            </div>
                                            <div class="item" data-slide-number="2">
                                                <img src="img/3-det.png">
                                            </div>
                                            <div class="item" data-slide-number="3">
                                                <img src="img/4-det.png">
                                            </div>
                                            <div class="item" data-slide-number="4">
                                                <img src="img/5-det.png">
                                            </div>
                                            <div class="item" data-slide-number="5">
                                                <img src="img/6-det.png">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/Slider-->
                </div>

            </div>
        </div>
    </div>

    <div class="section" id="section3">
        <div class="container">
            <div id="main_area">
                <!-- Slider -->
                <div class="col-md-10 col-md-offset-1 specs-sect">
                    <div align="middle" class="img-title">
                        <img src="img/specs.png" class="img-responsive">
                    </div>
                    <div class="col-md-10 col-md-offset-1 mobilegutter">
                        <div class="tab-specs">
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <li role="presentation" class="active"><a href="#engine" aria-controls="home" role="tab" data-toggle="tab">ENGINE</a></li>
                                <li role="presentation"><a href="#capacity" aria-controls="profile" role="tab" data-toggle="tab">DRIVE TRAIN</a></li>
                                <li role="presentation"><a href="#dimension" aria-controls="messages" role="tab" data-toggle="tab">CHASSIS</a></li>
                                <li role="presentation"><a href="#chassis" aria-controls="settings" role="tab" data-toggle="tab">DIMENSION</a></li>
                                <li role="presentation"><a href="#other" aria-controls="settings" role="tab" data-toggle="tab">OTHER</a></li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane active" id="engine">
                                    <table class="table table-responsive">
                                        <tbody>
                                        <tr>
                                            <td class="heads">
                                                Engine Type
                                            </td>
                                            <td class="contents">
                                                Liquid cooled SOHC, 4 stroke, 4 valve per cylinder, parallel twin with 270° crank and uni cam
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Engine Displacement
                                            </td>
                                            <td class="contents">
                                                998 cm3
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Bore x Stroke
                                            </td>
                                            <td class="contents">
                                                92.0 x 75.1 mm
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Max Power Output
                                            </td>
                                            <td class="contents">
                                                70 kW/ 7,500 rpm
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Max Torque
                                            </td>
                                            <td class="contents">
                                                98 Nm/ 6,000 rpm
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Compression Ratio
                                            </td>
                                            <td class="contents">
                                                10:01
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Fuel Consumption
                                            </td>
                                            <td class="contents">
                                                WMTC MT: 21.7 km/l, DCT: 21.8 km/l
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Fuel Supply System
                                            </td>
                                            <td class="contents">
                                                PGM-FI
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="capacity">
                                    <table class="table table-responsive">
                                        <tbody>
                                        <tr>
                                            <td class="heads">
                                                Transmission
                                            </td>
                                            <td class="contents">
                                                MT [6speed] Constant Mesh  6-Speed and DCT
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Final Drive
                                            </td>
                                            <td class="contents">
                                                O-Ring Sealed Chain
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="dimension">
                                    <table class="table table-responsive">
                                        <tbody>
                                        <tr>
                                            <td class="heads">
                                                Frame Type
                                            </td>
                                            <td class="contents">
                                                Steel Semi Double Cradle
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Suspension Type Front
                                            </td>
                                            <td class="contents">
                                                Show 45mm cartridge type inverted telescopic fork with dial style preload adjuster and DF adjustment, 230mm stroke.
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Suspension Type Rear
                                            </td>
                                            <td class="contents">
                                                Mono block cast aluminum swing arm with Pro Link with gas charged damper, hydraulic dial style preload adjuster and rebound damping adjustment, 220 mm rear wheel travel.
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Brake type front
                                            </td>
                                            <td class="contents">
                                                310mm dual wave floating disc with aluminum hub and radial fit 4piston calipers and sintered metal pads.
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Brake Type Rear
                                            </td>
                                            <td class="contents">
                                                256mm wave disc with 1piston caliper and sintered metal pads. Lever Lock Type Parking Brake System on DCT model with additional slide type 1 piston Caliper.
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Braking System
                                            </td>
                                            <td class="contents">
                                                ABS* 2Channel with rear ABS off switch
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Tire Size Front
                                            </td>
                                            <td class="contents">
                                                90/90 - 21 tube type
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Tire Size Rear
                                            </td>
                                            <td class="contents">
                                                150/70- 18 tube type
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Fuel Tank Capacity
                                            </td>
                                            <td class="contents">
                                                18.8 liters
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="chassis">
                                    <table class="table table-responsive">
                                        <tbody>
                                        <tr>
                                            <td class="heads">
                                                Overall ( LxWxH )
                                            </td>
                                            <td class="contents">
                                                2,335 x 875 x 1,475mm (STD),<br>2,335 x 930 x 1,475mm (ABS/DCT)
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Wheelbase
                                            </td>
                                            <td class="contents">
                                                1575 mm
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Ground Clearance
                                            </td>
                                            <td class="contents">
                                                250 mm
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Seat Height
                                            </td>
                                            <td class="contents">
                                                850 mm (low), 870 mm (high)
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Curb Height
                                            </td>
                                            <td class="contents">
                                                232 Kg (ABS), 242 kg(DCT)
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="other">
                                    <table class="table table-responsive">
                                        <tbody>
                                        <tr>
                                            <td class="heads">
                                                Instrument
                                            </td>
                                            <td class="contents">
                                                Rally style negative LCD instrument display including: Speedometer, Tachometer, Fuel, Gear position, *ABS, *HSTC, Odometer, Trip and Clock *denotes ABS/DCT type
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="heads">
                                                Starter
                                            </td>
                                            <td class="contents">
                                                Electric
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="section" id="section4">
        <div class="gallery">
            <div class="container" id="main_area">
                <!-- Slider -->
                <div class="col-md-10 col-md-offset-1">
                    <div align="middle" class="img-title">
                        <img src="img/gallery.png" class="img-responsive">
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="gallery-row">
                <div class="left-side">
                    <a href="" data-toggle="modal" data-target="#aft1" style="outline:none"><div class="box-big-full">
                        <div style="background: url('img/aft1-455.jpg');" class="inner-box-big-full"></div>
                    </div></a>
                </div>
                <div class="right-side">
                    <a href="" data-toggle="modal" data-target="#aft2" style="outline:none"><div class="box-big-half">
                        <div style="background: url('img/aft2-255.jpg');" class="inner-box-big-half"></div>
                    </div></a>
                    <a href="" data-toggle="modal" data-target="#aft3" style="outline:none"><div class="box-big-half">
                        <div style="background: url('img/aft3-255.jpg');" class="inner-box-big-half"></div>
                    </div></a>
                    <a href="" data-toggle="modal" data-target="#aft4" style="outline:none"><div class="box-big-half">
                        <div style="background: url('img/aft4-255.jpg');" class="inner-box-big-half"></div>
                    </div></a>
                    <a href="" data-toggle="modal" data-target="#aft5" style="outline:none"><div class="box-big-half">
                        <div style="background: url('img/aft5-255.jpg');" class="inner-box-big-half"></div>
                    </div></a>
                </div>
                <div class="right-side-2">
                    <a href="" data-toggle="modal" data-target="#aft6" style="outline:none"><div class="box-big-full">
                        <div style="background: url('img/aft6-700.jpg');" class="inner-box-big-full"></div>
                    </div></a>
                </div>
            </div>
        </div>
        
        <div class="clearfix"></div>
        <section class="footer">
            <div class="container">
                <div class="col-md-4 col-xs-12" align="middle">
                    <img src="img/logo-footer2.jpg" class="img-responsive">
                </div>
                <div class="col-xs-6 col-md-2 menu-foot">
                    <ul>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> Home</a></li>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> Product</a></li>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> Dealer</a></li>
                    </ul>
                </div>
                <div class="col-xs-6 col-md-2 menu-foot">
                    <ul>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> Video</a></li>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> News</a></li>
                        <li><a href=""><i class="fa fa-chevron-right" aria-hidden="true"></i> Contact Us</a></li>
                    </ul>
                </div>
                <div class="col-md-4 col-xs-12 left-center">
                    <p class="download-row">
                        Download <img src="img/logo-footer.png"> app at :
                    </p>
                    <p><a href=""><img src="img/googlePlay.png"></a></p>
                    <p><a href=""><img src="img/appleStore.png"></a></p>
                </div>
            </div>
            <div class="container foot-last">
                <div class="col-md-6 left-center">
                    <p>&copy;2017 Honda Big Bikes. All Rights Reserved</p>
                </div>
                <div class="col-md-6 right-center">
                    <p class="socials">
                        <a href=""><i class="fa fa-facebook-official" aria-hidden="true"></i></a>
                        <a href=""><i class="fa fa-twitter" aria-hidden="true"></i></a>
                        <a href=""><i class="fa fa-instagram" aria-hidden="true"></i></a>
                        <a href=""><i class="fa fa-youtube" aria-hidden="true"></i></a>
                    </p>
                </div>
            </div>
        </section>
    </div>
</div>

<div class="modal fade" id="aft1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft1.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="aft2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft2.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="aft3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft3.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="aft4" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft4.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="aft5" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft5.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="aft6" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img src="img/aft6.jpg" class="img-responsive"/>
            </div>
        </div>
    </div>
</div>
<!-- Page Content -->

<script type="text/javascript" src="js/scrolloverflow.min.js"></script>
<script type="text/javascript" src="js/jquery.fullPage.min.js"></script>

<!-- Bootstrap Core JavaScript -->
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#myCarousel2').carousel({
            interval: 5000
        });
        //Handles the carousel thumbnails
        $('[id^=carousel-selector2-]').click(function () {
            var id_selector = $(this).attr("id");
            try {
                var id = /-(\d+)$/.exec(id_selector)[1];
                console.log(id_selector, id);
                jQuery('#myCarousel2').carousel(parseInt(id));
            } catch (e) {
                console.log('Regex failed!', e);
            }
        });
        // When the carousel slides, auto update the text
        $('#myCarousel2').on('slid.bs.carousel', function (e) {
            var id = $('.item.active').data('slide-number');
            $('#carousel-text').html($('#slide-content-'+id).html());
        });
    });
</script>
<script type="text/javascript">
    jQuery(document).ready(function($) {
        $('#myCarousel').carousel({
            interval: 5000
        });
        //Handles the carousel thumbnails
        $('[id^=carousel-selector-]').click(function () {
            var id_selector = $(this).attr("id");
            try {
                var id = /-(\d+)$/.exec(id_selector)[1];
                console.log(id_selector, id);
                jQuery('#myCarousel').carousel(parseInt(id));
            } catch (e) {
                console.log('Regex failed!', e);
            }
        });
        // When the carousel slides, auto update the text
        $('#myCarousel').on('slid.bs.carousel', function (e) {
            var id = $('.item.active').data('slide-number');
            $('#carousel-text').html($('#slide-content-'+id).html());
        });
    });
</script>
<script type="text/javascript">
    $('#myTabs a').click(function (e) {
        e.preventDefault()
        $(this).tab('show')
    });

    $('#fullpage').fullpage({
        css3: true,
        fixedElements: 'nav',
        anchors:['section-1', 'section-2', 'section-3', 'section-4', 'section-5'],
        slideSelector: '.horizontal_slide',
        scrollOverflow: true,
        scrollBar: true,
        // scrollOverflowReset: true,
        // scrollOverflowResetKey: 'cGFuZW5tYXlhLmNvbV8xTXJjMk55YjJ4c1QzWmxjbVpzYjNkU1pYTmxkQT09eGpP'
    });
</script>
<script type="text/javascript">
        $(document).ready(function(){
            /* Get iframe src attribute value i.e. YouTube video url and store it in a variable */
            var url = $("#TrailerVideo").attr('src');
            
            /* Assign empty url value to the iframe src attribute when modal hide, which stop the video playing */
            $("#TrailerModal").on('hide.bs.modal', function(){
                $("#TrailerVideo").attr('src', '');
            });
            
            /* Assign the initially stored url back to the iframe src attribute when modal is displayed again */
            $("#TrailerModal").on('show.bs.modal', function(){
                $("#TrailerVideo").attr('src', url);
            });
        });
</script>

<?php get_footer(); ?>
