<?php 
/*
* Category Template
*/
get_header();

?>

<div class="product-top">
	<div class="container">	
		<div class="single-title pull-left"><h6>News & Society</h6></div>
		<div class="breadcrumb pull-right"><?php the_breadcrumb(); ?></div>
		<div class="clearfix"></div>
	</div>
</div>

<div class="container">

<?php 
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	$cat = new WP_Query(
	array(
		'category_name'	=> 'news-activity',
		'posts_per_page'	=> 4,
		'paged' => $paged
	)
); ?>
<?php while($cat->have_posts()) : $cat->the_post(); ?>
	<div class="cat-post">
		<div class="col-lg-6 cat-left">
			<div class="cats-thumb">
				<?php 
					if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
					the_post_thumbnail('cat-thumb',array( 'class' => 'img-responsive img-rounded' ));
					} 
				?>
			</div>
		</div>

		<div class="col-lg-6 cat-right">
			<h4>
				<?php
					$title = get_the_title();
					echo string_limit_words($title,6);
				?>
			</h4>
			<div class="sum-post">
				<?php
					$excerpt = get_the_excerpt();
					echo string_limit_words($excerpt,60);
				?>
			</div>
			<div class="view-detail"><a href="<?php the_permalink(); ?>">View Details</a></div>
		</div>
		<div class="clearfix"></div>

	</div>

<?php endwhile; ?>

<div class="paginate" align="center"><?php wp_pagenavi( array( 'query' => $cat, 'options' => PageNavi_Core::$options->get_defaults() ) ); ?></div>

<?php wp_reset_postdata(); ?>


<?php get_footer(); ?>