<?php get_header(); ?>
<div class="product-top">
    <div class="container">         
        <div class="single-title pull-left"><h6>Product Detail</h6></div>
        <div class="breadcrumb pull-right"><?php the_breadcrumb(); ?></div>
        <div class="clearfix"></div>
    </div>
</div>

<div class="container">
    <div class="product-title">
        <h4><?php the_title(); ?></h4>
    </div>
    <div class="product-slider">
        <div id="carousel" class="carousel slide" data-ride="carousel">
            <div class="carousel-inner">
                <?php foreach( get_cfc_meta( 'productslider' ) as $key => $value ){ ?>
                <div class="item"><img src="<?php the_cfc_field( 'productslider','slideproduct', false, $key ); ?>"></div><!-- item active -->
                <?php } ?>
            </div><!-- carousel-inner -->
            
            <ol class="carousel-indicators">
                <?php foreach( get_cfc_meta( 'productslider' ) as $key => $value ){ ?>
                    <li data-target="#carousel" data-slide-to="<?php echo $key++; ?>"></li>
                <?php } ?>
            </ol>
            <a class="left carousel-control" href="#carousel" data-slide="prev"><i class="fa fa-angle-double-left"></i></a>
            <a class="right carousel-control" href="#carousel" data-slide="next"><i class="fa fa-angle-double-right"></i></a>
        </div><!-- #carousel -->
    </div>

    <div class="first-single">
        <div class="post-content col-lg-8">
            <?php while (have_posts()) : the_post(); ?>
                <?php the_content(); ?>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>

        <div class="post-sidebar col-lg-4">
            <h5><strong>Product Details</strong></h5>
            <table class="table table-hover">
                <tbody>
                    <tr>
                        <th scope="row">Product Name</th>
                        <td>: <?php the_cfc_field('productsdetails','product-name'); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Type</th>
                        <td>: <?php the_cfc_field('productsdetails','category'); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Available Color</th>
                        <td>: <?php the_cfc_field('productsdetails','available-color'); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Download Brochure</th>
                        <td>: <a class="download-link" href="<?php the_cfc_field('priductsdetails', 'download'); ?>"><i class="fa fa-download fa-fw"></i> Download</a></td>
                    </tr>
                    <tr>
                        <th scope="row">Price (OTR Jakarta)</th>
                        <td>: <?php /*the_cfc_field('productsdetails','price');*/ ?>Coming Soon</td>
                    </tr>
                </tbody>
            </table>
            <div class="color-image">
                
            </div>
        </div>
        <div class="clearfix"></div>
    </div>

    <div role="tabpanel" class="product-spek col-lg-12"><!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#spek-1" aria-controls="spek-1" role="tab" data-toggle="tab">
                    <?php the_cfc_field('productspecifications', 'title-spec-1'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#spek-2" aria-controls="spek-2" role="tab" data-toggle="tab">
                    <?php the_cfc_field('productspecifications','title-spec-2'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#spek-3" aria-controls="spek-3" role="tab" data-toggle="tab">
                    <?php the_cfc_field('productspecifications','title-spec-3'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#spek-4" aria-controls="spek-4" role="tab" data-toggle="tab">
                    <?php the_cfc_field('productspecifications','title-spec-4'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#spek-5" aria-controls="spek-5" role="tab" data-toggle="tab">
                    <?php the_cfc_field('productspecifications','title-spec-5'); ?>
                </a>
            </li>
        </ul>       <!-- Tab panes -->      

        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="spek-1">
                <?php the_cfc_field('productspecifications','content-spec-1'); ?>
            </div>
            <div role="tabpanel" class="tab-pane" id="spek-2">
                <?php the_cfc_field('productspecifications','content-spec-2'); ?>
            </div>
            <div role="tabpanel" class="tab-pane" id="spek-3">
                <?php the_cfc_field('productspecifications','content-spec-3'); ?>
            </div>
            <div role="tabpanel" class="tab-pane" id="spek-4">
                <?php the_cfc_field('productspecifications','content-spec-4'); ?>
            </div>
            <div role="tabpanel" class="tab-pane" id="spek-5">
                <?php the_cfc_field('productspecifications','content-spec-5'); ?>
            </div>
        </div>
    </div>  
    <div class="clearfix"></div>

    <div class="product-gallery col-lg-12">
        <div class="gallery-title"><h4>Product Gallery</h4></div>
        <div class="gallery row">
            <?php foreach( get_cfc_meta( 'productgallery' ) as $key => $value ){ ?>
            <div class="col-lg-3 gallery-thumb">
                <a href="#" data-toggle="modal" data-target="#gallery-modal-<?php echo $key; ?>">
                    <img src="<?php the_cfc_field('productgallery','image-upload', false, $key); ?>">
                </a>
            </div>
                
            <div class="modal fade" id="gallery-modal-<?php echo $key; ?>">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="close-btn"><a href="#" data-dismiss="modal" aria-label="Close"><i class="fa fa-close fa-2x"></i></a></div>
                            <img src="<?php the_cfc_field('productgallery','image-upload', false, $key); ?>">
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->
            <?php } ?>
        </div>
    </div>

</div>

<?php get_footer(); ?>