<?php get_header(); ?>
<?php 
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;	
	$media = new WP_Query(	
		array(		
			'post_type'			=> 'video',
			'posts_per_page'	=> 6,
			'paged'				=> $paged
		)
); ?>
	<div class="product-top">
		<div class="container">
			<div class="single-title pull-left"><h6>Media Center</h6></div>
			<div class="breadcrumb pull-right"><?php the_breadcrumb(); ?></div>
			<div class="clearfix"></div>
		</div>
	</div>

	<div class="container media-center">
		<div align="center">
		<?php while($media->have_posts()) : $media->the_post(); ?>
		<div class="col-lg-6">
			<div class="embed-responsive embed-responsive-16by9">
				<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/<?php the_cfc_field('videomedia','video-id'); ?>"></iframe>		
			</div>
			<div class="product-title">
				<h4><?php the_title(); ?></h4>
			</div>
		</div>
		<?php endwhile; ?>

		<div class="paginate" align="center">
			<?php wp_pagenavi( 
				array( 
					'query' => $media,
					'options' => PageNavi_Core::$options->get_defaults() 
				) 
			); ?>
		</div>
		<?php wp_reset_postdata(); ?>
		<div class="clearfix"></div>
	</div>
<?php get_footer(); ?>